/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.ajp;

import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.http.ajp.AjpConfiguration;
import com.sun.grizzly.http.ajp.AjpHttpRequest;
import com.sun.grizzly.http.ajp.AjpHttpResponse;
import com.sun.grizzly.http.ajp.AjpInputBuffer;
import com.sun.grizzly.http.ajp.AjpOutputBuffer;
import com.sun.grizzly.http.ajp.ShutdownHandler;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.IOException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AjpProcessorTask
extends ProcessorTask {
    private static final Logger logger = SelectorThread.logger();
    private final AjpConfiguration ajpConfiguration;

    public AjpProcessorTask(AjpConfiguration ajpConfiguration, boolean initialize) {
        super(initialize, false);
        this.ajpConfiguration = ajpConfiguration;
    }

    public AjpConfiguration getAjpConfiguration() {
        return this.ajpConfiguration;
    }

    protected Request createRequest() {
        return new AjpHttpRequest();
    }

    protected Response createResponse() {
        return new AjpHttpResponse();
    }

    protected InternalInputBuffer createInputBuffer(Request request, int requestBufferSize) {
        return new AjpInputBuffer(this.ajpConfiguration, request, requestBufferSize);
    }

    public void sendHeaders() {
        ((AjpOutputBuffer)this.outputBuffer).sendHeaders();
    }

    protected SocketChannelOutputBuffer createOutputBuffer(Response response, int sendBufferSize, boolean bufferResponse) {
        return new AjpOutputBuffer(response, sendBufferSize, bufferResponse);
    }

    public boolean parseRequest() throws Exception {
        ((AjpInputBuffer)this.inputBuffer).readAjpMessageHeader();
        return super.parseRequest();
    }

    public void invokeAdapter() {
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        switch (ajpRequest.getType()) {
            case 2: {
                ajpRequest.setForwardRequestProcessing(true);
                if (ajpRequest.isExpectContent()) {
                    try {
                        ((AjpInputBuffer)this.request.getInputBuffer()).parseDataChunk();
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Exception during parsing data chunk on connection: " + this.key.channel(), e);
                        }
                        this.error = true;
                    }
                }
                super.invokeAdapter();
                break;
            }
            case 7: {
                this.processShutdown();
                break;
            }
            case 10: {
                try {
                    this.processCPing();
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Exception during sending CPONG reply on connection: " + this.key.channel(), e);
                    }
                    this.error = true;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid packet type: " + ajpRequest.getType());
            }
        }
    }

    private void processShutdown() {
        String secret;
        if (!this.ajpConfiguration.isShutdownEnabled()) {
            throw new IllegalStateException("Shutdown is disabled");
        }
        AjpHttpRequest ajpRequest = (AjpHttpRequest)this.request;
        String shutdownSecret = null;
        if (ajpRequest.getLength() > 1) {
            MessageBytes tmpMessageBytes = ajpRequest.tmpMessageBytes;
            ((AjpInputBuffer)this.inputBuffer).getBytesToMB(tmpMessageBytes);
            shutdownSecret = tmpMessageBytes.toString();
            tmpMessageBytes.recycle();
        }
        if ((secret = this.ajpConfiguration.getSecret()) != null && secret.equals(shutdownSecret)) {
            throw new IllegalStateException("Secret doesn't match, no shutdown");
        }
        Queue<ShutdownHandler> shutdownHandlers = this.ajpConfiguration.getShutdownHandlers();
        for (ShutdownHandler handler : shutdownHandlers) {
            try {
                handler.onShutdown(this.key.channel());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception during ShutdownHandler execution", e);
            }
        }
    }

    private void processCPing() throws IOException {
        AjpHttpResponse.writeCPongReply(this.outputStream);
        this.outputStream.flush();
    }

    public void setBufferSize(int requestBufferSize) {
        if (requestBufferSize < 16384) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Buffer size is set to {0} instead of {1} for performance reasons", new Object[]{16384, requestBufferSize});
            }
            requestBufferSize = 16384;
        }
        super.setBufferSize(requestBufferSize);
    }
}

