/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.buf;

import com.sun.grizzly.util.Charsets;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.IntermediateInputStream;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.ReadConvertor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class B2CConverterBlocking {
    private static final Logger logger = LoggerUtils.getLogger();
    private IntermediateInputStream iis;
    private ReadConvertor conv;
    private String encoding;
    static final int BUFFER_SIZE = 8192;
    char[] result = new char[8192];
    private final int debug = 0;

    protected B2CConverterBlocking() {
    }

    public B2CConverterBlocking(String encoding) throws IOException {
        this.encoding = encoding;
        this.reset();
    }

    public void recycle() {
        this.conv.recycle();
    }

    public void convert(ByteChunk bb, CharChunk cb) throws IOException {
        this.convert(bb, cb, cb.getBuffer().length - cb.getEnd());
    }

    public void convert(ByteChunk bb, CharChunk cb, int limit) throws IOException {
        this.iis.setByteChunk(bb);
        try {
            int bbLengthBeforeRead = 0;
            while (limit > 0) {
                int size = limit < 8192 ? limit : 8192;
                bbLengthBeforeRead = bb.getLength();
                int cnt = this.conv.read(this.result, 0, size);
                if (cnt <= 0) {
                    return;
                }
                cb.append(this.result, 0, cnt);
                limit -= bbLengthBeforeRead - bb.getLength();
            }
        }
        catch (IOException ex) {
            this.reset();
            throw ex;
        }
    }

    public static void convertASCII(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        int length = bc.getLength();
        cc.allocate(length, -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, length);
    }

    public void reset() throws IOException {
        this.iis = new IntermediateInputStream();
        this.conv = new ReadConvertor(this.iis, Charsets.lookupCharset(this.encoding));
    }

    void log(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "B2CConverter: " + s);
        }
    }
}

