/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.moxy;

import com.sun.jersey.core.util.FeaturesAndProperties;
import com.sun.jersey.moxy.Helper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;

@Provider
public class MoxyContextResolver
implements ContextResolver<JAXBContext> {
    public static final String PROPERTY_MOXY_OXM_PACKAGE_NAMES = "com.sun.jersey.moxy.config.property.packages";
    public static final String PROPERTY_MOXY_OXM_MAPPING_URL = "com.sun.jersey.moxy.config.property.oxm.mapping.url";
    final Set<String> oxmPackageNames = new HashSet<String>();
    final String oxmMappingUrl;

    public MoxyContextResolver(@Context FeaturesAndProperties fap) {
        this.oxmPackageNames.addAll(this.getPackageNames(fap.getProperty(PROPERTY_MOXY_OXM_PACKAGE_NAMES)));
        this.oxmMappingUrl = this.getStringValue(fap.getProperty(PROPERTY_MOXY_OXM_MAPPING_URL));
    }

    private String getStringValue(Object u) {
        if (u == null) {
            return null;
        }
        if (u instanceof String) {
            return (String)u;
        }
        throw new IllegalArgumentException("com.sun.jersey.moxy.config.property.oxm.mapping.url must have a property value of type String");
    }

    private List<String> getPackageNames(Object p) {
        if (p == null) {
            return Collections.EMPTY_LIST;
        }
        if (p instanceof String) {
            return Arrays.asList(Helper.getElements(new String[]{(String)p}));
        }
        if (p instanceof String[]) {
            return Arrays.asList(Helper.getElements((String[])p));
        }
        throw new IllegalArgumentException("com.sun.jersey.moxy.config.property.packages must have a property value of type String or String[]");
    }

    @Override
    public JAXBContext getContext(Class<?> type2) {
        String typePackageName = type2.getPackage().getName();
        if (!this.oxmPackageNames.contains(typePackageName)) {
            return null;
        }
        HashMap<String, StreamSource> metadata = new HashMap<String, StreamSource>();
        metadata.put(typePackageName, this.oxmMappingUrl != null ? new StreamSource(this.oxmMappingUrl) : new StreamSource(type2.getResourceAsStream("eclipselink-oxm.xml")));
        HashMap<String, HashMap<String, StreamSource>> properties = new HashMap<String, HashMap<String, StreamSource>>();
        properties.put("eclipselink-oxm-xml", metadata);
        try {
            return JAXBContext.newInstance((String)typePackageName, (ClassLoader)Thread.currentThread().getContextClassLoader(), properties);
        }
        catch (JAXBException ex) {
            throw new WebApplicationException(ex);
        }
    }
}

