/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.wadl.generators;

import com.sun.jersey.api.JResponse;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.server.wadl.ApplicationDescription;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.server.wadl.WadlGeneratorImpl;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.Representation;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class WadlGeneratorJAXBGrammarGenerator
implements WadlGenerator {
    private static final Logger LOG = Logger.getLogger(WadlGeneratorJAXBGrammarGenerator.class.getName());
    private static final Set<Class> SPECIAL_GENERIC_TYPES = new HashSet<Class>(){
        {
            this.add(JResponse.class);
            this.add(List.class);
        }
    };
    private WadlGenerator _delegate = new WadlGeneratorImpl();
    private Set<Class> _seeAlso;
    private List<Pair> _hasTypeWantsName;

    private static final HasType parameter(final Parameter param) {
        return new HasType(){

            @Override
            public Class getPrimaryClass() {
                return param.getParameterClass();
            }

            @Override
            public Type getType() {
                return param.getParameterType();
            }
        };
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    @Override
    public String getRequiredJaxbContextPath() {
        return this._delegate.getRequiredJaxbContextPath();
    }

    @Override
    public void init() throws Exception {
        this._delegate.init();
        this._seeAlso = new HashSet<Class>();
        this._hasTypeWantsName = new ArrayList<Pair>();
    }

    @Override
    public Application createApplication() {
        return this._delegate.createApplication();
    }

    @Override
    public Method createMethod(AbstractResource ar, AbstractResourceMethod arm) {
        return this._delegate.createMethod(ar, arm);
    }

    @Override
    public Request createRequest(AbstractResource ar, AbstractResourceMethod arm) {
        return this._delegate.createRequest(ar, arm);
    }

    @Override
    public Param createParam(AbstractResource ar, AbstractMethod am, Parameter p) {
        final Param param = this._delegate.createParam(ar, am, p);
        if (p.getSource() == Parameter.Source.ENTITY) {
            this._hasTypeWantsName.add(new Pair(WadlGeneratorJAXBGrammarGenerator.parameter(p), new WantsName(){

                @Override
                public void setName(QName name) {
                    param.setType(name);
                }
            }));
        }
        return param;
    }

    @Override
    public Representation createRequestRepresentation(AbstractResource ar, AbstractResourceMethod arm, MediaType mt) {
        final Representation rt = this._delegate.createRequestRepresentation(ar, arm, mt);
        for (Parameter p : arm.getParameters()) {
            if (p.getSource() != Parameter.Source.ENTITY) continue;
            this._hasTypeWantsName.add(new Pair(WadlGeneratorJAXBGrammarGenerator.parameter(p), new WantsName(){

                @Override
                public void setName(QName name) {
                    rt.setElement(name);
                }
            }));
        }
        return rt;
    }

    @Override
    public Resource createResource(AbstractResource ar, String path) {
        Class<?> cls = ar.getResourceClass();
        XmlSeeAlso seeAlso = cls.getAnnotation(XmlSeeAlso.class);
        if (seeAlso != null) {
            Collections.addAll(this._seeAlso, seeAlso.value());
        }
        return this._delegate.createResource(ar, path);
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }

    @Override
    public List<Response> createResponses(AbstractResource ar, final AbstractResourceMethod arm) {
        List<Response> responses = this._delegate.createResponses(ar, arm);
        if (responses != null) {
            HasType hasType = new HasType(){

                @Override
                public Class getPrimaryClass() {
                    return arm.getReturnType();
                }

                @Override
                public Type getType() {
                    return arm.getGenericReturnType();
                }
            };
            for (Response response : responses) {
                for (final Representation representation : response.getRepresentation()) {
                    this._hasTypeWantsName.add(new Pair(hasType, new WantsName(){

                        @Override
                        public void setName(QName name) {
                            representation.setElement(name);
                        }
                    }));
                }
            }
        }
        return responses;
    }

    @Override
    public WadlGenerator.ExternalGrammarDefinition createExternalGrammar() {
        HashMap<String, ApplicationDescription.ExternalGrammar> extraFiles = new HashMap<String, ApplicationDescription.ExternalGrammar>();
        WadlGenerator.Resolver resolver = this.buildModelAndSchemas(extraFiles);
        WadlGenerator.ExternalGrammarDefinition previous = this._delegate.createExternalGrammar();
        previous.map.putAll(extraFiles);
        if (resolver != null) {
            previous.addResolver(resolver);
        }
        return previous;
    }

    private WadlGenerator.Resolver buildModelAndSchemas(Map<String, ApplicationDescription.ExternalGrammar> extraFiles) {
        HashSet<Class> classSet = new HashSet<Class>(this._seeAlso);
        for (Pair pair : this._hasTypeWantsName) {
            Type parameterType;
            Type type2;
            HasType hasType = pair.hasType;
            Class clazz = hasType.getPrimaryClass();
            if (clazz.getAnnotation(XmlRootElement.class) != null) {
                classSet.add(clazz);
                continue;
            }
            if (!SPECIAL_GENERIC_TYPES.contains(clazz) || !((type2 = hasType.getType()) instanceof ParameterizedType) || !((parameterType = ((ParameterizedType)type2).getActualTypeArguments()[0]) instanceof Class)) continue;
            classSet.add((Class)parameterType);
        }
        JAXBIntrospector introspector = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])classSet.toArray(new Class[classSet.size()]));
            final ArrayList results = new ArrayList();
            context.generateSchema(new SchemaOutputResolver(){
                int counter = 0;

                public Result createOutput(String namespaceUri, String suggestedFileName) {
                    StreamResult result = new StreamResult(new CharArrayWriter());
                    result.setSystemId("xsd" + this.counter++ + ".xsd");
                    results.add(result);
                    return result;
                }
            });
            for (StreamResult result : results) {
                CharArrayWriter writer = (CharArrayWriter)result.getWriter();
                byte[] contents = writer.toString().getBytes("UTF8");
                extraFiles.put(result.getSystemId(), new ApplicationDescription.ExternalGrammar(MediaType.APPLICATION_XML_TYPE, contents));
            }
            introspector = context.createJAXBIntrospector();
        }
        catch (JAXBException e) {
            LOG.log(Level.SEVERE, "Failed to generate the schema for the JAX-B elements", e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to generate the schema for the JAX-B elements due to an IO error", e);
        }
        if (introspector != null) {
            final JAXBIntrospector copy = introspector;
            return new WadlGenerator.Resolver(){

                @Override
                public QName resolve(Class type2) {
                    Object parameterClassInstance = null;
                    try {
                        parameterClassInstance = type2.newInstance();
                    }
                    catch (InstantiationException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                    if (parameterClassInstance == null) {
                        return null;
                    }
                    return copy.getElementName(parameterClassInstance);
                }
            };
        }
        return null;
    }

    @Override
    public void attachTypes(ApplicationDescription introspector) {
        if (introspector != null) {
            int i = this._hasTypeWantsName.size();
            for (int j = 0; j < i; ++j) {
                QName name;
                Pair pair = this._hasTypeWantsName.get(j);
                WantsName nextToProcess = pair.wantsName;
                HasType nextType = pair.hasType;
                Class parameterClass = nextType.getPrimaryClass();
                if (SPECIAL_GENERIC_TYPES.contains(parameterClass)) {
                    parameterClass = (Class)((ParameterizedType)nextType.getType()).getActualTypeArguments()[0];
                }
                if ((name = introspector.resolve(parameterClass)) != null) {
                    nextToProcess.setName(name);
                    continue;
                }
                LOG.info("Couldn't find JAX-B element for class " + parameterClass.getName());
            }
        }
    }

    private class Pair {
        HasType hasType;
        WantsName wantsName;

        public Pair(HasType hasType, WantsName wantsName) {
            this.hasType = hasType;
            this.wantsName = wantsName;
        }
    }

    private static interface WantsName {
        public void setName(QName var1);
    }

    private static interface HasType {
        public Class getPrimaryClass();

        public Type getType();
    }
}

