/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.StringManager;
import org.apache.naming.ContextAccessController;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardDefaultContext
implements DefaultContext,
LifecycleListener,
MBeanRegistration {
    private Hashtable<StandardContext, StandardContext> contexts = new Hashtable();
    private List<String> applicationListeners = new ArrayList<String>();
    private List<ApplicationParameter> applicationParameters = new ArrayList<ApplicationParameter>();
    private boolean cookies = true;
    private boolean crossContext = true;
    private static final String info = "org.apache.catalina.core.DefaultContext/1.0";
    private ArrayList<String> instanceListeners = new ArrayList();
    private NamingResources namingResources = new NamingResources();
    private HashMap<String, String> parameters = new HashMap();
    private boolean reloadable = false;
    private ArrayList<String> wrapperLifecycles = new ArrayList();
    private List<String> wrapperListeners = new ArrayList<String>();
    private boolean useNaming = true;
    DirContext dirContext = null;
    protected String name = "defaultContext";
    protected Container parent = null;
    protected Vector<LifecycleListener> lifecycle = new Vector();
    protected Loader loader = null;
    protected Manager manager = null;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = 10240;
    protected int cacheTTL = 5000;
    protected boolean cachingAllowed = true;
    protected int managerChecksFrequency = 6;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public StandardDefaultContext() {
        this.namingResources.setContainer(this);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setManagerChecksFrequency(int managerChecksFrequency) {
        this.managerChecksFrequency = managerChecksFrequency;
    }

    public int getManagerChecksFrequency() {
        return this.managerChecksFrequency;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    @Override
    public boolean getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(boolean cookies) {
        this.cookies = cookies;
    }

    @Override
    public boolean getCrossContext() {
        return this.crossContext;
    }

    @Override
    public void setCrossContext(boolean crossContext) {
        this.crossContext = crossContext;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
    }

    @Override
    public void setResources(DirContext resources) {
        this.dirContext = resources;
    }

    @Override
    public DirContext getResources() {
        return this.dirContext;
    }

    @Override
    public Loader getLoader() {
        return this.loader;
    }

    @Override
    public void setLoader(Loader loader) {
        Loader oldLoader = this.loader;
        this.loader = loader;
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.add(listener);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    @Override
    public void addApplicationListener(String listener) {
        this.applicationListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationParameter(ApplicationParameter parameter) {
        String newName = parameter.getName();
        List<ApplicationParameter> list = this.applicationParameters;
        synchronized (list) {
            for (ApplicationParameter applicationParameter : this.applicationParameters) {
                if (!newName.equals(applicationParameter.getName())) continue;
                if (applicationParameter.getOverride()) {
                    applicationParameter.setValue(parameter.getValue());
                }
                return;
            }
            this.applicationParameters.add(parameter);
        }
    }

    @Override
    public void addEjb(ContextEjb ejb) {
        this.namingResources.addEjb(ejb);
    }

    @Override
    public void addEnvironment(ContextEnvironment environment) {
        this.namingResources.addEnvironment(environment);
    }

    @Override
    public void addResourceParams(ResourceParams resourceParameters) {
        this.namingResources.addResourceParams(resourceParameters);
    }

    @Override
    public void addInstanceListener(String listener) {
        this.instanceListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addResource(ContextResource resource) {
        this.namingResources.addResource(resource);
    }

    @Override
    public void addResourceEnvRef(String name, String type2) {
        this.namingResources.addResourceEnvRef(name, type2);
    }

    @Override
    public void addResourceLink(ContextResourceLink resourceLink) {
        this.namingResources.addResourceLink(resourceLink);
    }

    @Override
    public void addWrapperLifecycle(String listener) {
        this.wrapperLifecycles.add(listener);
    }

    @Override
    public void addWrapperListener(String listener) {
        this.wrapperListeners.add(listener);
    }

    @Override
    public List<String> findApplicationListeners() {
        return this.applicationListeners;
    }

    @Override
    public List<ApplicationParameter> findApplicationParameters() {
        return this.applicationParameters;
    }

    @Override
    public ContextEjb findEjb(String name) {
        return this.namingResources.findEjb(name);
    }

    @Override
    public ContextEjb[] findEjbs() {
        return this.namingResources.findEjbs();
    }

    @Override
    public ContextEnvironment findEnvironment(String name) {
        return this.namingResources.findEnvironment(name);
    }

    @Override
    public ContextEnvironment[] findEnvironments() {
        return this.namingResources.findEnvironments();
    }

    @Override
    public ResourceParams[] findResourceParams() {
        return this.namingResources.findResourceParams();
    }

    @Override
    public List<String> findInstanceListeners() {
        return this.instanceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            return this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findParameters() {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    @Override
    public ContextResource findResource(String name) {
        return this.namingResources.findResource(name);
    }

    @Override
    public String findResourceEnvRef(String name) {
        return this.namingResources.findResourceEnvRef(name);
    }

    @Override
    public String[] findResourceEnvRefs() {
        return this.namingResources.findResourceEnvRefs();
    }

    @Override
    public ContextResourceLink findResourceLink(String name) {
        return this.namingResources.findResourceLink(name);
    }

    @Override
    public ContextResourceLink[] findResourceLinks() {
        return this.namingResources.findResourceLinks();
    }

    @Override
    public ContextResource[] findResources() {
        return this.namingResources.findResources();
    }

    @Override
    public List<String> findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    @Override
    public List<String> findWrapperListeners() {
        return this.wrapperListeners;
    }

    @Override
    public NamingResources getNamingResources() {
        return this.namingResources;
    }

    @Override
    public void removeApplicationListeners() {
        this.applicationListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationParameter(String name) {
        List<ApplicationParameter> list = this.applicationParameters;
        synchronized (list) {
            ApplicationParameter match = null;
            for (ApplicationParameter applicationParameter : this.applicationParameters) {
                if (!name.equals(applicationParameter.getName())) continue;
                match = applicationParameter;
                break;
            }
            if (match != null) {
                this.applicationParameters.remove(match);
            }
        }
    }

    @Override
    public void removeEjb(String name) {
        this.namingResources.removeEjb(name);
    }

    @Override
    public void removeInstanceListener(String listener) {
        this.instanceListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void removeEnvironment(String envName) {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env == null) {
            throw new IllegalArgumentException("Invalid environment name '" + envName + "'");
        }
        nresources.removeEnvironment(envName);
    }

    @Override
    public void removeResource(String resourceName) {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + resourceName + "'");
        }
        nresources.removeResource(resourceName);
    }

    @Override
    public void removeResourceLink(String resourceLinkName) {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return;
        }
        ContextResourceLink resource = nresources.findResourceLink(resourceLinkName);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + resourceLinkName + "'");
        }
        nresources.removeResourceLink(resourceLinkName);
    }

    @Override
    public void removeResourceEnvRef(String name) {
        this.namingResources.removeResourceEnvRef(name);
    }

    @Override
    public void removeWrapperLifecycles() {
        this.wrapperLifecycles.clear();
    }

    @Override
    public void removeWrapperListeners() {
        this.wrapperListeners.clear();
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        StandardContext context = null;
        NamingContextListener listener = null;
        if (event.getLifecycle() instanceof StandardContext) {
            context = (StandardContext)event.getLifecycle();
            for (LifecycleListener lifecycleListener : context.findLifecycleListeners()) {
                if (!(lifecycleListener instanceof NamingContextListener)) continue;
                listener = (NamingContextListener)lifecycleListener;
                break;
            }
        }
        if (listener == null) {
            return;
        }
        if (event.getType().equals("before_stop") || event.getType().equals("reload")) {
            this.contexts.remove(context);
            this.namingResources.removePropertyChangeListener(listener);
            if (!event.getType().equals("reload")) {
                context.removeLifecycleListener(this);
            }
        }
        if (event.getType().equals("after_start") || event.getType().equals("reload")) {
            this.contexts.put(context, context);
            NamingResources contextResources = context.getNamingResources();
            ContextAccessController.setWritable(listener.getName(), context);
            ContextEjb[] contextEjb = this.findEjbs();
            for (int i = 0; i < contextEjb.length; ++i) {
                ContextEjb contextEntry = contextEjb[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeEjb(contextEntry.getName());
                }
                listener.addEjb(contextEntry);
            }
            ContextEnvironment[] contextEnv = this.findEnvironments();
            for (int i = 0; i < contextEnv.length; ++i) {
                ContextEnvironment contextEntry = contextEnv[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeEnvironment(contextEntry.getName());
                }
                listener.addEnvironment(contextEntry);
            }
            ContextResource[] resources = this.findResources();
            for (int i = 0; i < resources.length; ++i) {
                ContextResource contextEntry = resources[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeResource(contextEntry.getName());
                }
                listener.addResource(contextEntry);
            }
            ContextResourceLink[] resourceLinks = this.findResourceLinks();
            for (int i = 0; i < resourceLinks.length; ++i) {
                ContextResourceLink contextEntry = resourceLinks[i];
                if (contextResources.exists(contextEntry.getName())) {
                    listener.removeResourceLink(contextEntry.getName());
                }
                listener.addResourceLink(contextEntry);
            }
            String[] envRefs = this.findResourceEnvRefs();
            for (int i = 0; i < envRefs.length; ++i) {
                if (contextResources.exists(envRefs[i])) {
                    listener.removeResourceEnvRef(envRefs[i]);
                }
                listener.addResourceEnvRef(envRefs[i], this.findResourceEnvRef(envRefs[i]));
            }
            ContextAccessController.setReadOnly(listener.getName());
            this.namingResources.addPropertyChangeListener(listener);
        }
    }

    public void installDefaultContext(Context context) {
        if (context instanceof StandardContext) {
            StandardContext stContext = (StandardContext)context;
            stContext.setUseNaming(this.isUseNaming());
            stContext.setCachingAllowed(this.isCachingAllowed());
            stContext.setCacheTTL(this.getCacheTTL());
            stContext.setCacheMaxSize(this.getCacheMaxSize());
            stContext.setAllowLinking(this.isAllowLinking());
            stContext.setCaseSensitive(this.isCaseSensitive());
            stContext.setManagerChecksFrequency(this.getManagerChecksFrequency());
            if (!this.contexts.containsKey(stContext)) {
                stContext.addLifecycleListener(this);
            }
            Enumeration<LifecycleListener> lifecycleListeners = this.lifecycle.elements();
            while (lifecycleListeners.hasMoreElements()) {
                stContext.addLifecycleListener(lifecycleListeners.nextElement());
            }
        }
        if (!context.getPrivileged() && this.loader != null) {
            ClassLoader parentClassLoader = context.getParent().getParentClassLoader();
            Class<?> clazz = this.loader.getClass();
            Class[] types = new Class[]{ClassLoader.class};
            Object[] args = new Object[]{parentClassLoader};
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(types);
                Loader context_loader = (Loader)constructor.newInstance(args);
                context_loader.setDelegate(this.loader.getDelegate());
                context_loader.setReloadable(this.loader.getReloadable());
                if (this.loader instanceof WebappLoader) {
                    ((WebappLoader)context_loader).setDebug(((WebappLoader)this.loader).getDebug());
                    ((WebappLoader)context_loader).setLoaderClass(((WebappLoader)this.loader).getLoaderClass());
                }
                context.setLoader(context_loader);
            }
            catch (Exception e) {
                IllegalArgumentException iae = new IllegalArgumentException("DefaultContext custom Loader install failed");
                iae.initCause(e);
                throw iae;
            }
        }
    }

    @Override
    public void importDefaultContext(Context context) {
        context.setCookies(this.getCookies());
        context.setCrossContext(this.getCrossContext());
        context.setReloadable(this.getReloadable());
        Iterator<String> iter = this.findApplicationListeners().iterator();
        while (iter.hasNext()) {
            context.addApplicationListener(iter.next());
        }
        iter = this.findInstanceListeners().iterator();
        while (iter.hasNext()) {
            context.addInstanceListener(iter.next());
        }
        iter = this.findWrapperListeners().iterator();
        while (iter.hasNext()) {
            context.addWrapperListener(iter.next());
        }
        iter = this.findWrapperLifecycles().iterator();
        while (iter.hasNext()) {
            context.addWrapperLifecycle(iter.next());
        }
        String[] parameters = this.findParameters();
        for (int i = 0; i < parameters.length; ++i) {
            context.addParameter(parameters[i], this.findParameter(parameters[i]));
        }
        Iterator<ApplicationParameter> appParamIter = this.findApplicationParameters().iterator();
        while (appParamIter.hasNext()) {
            context.addApplicationParameter(appParamIter.next());
        }
        if (!(context instanceof StandardContext)) {
            ContextEjb[] contextEjb = this.findEjbs();
            for (int i = 0; i < contextEjb.length; ++i) {
                context.addEjb(contextEjb[i]);
            }
            ContextEnvironment[] contextEnv = this.findEnvironments();
            for (int i = 0; i < contextEnv.length; ++i) {
                context.addEnvironment(contextEnv[i]);
            }
            ContextResource[] resources = this.findResources();
            for (int i = 0; i < resources.length; ++i) {
                context.addResource(resources[i]);
            }
            ContextResourceLink[] resourceLinks = this.findResourceLinks();
            for (int i = 0; i < resourceLinks.length; ++i) {
                context.addResourceLink(resourceLinks[i]);
            }
            String[] envRefs = this.findResourceEnvRefs();
            for (int i = 0; i < envRefs.length; ++i) {
                context.addResourceEnvRef(envRefs[i], this.findResourceEnvRef(envRefs[i]));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("DefaultContext[");
        sb.append("]");
        return sb.toString();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType() {
        return this.type;
    }

    protected String getJSR77Suffix() {
        return this.suffix;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        this.type = name.getKeyProperty("type");
        if (this.type == null) {
            this.type = name.getKeyProperty("j2eeType");
        }
        String j2eeApp = name.getKeyProperty("J2EEApplication");
        String j2eeServer = name.getKeyProperty("J2EEServer");
        if (j2eeApp == null) {
            j2eeApp = "none";
        }
        if (j2eeServer == null) {
            j2eeServer = "none";
        }
        this.suffix = ",J2EEApplication=" + j2eeApp + ",J2EEServer=" + j2eeServer;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public String[] getEnvironments() {
        ContextEnvironment[] envs = this.getNamingResources().findEnvironments();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < envs.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getDomain(), envs[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for environment " + envs[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceNames() {
        ContextResource[] resources = this.getNamingResources().findResources();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < resources.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getDomain(), resources[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + resources[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] links = this.getNamingResources().findResourceLinks();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < links.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getDomain(), links[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + links[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String addEnvironment(String envName, String type2) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + envName + "'");
        }
        env = new ContextEnvironment();
        env.setName(envName);
        env.setType(type2);
        nresources.addEnvironment(env);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextEnvironment");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), env);
        return oname.toString();
    }

    public String addResource(String resourceName, String type2) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + resourceName + "'");
        }
        resource = new ContextResource();
        resource.setName(resourceName);
        resource.setType(type2);
        nresources.addResource(resource);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextResource");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resource);
        return oname.toString();
    }

    public String addResourceLink(String resourceLinkName, String global, String name, String type2) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + resourceLinkName + "'");
        }
        resourceLink = new ContextResourceLink();
        resourceLink.setGlobal(global);
        resourceLink.setName(resourceLinkName);
        resourceLink.setType(type2);
        nresources.addResourceLink(resourceLink);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextResourceLink");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resourceLink);
        return oname.toString();
    }
}

