/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.LinkedList;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.log.ChecksumOperation;
import org.apache.derby.impl.store.raw.log.LogAccessFileBuffer;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.io.StorageRandomAccessFile;

public class LogAccessFile {
    private static final int LOG_RECORD_FIXED_OVERHEAD_SIZE = 16;
    private static final int LOG_RECORD_HEADER_SIZE = 12;
    private static final int LOG_RECORD_TRAILER_SIZE = 4;
    private static final int LOG_NUMBER_LOG_BUFFERS = 3;
    private LinkedList freeBuffers;
    private LinkedList dirtyBuffers;
    private LogAccessFileBuffer currentBuffer;
    private boolean flushInProgress = false;
    private final StorageRandomAccessFile log;
    private final Object logFileSemaphore;
    static int mon_numWritesToLog;
    static int mon_numBytesToLog;
    MasterFactory masterFac;
    boolean inReplicationMasterMode = false;
    boolean inReplicationSlaveMode = false;
    private ArrayOutputStream logOutputBuffer;
    private FormatIdOutputStream logicalOut;
    private long checksumInstant = -1L;
    private int checksumLength;
    private int checksumLogRecordSize;
    private boolean writeChecksum;
    private ChecksumOperation checksumLogOperation;
    private LogRecord checksumLogRecord;
    private LogToFile logFactory;
    private boolean databaseEncrypted = false;

    public LogAccessFile(LogToFile logToFile, StorageRandomAccessFile storageRandomAccessFile, int n) {
        logToFile.checkForReplication(this);
        this.log = storageRandomAccessFile;
        this.logFileSemaphore = storageRandomAccessFile;
        this.logFactory = logToFile;
        this.freeBuffers = new LinkedList();
        this.dirtyBuffers = new LinkedList();
        for (int i = 0; i < 3; ++i) {
            LogAccessFileBuffer logAccessFileBuffer = new LogAccessFileBuffer(n);
            this.freeBuffers.addLast(logAccessFileBuffer);
        }
        this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
        this.writeChecksum = logToFile.checkVersion(10, 1);
        if (this.inReplicationSlaveMode) {
            this.writeChecksum = false;
        }
        if (this.writeChecksum) {
            this.checksumLogOperation = new ChecksumOperation();
            this.checksumLogOperation.init();
            this.checksumLogRecord = new LogRecord();
            this.checksumLogRecord.setValue(null, this.checksumLogOperation);
            this.checksumLength = LogRecord.getStoredSize(this.checksumLogOperation.group(), null) + this.checksumLogOperation.getStoredSize();
            if (logToFile.databaseEncrypted()) {
                this.checksumLength = logToFile.getEncryptedDataLength(this.checksumLength);
                this.databaseEncrypted = true;
            }
            this.checksumLogRecordSize = this.checksumLength + 16;
            this.logOutputBuffer = new ArrayOutputStream();
            this.logicalOut = new FormatIdOutputStream(this.logOutputBuffer);
        } else {
            this.checksumLogRecordSize = 0;
        }
        this.currentBuffer.init(this.checksumLogRecordSize);
    }

    public void writeLogRecord(int n, long l, byte[] byArray, int n2, byte[] byArray2, int n3, int n4) throws StandardException, IOException {
        int n5 = n + 16;
        if (n5 <= this.currentBuffer.bytes_free) {
            int n6;
            this.currentBuffer.position = n6 = this.appendLogRecordToBuffer(this.currentBuffer.buffer, this.currentBuffer.position, n, l, byArray, n2, byArray2, n3, n4);
            this.currentBuffer.bytes_free -= n5;
            this.currentBuffer.greatest_instant = l;
        } else {
            int n7 = this.checksumLogRecordSize + n5;
            byte[] byArray3 = new byte[n7];
            this.appendLogRecordToBuffer(byArray3, this.checksumLogRecordSize, n, l, byArray, n2, byArray2, n3, n4);
            if (this.writeChecksum) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(byArray3, this.checksumLogRecordSize, n5);
                this.writeChecksumLogRecord(byArray3);
            }
            this.flushLogAccessFile();
            this.writeToLog(byArray3, 0, n7, l);
        }
    }

    private int appendLogRecordToBuffer(byte[] byArray, int n, int n2, long l, byte[] byArray2, int n3, byte[] byArray3, int n4, int n5) {
        n = this.writeInt(n2, byArray, n);
        n = this.writeLong(l, byArray, n);
        int n6 = n2 - n5;
        System.arraycopy(byArray2, n3, byArray, n, n6);
        n += n6;
        if (n5 != 0) {
            System.arraycopy(byArray3, n4, byArray, n, n5);
            n += n5;
        }
        n = this.writeInt(n2, byArray, n);
        return n;
    }

    private final int writeInt(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        return n2;
    }

    private final int writeLong(long l, byte[] byArray, int n) {
        byArray[n++] = (byte)((int)(l >>> 56) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 48) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 40) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 32) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 24) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 16) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 8) & 0xFF);
        byArray[n++] = (byte)((int)l & 0xFF);
        return n;
    }

    public void writeInt(int n) {
        this.currentBuffer.position = this.writeInt(n, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 4;
    }

    public void writeLong(long l) {
        this.currentBuffer.position = this.writeLong(l, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 8;
    }

    public void write(int n) {
        this.currentBuffer.buffer[this.currentBuffer.position++] = (byte)n;
        --this.currentBuffer.bytes_free;
    }

    public void write(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.currentBuffer.buffer, this.currentBuffer.position, n2);
        this.currentBuffer.bytes_free -= n2;
        this.currentBuffer.position += n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushDirtyBuffers() throws IOException {
        LogAccessFile logAccessFile;
        LogAccessFileBuffer logAccessFileBuffer = null;
        int n = 0;
        try {
            int n2;
            LogAccessFile logAccessFile2 = this;
            synchronized (logAccessFile2) {
                while (this.flushInProgress) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                n2 = this.dirtyBuffers.size();
                if (n2 > 0) {
                    logAccessFileBuffer = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                }
                this.flushInProgress = true;
            }
            while (n < n2) {
                if (logAccessFileBuffer.position != 0) {
                    this.writeToLog(logAccessFileBuffer.buffer, 0, logAccessFileBuffer.position, logAccessFileBuffer.greatest_instant);
                }
                ++n;
                logAccessFile2 = this;
                synchronized (logAccessFile2) {
                    this.freeBuffers.addLast(logAccessFileBuffer);
                    if (n < n2) {
                        logAccessFileBuffer = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                    } else {
                        int n3 = this.dirtyBuffers.size();
                        if (n3 > 0 && n <= 3) {
                            n2 += n3;
                            logAccessFileBuffer = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                        }
                    }
                }
            }
            Object var9_9 = null;
            logAccessFile = this;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            LogAccessFile logAccessFile3 = this;
            synchronized (logAccessFile3) {
                this.flushInProgress = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (logAccessFile) {
            this.flushInProgress = false;
            this.notifyAll();
        }
    }

    public void flushLogAccessFile() throws IOException, StandardException {
        this.switchLogBuffer();
        this.flushDirtyBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchLogBuffer() throws IOException, StandardException {
        LogAccessFile logAccessFile = this;
        synchronized (logAccessFile) {
            if (this.currentBuffer.position == this.checksumLogRecordSize) {
                return;
            }
            if (this.writeChecksum) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(this.currentBuffer.buffer, this.checksumLogRecordSize, this.currentBuffer.position - this.checksumLogRecordSize);
                this.writeChecksumLogRecord(this.currentBuffer.buffer);
            }
            this.dirtyBuffers.addLast(this.currentBuffer);
            if (this.freeBuffers.size() == 0) {
                this.flushDirtyBuffers();
            }
            this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
            this.currentBuffer.init(this.checksumLogRecordSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncLogAccessFile() throws IOException, StandardException {
        int n = 0;
        while (true) {
            try {
                LogAccessFile logAccessFile = this;
                synchronized (logAccessFile) {
                    this.log.sync();
                }
            }
            catch (SyncFailedException syncFailedException) {
                ++n;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
                if (n <= 20) continue;
                throw StandardException.newException("XSLA4.D", syncFailedException);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corrupt() throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, StandardException {
        this.flushLogAccessFile();
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    protected void setReplicationMasterRole(MasterFactory masterFactory) {
        this.masterFac = masterFactory;
        this.inReplicationMasterMode = true;
    }

    protected void stopReplicationMasterRole() {
        this.inReplicationMasterMode = false;
        this.masterFac = null;
    }

    protected void setReplicationSlaveRole() {
        this.inReplicationSlaveMode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToLog(byte[] byArray, int n, int n2, long l) throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                int n3 = 0;
                while (true) {
                    try {
                        this.log.write(byArray, n, n2);
                        if (!this.inReplicationMasterMode) break;
                        this.masterFac.appendLog(l, byArray, n, n2);
                    }
                    catch (IOException iOException) {
                        if (n3 >= 5) {
                            throw iOException;
                        }
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected long reserveSpaceForChecksum(int n, long l, long l2) throws StandardException, IOException {
        int n2 = n + 16;
        boolean bl = false;
        if (this.currentBuffer.position == this.checksumLogRecordSize) {
            bl = this.writeChecksum;
        } else if (n2 > this.currentBuffer.bytes_free) {
            this.switchLogBuffer();
            bl = this.writeChecksum;
        }
        if (bl) {
            this.checksumInstant = LogCounter.makeLogInstantAsLong(l, l2);
            return this.checksumLogRecordSize;
        }
        return 0L;
    }

    private void writeChecksumLogRecord(byte[] byArray) throws IOException, StandardException {
        int n = 0;
        n = this.writeInt(this.checksumLength, byArray, n);
        n = this.writeLong(this.checksumInstant, byArray, n);
        this.logOutputBuffer.setData(byArray);
        this.logOutputBuffer.setPosition(n);
        this.logicalOut.writeObject(this.checksumLogRecord);
        if (this.databaseEncrypted) {
            int n2 = this.logFactory.encrypt(byArray, 12, this.checksumLength, byArray, 12);
        }
        n = 12 + this.checksumLength;
        n = this.writeInt(this.checksumLength, byArray, n);
    }

    protected void writeEndMarker(int n) throws IOException, StandardException {
        this.flushLogAccessFile();
        byte[] byArray = this.currentBuffer.buffer;
        int n2 = 0;
        n2 = this.writeInt(n, byArray, n2);
        this.writeToLog(byArray, 0, n2, -1L);
    }
}

