/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.RegistryMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry
implements RegistryMBean,
MBeanRegistration {
    public static final String MODELER_MANIFEST = "/META-INF/mbeans-descriptors.xml";
    private static Logger log = Logger.getLogger(Registry.class.getName());
    private static HashMap<Object, Registry> perLoaderRegistries = null;
    private static Registry registry = null;
    private MBeanServer server = null;
    private HashMap<String, ManagedBean> descriptors = new HashMap();
    private HashMap<String, ManagedBean> descriptorsByClass = new HashMap();
    private HashMap<String, URL> searchedPaths = new HashMap();
    private Object key;
    private Object guard;
    private Hashtable<String, Hashtable<String, Integer>> idDomains = new Hashtable();
    private Hashtable<String, int[]> ids = new Hashtable();

    public static synchronized Registry getRegistry(Object key, Object guard) {
        if (perLoaderRegistries != null) {
            if (key == null) {
                key = Thread.currentThread().getContextClassLoader();
            }
            if (key != null) {
                Registry localRegistry = perLoaderRegistries.get(key);
                if (localRegistry == null) {
                    localRegistry = new Registry();
                    localRegistry.key = key;
                    localRegistry.guard = guard;
                    perLoaderRegistries.put(key, localRegistry);
                    return localRegistry;
                }
                if (localRegistry.guard != null && localRegistry.guard != guard) {
                    return null;
                }
                return localRegistry;
            }
        }
        if (registry == null) {
            registry = new Registry();
        }
        if (Registry.registry.guard != null && Registry.registry.guard != guard) {
            return null;
        }
        return registry;
    }

    public static void setUseContextClassLoader(boolean enable) {
        if (enable) {
            perLoaderRegistries = new HashMap();
        }
    }

    public void setGuard(Object guard) {
        if (this.guard != null) {
            return;
        }
        this.guard = guard;
    }

    @Override
    public void stop() {
        this.descriptorsByClass = new HashMap();
        this.descriptors = new HashMap();
        this.searchedPaths = new HashMap();
    }

    @Override
    public List<ObjectName> loadMBeans(Object source, ClassLoader cl) throws Exception {
        return this.load("MbeansSource", source, null);
    }

    @Override
    public void loadMetadata(Object source) throws Exception {
        if (source instanceof ClassLoader) {
            this.loadMetaInfDescriptors((ClassLoader)source);
            return;
        }
        registry.loadDescriptors(null, source, null);
    }

    @Override
    public void registerComponent(Object bean, String oname, String type2) throws Exception {
        this.registerComponent(bean, new ObjectName(oname), type2);
    }

    @Override
    public void unregisterComponent(String oname) {
        block2: {
            try {
                this.unregisterComponent(new ObjectName(oname));
            }
            catch (MalformedObjectNameException e) {
                if (!log.isLoggable(Level.INFO)) break block2;
                log.info("Error creating object name " + e);
            }
        }
    }

    @Override
    public void invoke(List<ObjectName> mbeans, String operation, boolean failFirst) throws Exception {
        if (mbeans == null) {
            return;
        }
        for (ObjectName current : mbeans) {
            try {
                if (current == null || this.getMethodInfo(current, operation) == null) continue;
                this.getMBeanServer().invoke(current, operation, new Object[0], new String[0]);
            }
            catch (Exception t) {
                if (failFirst) {
                    throw t;
                }
                if (!log.isLoggable(Level.INFO)) continue;
                log.log(Level.INFO, "Error initializing " + current + " " + t.toString());
            }
        }
    }

    @Override
    public synchronized int getId(String domain, String name) {
        Integer i;
        Hashtable<String, Integer> domainTable;
        if (domain == null) {
            domain = "";
        }
        if ((domainTable = this.idDomains.get(domain)) == null) {
            domainTable = new Hashtable();
            this.idDomains.put(domain, domainTable);
        }
        if (name == null) {
            name = "";
        }
        if ((i = domainTable.get(name)) != null) {
            return i;
        }
        int[] id = this.ids.get(domain);
        if (id == null) {
            id = new int[1];
            this.ids.put(domain, id);
        }
        int n = id[0];
        id[0] = n + 1;
        int code = n;
        domainTable.put(name, code);
        return code;
    }

    public void addManagedBean(ManagedBean bean) {
        this.descriptors.put(bean.getName(), bean);
        if (bean.getType() != null) {
            this.descriptorsByClass.put(bean.getType(), bean);
        }
    }

    public ManagedBean findManagedBean(String name) {
        ManagedBean mb = this.descriptors.get(name);
        if (mb == null) {
            mb = this.descriptorsByClass.get(name);
        }
        return mb;
    }

    public String[] findManagedBeans() {
        Set<String> keySet = this.descriptors.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public String[] findManagedBeans(String group2) {
        ArrayList<String> results = new ArrayList<String>();
        for (ManagedBean item : this.descriptors.values()) {
            if (group2 == null) {
                if (item.getGroup() != null) continue;
                results.add(item.getName());
                continue;
            }
            if (!group2.equals(item.getGroup())) continue;
            results.add(item.getName());
        }
        String[] values = new String[results.size()];
        return results.toArray(values);
    }

    public void removeManagedBean(ManagedBean bean) {
        this.descriptors.remove(bean.getName());
        this.descriptorsByClass.remove(bean.getType());
    }

    public String getType(ObjectName oname, String attName) {
        String type2 = null;
        MBeanInfo info = null;
        try {
            info = this.server.getMBeanInfo(oname);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Can't find metadata for object" + oname);
            return null;
        }
        MBeanAttributeInfo[] attInfo = info.getAttributes();
        for (int i = 0; i < attInfo.length; ++i) {
            if (!attName.equals(attInfo[i].getName())) continue;
            type2 = attInfo[i].getType();
            return type2;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName oname, String opName) {
        Object type2 = null;
        MBeanInfo info = null;
        try {
            info = this.server.getMBeanInfo(oname);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Can't find metadata " + oname);
            return null;
        }
        MBeanOperationInfo[] attInfo = info.getOperations();
        for (int i = 0; i < attInfo.length; ++i) {
            if (!opName.equals(attInfo[i].getName())) continue;
            return attInfo[i];
        }
        return null;
    }

    public void unregisterComponent(ObjectName oname) {
        try {
            if (this.getMBeanServer().isRegistered(oname)) {
                this.getMBeanServer().unregisterMBean(oname);
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error unregistering mbean ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MBeanServer getMBeanServer() {
        long t1 = System.currentTimeMillis();
        if (this.server == null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Globals.get(ClassLoaderHierarchy.class).getCommonClassLoader());
                this.server = MBeanServerFactory.createMBeanServer();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Creating MBeanServer" + (System.currentTimeMillis() - t1));
            }
        }
        return this.server;
    }

    public ManagedBean findManagedBean(Object bean, Class<?> beanClass, String type2) throws Exception {
        ManagedBean managed;
        if (bean != null && beanClass == null) {
            beanClass = bean.getClass();
        }
        if (type2 == null) {
            type2 = beanClass.getName();
        }
        if ((managed = registry.findManagedBean(type2)) == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Looking for descriptor ");
            }
            this.findDescriptor(beanClass, type2);
            managed = this.findManagedBean(type2);
        }
        if (bean instanceof DynamicMBean) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Dynamic mbean support ");
            }
            this.loadDescriptors("MbeansDescriptorsDynamicMBeanSource", bean, type2);
            managed = this.findManagedBean(type2);
        }
        if (managed == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Introspecting ");
            }
            this.loadDescriptors("MbeansDescriptorsIntrospectionSource", beanClass, type2);
            managed = this.findManagedBean(type2);
            if (managed == null) {
                log.warning("No metadata found for " + type2);
                return null;
            }
            managed.setName(type2);
            this.addManagedBean(managed);
        }
        return managed;
    }

    public Object convertValue(String type2, String value) {
        Object objValue = value;
        if (type2 == null || "java.lang.String".equals(type2)) {
            objValue = value;
        } else if ("javax.management.ObjectName".equals(type2) || "ObjectName".equals(type2)) {
            try {
                objValue = new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                return null;
            }
        } else if ("java.lang.Integer".equals(type2) || "int".equals(type2)) {
            objValue = Integer.valueOf(value);
        } else if ("java.lang.Boolean".equals(type2) || "boolean".equals(type2)) {
            objValue = Boolean.valueOf(value);
        }
        return objValue;
    }

    public List<ObjectName> load(String sourceType, Object source, String param) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("load " + source);
        }
        String location = null;
        String type2 = null;
        Object inputsource = null;
        if (source instanceof DynamicMBean) {
            sourceType = "MbeansDescriptorsDynamicMBeanSource";
            inputsource = source;
        } else if (source instanceof URL) {
            URL url = (URL)source;
            location = url.toString();
            type2 = param;
            inputsource = url.openStream();
            if (sourceType == null) {
                sourceType = this.sourceTypeFromExt(location);
            }
        } else if (source instanceof File) {
            location = ((File)source).getAbsolutePath();
            inputsource = new FileInputStream((File)source);
            type2 = param;
            if (sourceType == null) {
                sourceType = this.sourceTypeFromExt(location);
            }
        } else if (source instanceof InputStream) {
            type2 = param;
            inputsource = source;
        } else if (source instanceof Class) {
            location = ((Class)source).getName();
            type2 = param;
            inputsource = source;
            if (sourceType == null) {
                sourceType = "MbeansDescriptorsIntrospectionSource";
            }
        }
        if (sourceType == null) {
            sourceType = "MbeansDescriptorsDOMSource";
        }
        ModelerSource ds = this.getModelerSource(sourceType);
        List<ObjectName> mbeans = ds.loadDescriptors(this, location, type2, inputsource);
        return mbeans;
    }

    private String sourceTypeFromExt(String s) {
        if (s.endsWith(".ser")) {
            return "MbeansDescriptorsSerSource";
        }
        if (s.endsWith(".xml")) {
            return "MbeansDescriptorsDOMSource";
        }
        return null;
    }

    public void registerComponent(Object bean, ObjectName oname, String type2) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Managed= " + oname);
        }
        if (bean == null) {
            log.log(Level.SEVERE, "Null component " + oname);
            return;
        }
        try {
            if (type2 == null) {
                type2 = bean.getClass().getName();
            }
            ManagedBean managed = registry.findManagedBean(bean.getClass(), type2);
            ModelMBean mbean = managed.createMBean(bean);
            if (this.getMBeanServer().isRegistered(oname)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Unregistering existing component " + oname);
                }
                this.getMBeanServer().unregisterMBean(oname);
            }
            this.getMBeanServer().registerMBean(mbean, oname);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error registering " + oname, ex);
            throw ex;
        }
    }

    public void loadDescriptors(String packageName, ClassLoader classLoader) {
        String res = packageName.replace('.', '/');
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Finding descriptor " + res);
        }
        if (this.searchedPaths.get(packageName) != null) {
            return;
        }
        String descriptors = res + "/mbeans-descriptors.ser";
        URL dURL = classLoader.getResource(descriptors);
        if (dURL == null) {
            descriptors = res + "/mbeans-descriptors.xml";
            dURL = classLoader.getResource(descriptors);
        }
        if (dURL == null) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Found " + dURL);
        }
        this.searchedPaths.put(packageName, dURL);
        try {
            if (descriptors.endsWith(".xml")) {
                this.loadDescriptors("MbeansDescriptorsDOMSource", dURL, null);
            } else {
                this.loadDescriptors("MbeansDescriptorsSerSource", dURL, null);
            }
            return;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error loading " + dURL);
            return;
        }
    }

    private void loadDescriptors(String sourceType, Object source, String param) throws Exception {
        this.load(sourceType, source, param);
    }

    private void loadMetaInfDescriptors(ClassLoader cl) {
        try {
            Enumeration<URL> en = cl.getResources(MODELER_MANIFEST);
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                InputStream is = url.openStream();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Loading " + url);
                }
                this.loadDescriptors("MBeansDescriptorDOMSource", is, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void findDescriptor(Class<?> beanClass, String type2) {
        String className;
        if (type2 == null) {
            type2 = beanClass.getName();
        }
        ClassLoader classLoader = null;
        if (beanClass != null) {
            classLoader = beanClass.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String pkg = className = type2;
        while (pkg.indexOf(".") > 0) {
            int lastComp = pkg.lastIndexOf(".");
            if (lastComp <= 0) {
                return;
            }
            if (this.searchedPaths.get(pkg = pkg.substring(0, lastComp)) != null) {
                return;
            }
            this.loadDescriptors(pkg, classLoader);
        }
    }

    private ModelerSource getModelerSource(String type2) throws Exception {
        if (type2 == null) {
            type2 = "MbeansDescriptorsDOMSource";
        }
        if (type2.indexOf(".") < 0) {
            type2 = "org.apache.tomcat.util.modeler.modules." + type2;
        }
        Class<?> c = Class.forName(type2);
        ModelerSource ds = (ModelerSource)c.newInstance();
        return ds;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void unregisterRegistry(ClassLoader loader) {
        perLoaderRegistries.remove(loader);
    }

    public ManagedBean findManagedBean(Class<?> beanClass, String type2) throws Exception {
        return this.findManagedBean(null, beanClass, type2);
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public void resetMetadata() {
        this.stop();
    }

    public void loadDescriptors(Object source) throws Exception {
        this.loadDescriptors("MbeansDescriptorsDOMSource", source, null);
    }

    public void unregisterComponent(String domain, String name) {
        try {
            ObjectName oname = new ObjectName(domain + ":" + name);
            this.getMBeanServer().unregisterMBean(oname);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error unregistering mbean ", t);
        }
    }

    public List<ObjectName> loadMBeans(Object source) throws Exception {
        return this.loadMBeans(source, null);
    }
}

