/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeEvent;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DirectCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectCollectionMapping
extends CollectionMapping
implements RelationalMapping {
    protected static final String Delete = "delete";
    protected static final String Insert = "insert";
    protected static final String DeleteAll = "deleteAll";
    protected static final String DeleteAtIndex = "deleteAtIndex";
    protected static final String UpdateAtIndex = "updateAtIndex";
    protected Converter valueConverter;
    protected String valueConverterClassName;
    protected transient DatabaseTable referenceTable;
    protected transient DatabaseField directField;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Vector<DatabaseField> referenceKeyFields;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient ModifyQuery changeSetDeleteQuery;
    protected transient ModifyQuery changeSetDeleteNullQuery;
    protected transient boolean hasCustomDeleteQuery;
    protected transient boolean hasCustomInsertQuery;
    protected HistoryPolicy historyPolicy;
    protected transient ModifyQuery deleteAtIndexQuery;
    protected transient ModifyQuery updateAtIndexQuery;
    protected transient boolean hasCustomDeleteAtIndexQuery;
    protected transient boolean hasCustomUpdateAtIndexQuery;
    protected transient Class attributeClassification;
    protected transient String attributeClassificationName;
    protected transient Class attributeObjectClassification;

    public DirectCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.referenceKeyFields = NonSynchronizedVector.newInstance(1);
        this.selectionQuery = new DirectReadQuery();
        this.hasCustomInsertQuery = false;
        this.isPrivateOwned = true;
        this.isListOrderFieldSupported = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public void setValueConverterClassName(String valueConverterClassName) {
        this.valueConverterClassName = valueConverterClassName;
    }

    public void addReferenceKeyField(DatabaseField referenceForeignKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceKeyFields().addElement(sourcePrimaryKeyField);
        this.getReferenceKeyFields().addElement(referenceForeignKeyField);
    }

    public void addReferenceKeyFieldName(String referenceForeignKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addReferenceKeyField(new DatabaseField(referenceForeignKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    @Override
    public ReadQuery prepareNestedBatchQuery(ObjectLevelReadQuery query) {
        ClassDescriptor descriptorToUse = query.getDescriptor();
        if (descriptorToUse != this.descriptor && !descriptorToUse.getMappings().contains(this) && !this.descriptor.isDescriptorTypeAggregate()) {
            descriptorToUse = this.descriptor;
        }
        DataReadQuery batchQuery = new DataReadQuery();
        batchQuery.setName(this.getAttributeName());
        Expression originalSelectionCriteria = null;
        IdentityHashMap clonedExpressions = new IdentityHashMap();
        ExpressionBuilder builder = new ExpressionBuilder();
        if (query.hasAsOfClause()) {
            builder.asOf(query.getAsOfClause());
        }
        Expression batchSelectionCriteria = null;
        BatchFetchType batchType = query.getBatchFetchPolicy().getType();
        if (this.batchFetchType != null) {
            batchType = this.batchFetchType;
        }
        if (batchType == BatchFetchType.EXISTS) {
            ExpressionBuilder subBuilder = new ExpressionBuilder(descriptorToUse.getJavaClass());
            subBuilder.setQueryClassAndDescriptor(descriptorToUse.getJavaClass(), descriptorToUse);
            ReportQuery subQuery = new ReportQuery(descriptorToUse.getJavaClass(), subBuilder);
            subQuery.setDescriptor(descriptorToUse);
            subQuery.setShouldRetrieveFirstPrimaryKey(true);
            Expression subCriteria = subBuilder.twist(this.getSelectionCriteria(), builder);
            if (query.getSelectionCriteria() != null) {
                subCriteria = query.getSelectionCriteria().cloneUsing(subBuilder).and(subCriteria);
            }
            subQuery.setSelectionCriteria(subCriteria);
            batchSelectionCriteria = builder.exists(subQuery);
        } else if (batchType == BatchFetchType.IN) {
            batchSelectionCriteria = this.buildBatchCriteria(builder, query);
        } else {
            if (query.getSelectionCriteria() != null) {
                originalSelectionCriteria = query.getSelectionCriteria().copiedVersionFrom(clonedExpressions);
                builder = originalSelectionCriteria.getBuilder();
            }
            batchSelectionCriteria = this.selectionQuery.isReadAllQuery() ? builder.twist(this.selectionQuery.getSelectionCriteria(), builder) : builder.twist(this.selectionQuery.getSQLStatement().getWhereClause(), builder);
            if (originalSelectionCriteria != null) {
                batchSelectionCriteria = batchSelectionCriteria.and(originalSelectionCriteria);
            }
            if (descriptorToUse.getQueryManager().getAdditionalJoinExpression() != null) {
                batchSelectionCriteria = batchSelectionCriteria.and(query.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(builder));
            }
            if (this.historyPolicy != null) {
                if (query.getSession().getAsOfClause() != null) {
                    builder.asOf(query.getSession().getAsOfClause());
                } else if (builder.getAsOfClause() == null) {
                    builder.asOf(AsOfClause.NO_CLAUSE);
                }
                batchSelectionCriteria = batchSelectionCriteria.and(this.historyPolicy.additionalHistoryExpression(builder));
            }
        }
        SQLSelectStatement batchStatement = new SQLSelectStatement();
        for (DatabaseField keyField : this.getReferenceKeyFields()) {
            batchStatement.addField(builder.getTable(this.referenceTable).getField(keyField));
        }
        batchStatement.addField(builder.getTable(this.referenceTable).getField(this.directField));
        batchStatement.setWhereClause(batchSelectionCriteria);
        batchQuery.setSQLStatement(batchStatement);
        this.containerPolicy.addAdditionalFieldsToQuery(batchQuery, this.getAdditionalFieldsBaseExpression(batchQuery));
        batchStatement.normalize(query.getSession(), this.descriptor, clonedExpressions);
        return batchQuery;
    }

    @Override
    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinManager, ObjectBuildingQuery baseQuery, AbstractSession session) {
        return null;
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey parentCacheKey, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        ContainerPolicy policy = this.getContainerPolicy();
        Object value = policy.containerInstance();
        ObjectBuilder objectBuilder = this.descriptor.getObjectBuilder();
        Object sourceKey = objectBuilder.extractPrimaryKeyFromRow(row, executionSession);
        List<AbstractRecord> rows = joinManager.getDataResultsByPrimaryKey().get(sourceKey);
        if (rows == null) {
            return this.valueFromRowInternal(row, joinManager, sourceQuery, executionSession);
        }
        int size = rows.size();
        if (size > 0) {
            HashSet<Object> directValues = new HashSet<Object>();
            ArrayList<Object> directValuesList = null;
            ArrayList<AbstractRecord> targetRows = null;
            boolean shouldAddAll = policy.shouldAddAll();
            if (shouldAddAll) {
                directValuesList = new ArrayList<Object>(size);
                targetRows = new ArrayList<AbstractRecord>(size);
            }
            Converter valueConverter = this.getValueConverter();
            boolean containsNull = false;
            for (int index = 0; index < size; ++index) {
                AbstractRecord sourceRow;
                AbstractRecord targetRow = sourceRow = rows.get(index);
                Object directValue = (targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession)).get(this.directField);
                if (directValue == null) {
                    if (size == 1) {
                        return this.getIndirectionPolicy().valueFromRow(value);
                    }
                    containsNull = true;
                }
                if (directValues.contains(directValue)) continue;
                directValues.add(directValue);
                if (valueConverter != null) {
                    directValue = valueConverter.convertDataValueToObjectValue(directValue, executionSession);
                }
                if (shouldAddAll) {
                    directValuesList.add(directValue);
                    targetRows.add(targetRow);
                    continue;
                }
                policy.addInto(directValue, value, executionSession, targetRow, sourceQuery, parentCacheKey, isTargetProtected);
            }
            if (shouldAddAll) {
                if (!containsNull || targetRows.size() != 1) {
                    policy.addAll(directValuesList, value, executionSession, targetRows, sourceQuery, parentCacheKey, isTargetProtected);
                }
            } else if (containsNull && policy.sizeFor(value) == 1) {
                policy.clear(value);
            }
        }
        return this.getIndirectionPolicy().valueFromRow(value);
    }

    @Override
    public void buildCopy(Object copy, Object original, CopyGroup group2) {
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(original, group2.getSession());
        attributeValue = this.getContainerPolicy().cloneFor(attributeValue);
        this.getIndirectionPolicy().reset(copy);
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    @Override
    public Object buildElementClone(Object element, Object parent, CacheKey parentCacheKey, AbstractSession cloningSession, boolean isExisting) {
        Object cloneValue = element;
        if (this.getValueConverter() != null && this.getValueConverter().isMutable()) {
            cloneValue = this.getValueConverter().convertDataValueToObjectValue(this.getValueConverter().convertObjectValueToDataValue(cloneValue, cloningSession), cloningSession);
        }
        return cloneValue;
    }

    @Override
    protected void buildListOrderField() {
        if (this.listOrderField.hasTableName()) {
            if (!this.getReferenceTable().equals(this.listOrderField.getTable())) {
                throw DescriptorException.listOrderFieldTableIsWrong(this.getDescriptor(), this, this.listOrderField.getTable(), this.getReferenceTable());
            }
        } else {
            this.listOrderField.setTable(this.getReferenceTable());
        }
        this.listOrderField = this.getDescriptor().buildField(this.listOrderField, this.getReferenceTable());
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
    }

    @Override
    public Object clone() {
        DirectCollectionMapping clone = (DirectCollectionMapping)super.clone();
        clone.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        clone.setReferenceKeyFields(this.cloneFields(this.getReferenceKeyFields()));
        if (this.changeSetDeleteQuery != null) {
            clone.changeSetDeleteQuery = (ModifyQuery)this.changeSetDeleteQuery.clone();
        }
        if (this.changeSetDeleteNullQuery != null) {
            clone.changeSetDeleteNullQuery = (ModifyQuery)this.changeSetDeleteNullQuery.clone();
        }
        if (this.deleteAtIndexQuery != null) {
            clone.deleteAtIndexQuery = (ModifyQuery)this.deleteAtIndexQuery.clone();
        }
        if (this.updateAtIndexQuery != null) {
            clone.updateAtIndexQuery = (ModifyQuery)this.updateAtIndexQuery.clone();
        }
        return clone;
    }

    @Override
    public void compareCollectionsForChange(Object oldCollection, Object newCollection, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        if (this.listOrderField != null) {
            this.compareListsForChange((List)oldCollection, (List)newCollection, changeRecord, session);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        int numberOfNewNulls = 0;
        HashMap<Object, Integer> originalKeyValues = new HashMap<Object, Integer>(10);
        HashMap<Object, Integer> cloneKeyValues = new HashMap<Object, Integer>(10);
        if (oldCollection != null) {
            Object backUpIter = cp.iteratorFor(oldCollection);
            while (cp.hasNext(backUpIter)) {
                Object secondObject = cp.next(backUpIter, session);
                if (secondObject == null) {
                    --numberOfNewNulls;
                    continue;
                }
                Integer count = (Integer)originalKeyValues.get(secondObject);
                if (count == null) {
                    originalKeyValues.put(secondObject, 1);
                    continue;
                }
                originalKeyValues.put(secondObject, count + 1);
            }
        }
        HashMap databaseCount = (HashMap)originalKeyValues.clone();
        int databaseNullCount = Math.abs(numberOfNewNulls);
        if (newCollection != null) {
            Object cloneIter = cp.iteratorFor(newCollection);
            while (cp.hasNext(cloneIter)) {
                Object firstObject = cp.next(cloneIter, session);
                if (firstObject == null) {
                    ++numberOfNewNulls;
                    continue;
                }
                Integer count = (Integer)originalKeyValues.get(firstObject);
                if (count == null) {
                    Integer cloneCount = (Integer)cloneKeyValues.get(firstObject);
                    if (cloneCount == null) {
                        cloneKeyValues.put(firstObject, 1);
                        continue;
                    }
                    cloneKeyValues.put(firstObject, cloneCount + 1);
                    continue;
                }
                if (count == 1) {
                    originalKeyValues.remove(firstObject);
                    continue;
                }
                originalKeyValues.put(firstObject, count - 1);
            }
        }
        if (cloneKeyValues.isEmpty() && originalKeyValues.isEmpty() && numberOfNewNulls == 0 && !changeRecord.getOwner().isNew()) {
            return;
        }
        ((DirectCollectionChangeRecord)changeRecord).clearChanges();
        ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(cloneKeyValues, databaseCount);
        ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(originalKeyValues, databaseCount);
        ((DirectCollectionChangeRecord)changeRecord).setIsDeferred(false);
        ((DirectCollectionChangeRecord)changeRecord).setLatestCollection(null);
        if (numberOfNewNulls != 0) {
            ((DirectCollectionChangeRecord)changeRecord).getCommitAddMap().put(null, databaseNullCount);
            if (numberOfNewNulls > 0) {
                ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(null, numberOfNewNulls);
            } else {
                ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(null, numberOfNewNulls *= -1);
            }
        }
    }

    public void compareListsForChange(List oldList, List newList, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        HashMap changedIndexes = new HashMap(Math.max(oldList.size(), newList.size()));
        int nOldSize = 0;
        if (oldList != null) {
            nOldSize = oldList.size();
            for (int i = 0; i < nOldSize; ++i) {
                Object obj = oldList.get(i);
                Set[] indexes = (Set[])changedIndexes.get(obj);
                if (indexes == null) {
                    indexes = new Set[]{new HashSet(), null};
                    changedIndexes.put(obj, indexes);
                }
                indexes[0].add(i);
            }
        }
        HashSet removedFromChangedIndexes = new HashSet();
        HashSet dummySet = new HashSet(0);
        int nNewSize = 0;
        if (newList != null) {
            nNewSize = newList.size();
            for (int i = 0; i < nNewSize; ++i) {
                Object obj = newList.get(i);
                Set[] indexes = (Set[])changedIndexes.get(obj);
                if (indexes == null) {
                    indexes = removedFromChangedIndexes.contains(obj) ? new Set[]{dummySet, new HashSet()} : new Set[]{null, new HashSet()};
                    changedIndexes.put(obj, indexes);
                    indexes[1].add(i);
                    continue;
                }
                if (indexes[0] == null || !indexes[0].contains(i)) {
                    if (indexes[1] == null) {
                        indexes[1] = new HashSet();
                    }
                    indexes[1].add(i);
                    continue;
                }
                indexes[0].remove(i);
                if (!indexes[0].isEmpty() || indexes[1] != null && !indexes[1].isEmpty()) continue;
                changedIndexes.remove(obj);
                removedFromChangedIndexes.add(obj);
            }
        }
        ((DirectCollectionChangeRecord)changeRecord).setChangedIndexes(changedIndexes);
        ((DirectCollectionChangeRecord)changeRecord).setOldSize(nOldSize);
        ((DirectCollectionChangeRecord)changeRecord).setNewSize(nNewSize);
    }

    @Override
    public org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = this.getAttributeValueFromObject(clone);
        Object backUpAttribute = null;
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(clone, session);
        Object backUpCollection = null;
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            backUpCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
        }
        DirectCollectionChangeRecord changeRecord = new DirectCollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        if (this.listOrderField != null) {
            changeRecord.setLatestCollection(cloneObjectCollection);
        }
        this.compareCollectionsForChange(backUpCollection, cloneObjectCollection, changeRecord, session);
        if (changeRecord.hasChanges()) {
            changeRecord.setOriginalCollection(backUpCollection);
            return changeRecord;
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        int count;
        Object object;
        Object firstCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        if (this.listOrderField != null) {
            return this.compareLists((List)firstCollection, (List)secondCollection);
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(firstCollection) != containerPolicy.sizeFor(secondCollection)) {
            return false;
        }
        HashMap<Object, Integer> firstCounter = new HashMap<Object, Integer>();
        HashMap<Object, Integer> secondCounter = new HashMap<Object, Integer>();
        Object iter = containerPolicy.iteratorFor(firstCollection);
        while (containerPolicy.hasNext(iter)) {
            object = containerPolicy.next(iter, session);
            if (firstCounter.containsKey(object)) {
                count = (Integer)firstCounter.get(object);
                firstCounter.put(object, ++count);
                continue;
            }
            firstCounter.put(object, 1);
        }
        iter = containerPolicy.iteratorFor(secondCollection);
        while (containerPolicy.hasNext(iter)) {
            object = containerPolicy.next(iter, session);
            if (secondCounter.containsKey(object)) {
                count = (Integer)secondCounter.get(object);
                secondCounter.put(object, ++count);
                continue;
            }
            secondCounter.put(object, 1);
        }
        Iterator iterator = firstCounter.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!secondCounter.containsKey(object) || ((Integer)secondCounter.get(object)).intValue() != ((Integer)firstCounter.get(object)).intValue()) {
                boolean found = false;
                for (Object otherObject : secondCounter.keySet()) {
                    found = object == otherObject ? true : (object == null || otherObject == null ? false : Helper.comparePotentialArrays(object, otherObject));
                    if (!found) continue;
                    iterator.remove();
                    secondCounter.remove(otherObject);
                    break;
                }
                if (found) continue;
                return false;
            }
            iterator.remove();
            secondCounter.remove(object);
        }
        return firstCounter.isEmpty() && secondCounter.isEmpty();
    }

    protected boolean compareLists(List firstList, List secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        int size = firstList.size();
        for (int i = 0; i < size; ++i) {
            Object secondObject;
            Object firstObject = firstList.get(i);
            if (firstObject == (secondObject = secondList.get(i))) continue;
            if (firstObject == null || secondObject == null) {
                return false;
            }
            if (firstObject.equals(secondObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        String typeName;
        super.convertClassNamesToClasses(classLoader);
        if (null == this.attributeClassification && null != (typeName = this.directField.getTypeName())) {
            block21: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.attributeClassification = (Class)AccessController.doPrivileged(new PrivilegedClassForName(typeName, true, classLoader));
                            break block21;
                        }
                        catch (PrivilegedActionException pae) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(typeName, pae.getException());
                        }
                    }
                    this.attributeClassification = PrivilegedAccessHelper.getClassForName(typeName, true, classLoader);
                }
                catch (ClassNotFoundException cnfe) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(typeName, cnfe);
                }
                catch (Exception iae_or_ie) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(typeName, iae_or_ie);
                }
            }
            this.attributeClassificationName = typeName;
        }
        if (null != this.attributeClassification) {
            this.attributeObjectClassification = Helper.getObjectClass(this.attributeClassification);
            this.directField.setType(this.attributeClassification);
        }
        if (this.valueConverter != null) {
            if (this.valueConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            } else if (this.valueConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.valueConverterClassName != null) {
            Converter valueConverter;
            block22: {
                try {
                    Class valueConverterClass;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            valueConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.valueConverterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, exception.getException());
                        }
                        try {
                            valueConverter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(valueConverterClass));
                            break block22;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, exception.getException());
                        }
                    }
                    valueConverterClass = PrivilegedAccessHelper.getClassForName(this.valueConverterClassName, true, classLoader);
                    valueConverter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(valueConverterClass);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, e);
                }
            }
            this.setValueConverter(valueConverter);
        }
    }

    @Override
    protected Object extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        int size = this.referenceKeyFields.size();
        Object[] key = new Object[size];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField relationField = this.referenceKeyFields.get(index);
            DatabaseField sourceField = this.sourceKeyFields.get(index);
            Object value = row.get(relationField);
            try {
                value = conversionManager.convertObject(value, sourceField.getType());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key[index] = value;
        }
        return new CacheId(key);
    }

    @Override
    protected Object extractBatchKeyFromRow(AbstractRecord row, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        Object[] key = new Object[size];
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = this.sourceKeyFields.get(index);
            Object value = row.get(field);
            try {
                value = conversionManager.convertObject(value, field.getType());
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, exception);
            }
            key[index] = value;
        }
        return new CacheId(key);
    }

    @Override
    protected Expression buildBatchCriteria(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        int size = this.referenceKeyFields.size();
        Expression table = builder.getTable(this.referenceTable);
        if (size > 1) {
            ArrayList<Expression> fields = new ArrayList<Expression>(size);
            for (DatabaseField referenceKeyField : this.referenceKeyFields) {
                fields.add(table.getField(referenceKeyField));
            }
            return query.getSession().getPlatform().buildBatchCriteriaForComplexId(builder, fields);
        }
        return query.getSession().getPlatform().buildBatchCriteria(builder, table.getField(this.referenceKeyFields.get(0)));
    }

    @Override
    protected void executeBatchQuery(DatabaseQuery query, CacheKey parentCacheKey, Map referenceDataByKey, AbstractSession session, AbstractRecord translationRow) {
        block8: {
            int size;
            List rows;
            block7: {
                rows = (List)session.executeQuery(query, translationRow);
                size = rows.size();
                if (!this.containerPolicy.shouldAddAll()) break block7;
                if (size <= 0) break block8;
                HashMap<Object, List[]> referenceDataAndRowsByKey = new HashMap<Object, List[]>();
                for (int index = 0; index < size; ++index) {
                    List[] valuesAndRows;
                    AbstractRecord referenceRow = (AbstractRecord)rows.get(index);
                    Object referenceValue = referenceRow.get(this.directField);
                    Object eachReferenceKey = this.extractKeyFromTargetRow(referenceRow, session);
                    if (this.valueConverter != null) {
                        referenceValue = this.valueConverter.convertDataValueToObjectValue(referenceValue, query.getSession());
                    }
                    if ((valuesAndRows = (List[])referenceDataAndRowsByKey.get(eachReferenceKey)) == null) {
                        valuesAndRows = new List[]{new ArrayList(), new ArrayList()};
                        referenceDataAndRowsByKey.put(eachReferenceKey, valuesAndRows);
                    }
                    valuesAndRows[0].add(referenceValue);
                    valuesAndRows[1].add(referenceRow);
                }
                for (Map.Entry entry : referenceDataAndRowsByKey.entrySet()) {
                    Object eachReferenceKey = entry.getKey();
                    List referenceValues = ((List[])entry.getValue())[0];
                    List referenceRows = ((List[])entry.getValue())[1];
                    Object container = this.containerPolicy.containerInstance(referenceValues.size());
                    this.containerPolicy.addAll(referenceValues, container, query.getSession(), (List<AbstractRecord>)referenceRows, (DataReadQuery)query, parentCacheKey, true);
                    referenceDataByKey.put(eachReferenceKey, container);
                }
                break block8;
            }
            for (int index = 0; index < size; ++index) {
                AbstractRecord referenceRow = (AbstractRecord)rows.get(index);
                Object referenceValue = referenceRow.get(this.directField);
                Object eachReferenceKey = this.extractKeyFromTargetRow(referenceRow, session);
                Object container = referenceDataByKey.get(eachReferenceKey);
                if (container == null || container == Helper.NULL_VALUE) {
                    container = this.containerPolicy.containerInstance();
                    referenceDataByKey.put(eachReferenceKey, container);
                }
                if (this.valueConverter != null) {
                    referenceValue = this.valueConverter.convertDataValueToObjectValue(referenceValue, query.getSession());
                }
                this.containerPolicy.addInto(referenceValue, container, query.getSession());
            }
        }
    }

    @Override
    public void fixRealObjectReferences(Object object, Map objectInformation, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
    }

    @Override
    public Class getAttributeClassification() {
        return this.attributeClassification;
    }

    public String getAttributeClassificationName() {
        if (null == this.attributeClassificationName && this.attributeClassification != null) {
            this.attributeClassificationName = this.attributeClassification.getName();
        }
        return this.attributeClassificationName;
    }

    protected ModifyQuery getDeleteQuery() {
        if (this.changeSetDeleteQuery == null) {
            this.changeSetDeleteQuery = new DataModifyQuery();
        }
        return this.changeSetDeleteQuery;
    }

    protected ModifyQuery getDeleteNullQuery() {
        if (this.changeSetDeleteNullQuery == null) {
            this.changeSetDeleteNullQuery = new DataModifyQuery();
        }
        return this.changeSetDeleteNullQuery;
    }

    protected ModifyQuery getDeleteAtIndexQuery() {
        if (this.deleteAtIndexQuery == null) {
            this.deleteAtIndexQuery = new DataModifyQuery();
        }
        return this.deleteAtIndexQuery;
    }

    protected ModifyQuery getUpdateAtIndexQuery() {
        if (this.updateAtIndexQuery == null) {
            this.updateAtIndexQuery = new DataModifyQuery();
        }
        return this.updateAtIndexQuery;
    }

    @Override
    public Vector getSelectFields() {
        NonSynchronizedVector fields = new NonSynchronizedVector(2);
        ((Vector)fields).add(this.getDirectField());
        return fields;
    }

    @Override
    public Vector getSelectTables() {
        NonSynchronizedVector tables = new NonSynchronizedVector(0);
        ((Vector)tables).add(this.getReferenceTable());
        return tables;
    }

    public DatabaseField getDirectField() {
        return this.directField;
    }

    public String getDirectFieldName() {
        if (this.getDirectField() == null) {
            return null;
        }
        return this.getDirectField().getQualifiedName();
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    @Override
    public Expression getJoinCriteria(QueryKeyExpression exp) {
        if (this.getHistoryPolicy() != null) {
            Expression result = super.getJoinCriteria(exp);
            Expression historyCriteria = this.getHistoryPolicy().additionalHistoryExpression(exp);
            if (result != null) {
                return result.and(historyCriteria);
            }
            if (historyCriteria != null) {
                return historyCriteria;
            }
            return null;
        }
        return super.getJoinCriteria(exp);
    }

    @Override
    public Object getObjectCorrespondingTo(Object object, RemoteSession session, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        return object;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    @Override
    protected ContainerPolicy getSelectionQueryContainerPolicy() {
        return ((DataReadQuery)this.getSelectionQuery()).getContainerPolicy();
    }

    @Override
    public Class getReferenceClass() {
        return null;
    }

    @Override
    public String getReferenceClassName() {
        return null;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public Vector getReferenceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getReferenceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getReferenceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getReferenceKeyFields() {
        return this.referenceKeyFields;
    }

    public DatabaseTable getReferenceTable() {
        return this.referenceTable;
    }

    public String getReferenceTableName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getName();
    }

    public String getReferenceTableQualifiedName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getQualifiedName();
    }

    @Override
    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    protected boolean hasCustomDeleteAtIndexQuery() {
        return this.hasCustomDeleteAtIndexQuery;
    }

    protected boolean hasCustomUpdateAtIndexQuery() {
        return this.hasCustomUpdateAtIndexQuery;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (session.hasBroker() && this.getInsertQuery().hasSessionName()) {
            session = session.getBroker().getSessionForName(this.getInsertQuery().getSessionName());
        }
        if (this.isKeyForSourceSpecified()) {
            this.initializeSourceKeys(session);
        } else {
            this.initializeSourceKeysWithDefaults(session);
        }
        this.initializeReferenceTable(session);
        this.initializeReferenceKeys(session);
        this.initializeDirectField(session);
        if (this.getReferenceTable().getName().indexOf(32) != -1) {
            String beginQuote = ((DatasourcePlatform)session.getDatasourcePlatform()).getStartDelimiter();
            String endQuote = ((DatasourcePlatform)session.getDatasourcePlatform()).getEndDelimiter();
            if (this.getReferenceTable().getName().indexOf(beginQuote) == -1) {
                this.getReferenceTable().setName(beginQuote + this.getReferenceTable().getName() + endQuote);
            }
        }
        if (this.listOrderField != null) {
            this.initializeListOrderField(session);
        }
        this.getContainerPolicy().initialize(session, this.referenceTable);
        if (!this.hasCustomSelectionQuery()) {
            this.initOrRebuildSelectQuery();
            this.getSelectionQuery().setName(this.getAttributeName());
            if (this.shouldInitializeSelectionCriteria()) {
                this.initializeSelectionCriteria(session);
                this.initializeSelectionStatement(session);
            }
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(session.getName());
        }
        if (this.getSelectionQuery().getPartitioningPolicy() == null) {
            this.getSelectionQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        this.getSelectionQuery().setSourceMapping(this);
        if (this.getValueConverter() != null && this.getSelectionQuery() instanceof DirectReadQuery) {
            ((DirectReadQuery)this.getSelectionQuery()).setValueConverter(this.getValueConverter());
        }
        this.initializeDeleteAllQuery(session);
        this.initializeDeleteQuery(session);
        this.initializeDeleteNullQuery(session);
        this.initializeInsertQuery(session);
        this.initializeDeleteAtIndexQuery(session);
        this.initializeUpdateAtIndexQuery(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        }
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
        super.initialize(session);
    }

    @Override
    protected void initializeListOrderField(AbstractSession session) {
        if (!this.getContainerPolicy().isOrderedListPolicy() || ((OrderedListContainerPolicy)this.getContainerPolicy()).getListOrderField() == null) {
            super.initializeListOrderField(session);
        }
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        if (this.getDeleteAllQuery().getPartitioningPolicy() == null) {
            this.getDeleteAllQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = expression == null ? subExpression : expression.and(subExpression);
        }
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteAllQuery().setSQLStatement(statement);
    }

    protected void initializeDeleteQuery(AbstractSession session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.getDeleteQuery().getPartitioningPolicy() == null) {
            this.getDeleteQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        SQLDeleteStatement statement = new SQLDeleteStatement();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = this.createWhereClauseForDeleteQuery(builder);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeDeleteNullQuery(AbstractSession session) {
        if (!this.getDeleteNullQuery().hasSessionName()) {
            this.getDeleteNullQuery().setSessionName(session.getName());
        }
        if (this.getDeleteNullQuery().getPartitioningPolicy() == null) {
            this.getDeleteNullQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        SQLDeleteStatement statement = new SQLDeleteStatement();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = this.createWhereClauseForDeleteNullQuery(builder);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteNullQuery().setSQLStatement(statement);
    }

    protected void initializeDeleteAtIndexQuery(AbstractSession session) {
        if (!this.getDeleteAtIndexQuery().hasSessionName()) {
            this.getDeleteAtIndexQuery().setSessionName(session.getName());
        }
        if (this.getDeleteAtIndexQuery().getPartitioningPolicy() == null) {
            this.getDeleteAtIndexQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        if (this.hasCustomDeleteAtIndexQuery()) {
            return;
        }
        SQLDeleteStatement statement = new SQLDeleteStatement();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = this.createWhereClauseForDeleteQuery(builder);
        expression = expression.and(builder.getField(this.listOrderField).equal(builder.getParameter(this.listOrderField)));
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteAtIndexQuery().setSQLStatement(statement);
    }

    protected void initializeUpdateAtIndexQuery(AbstractSession session) {
        if (!this.getUpdateAtIndexQuery().hasSessionName()) {
            this.getUpdateAtIndexQuery().setSessionName(session.getName());
        }
        if (this.getUpdateAtIndexQuery().getPartitioningPolicy() == null) {
            this.getUpdateAtIndexQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        if (this.hasCustomUpdateAtIndexQuery()) {
            return;
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = this.createWhereClauseForDeleteQuery(builder);
        expression = expression.and(builder.getField(this.listOrderField).equal(builder.getParameter(this.listOrderField)));
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        DatabaseRecord modifyRow = new DatabaseRecord();
        modifyRow.add(this.listOrderField, null);
        statement.setModifyRow(modifyRow);
        this.getUpdateAtIndexQuery().setSQLStatement(statement);
    }

    @Override
    public boolean shouldUseListOrderFieldTableExpression() {
        return true;
    }

    protected Expression createWhereClauseForDeleteQuery(ExpressionBuilder builder) {
        Expression directExp = builder.getField(this.getDirectField()).equal(builder.getParameter(this.getDirectField()));
        Expression expression = null;
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Expression subExp1 = builder.getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
        }
        expression = expression.and(directExp);
        return expression;
    }

    protected Expression createWhereClauseForDeleteNullQuery(ExpressionBuilder builder) {
        Expression directExp = builder.getField(this.getDirectField()).isNull();
        Expression expression = null;
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Expression subExp1 = builder.getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
        }
        expression = expression.and(directExp);
        return expression;
    }

    protected void initializeDirectField(AbstractSession session) throws DescriptorException {
        if (this.getDirectField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectField().setTable(this.getReferenceTable());
        this.getDirectField().setIndex(0);
    }

    protected void initializeInsertQuery(AbstractSession session) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.getInsertQuery().getPartitioningPolicy() == null) {
            this.getInsertQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement statement = new SQLInsertStatement();
        statement.setTable(this.getReferenceTable());
        DatabaseRecord directRow = new DatabaseRecord();
        Enumeration<DatabaseField> referenceEnum = this.getReferenceKeyFields().elements();
        while (referenceEnum.hasMoreElements()) {
            directRow.put(referenceEnum.nextElement(), (Object)null);
        }
        directRow.put(this.getDirectField(), (Object)null);
        if (this.listOrderField != null) {
            directRow.put(this.listOrderField, (Object)null);
        }
        statement.setModifyRow(directRow);
        this.getInsertQuery().setSQLStatement(statement);
        this.getInsertQuery().setModifyRow(directRow);
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession session) {
    }

    protected void initializeReferenceKeys(AbstractSession session) throws DescriptorException {
        if (this.getReferenceKeyFields().size() == 0) {
            throw DescriptorException.noReferenceKeyIsSpecified(this);
        }
        Enumeration<DatabaseField> referenceEnum = this.getReferenceKeyFields().elements();
        while (referenceEnum.hasMoreElements()) {
            DatabaseField field = referenceEnum.nextElement();
            if (field.hasTableName() && !field.getTableName().equals(this.getReferenceTable().getName())) {
                throw DescriptorException.referenceKeyFieldNotProperlySpecified(field, this);
            }
            field.setTable(this.getReferenceTable());
        }
    }

    protected void initializeReferenceTable(AbstractSession session) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (this.getReferenceTable() == null) {
            throw DescriptorException.referenceTableNotSpecified(this);
        }
        if (platform.getTableQualifier().length() > 0 && this.getReferenceTable().getTableQualifier().length() == 0) {
            this.getReferenceTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        Expression criteria = null;
        ExpressionBuilder base = new ExpressionBuilder();
        TableExpression table = (TableExpression)base.getTable(this.getReferenceTable());
        Iterator<DatabaseField> referenceKeys = this.getReferenceKeyFields().iterator();
        Iterator<DatabaseField> sourceKeys = this.getSourceKeyFields().iterator();
        while (referenceKeys.hasNext()) {
            DatabaseField referenceKey = referenceKeys.next();
            DatabaseField sourceKey = sourceKeys.next();
            Expression expression = table.getField(referenceKey).equal(base.getParameter(sourceKey));
            if (criteria == null) {
                criteria = expression;
                continue;
            }
            criteria = expression.and(criteria);
        }
        this.setSelectionCriteria(criteria);
    }

    @Override
    protected void initializeSelectionQuery(AbstractSession session) {
    }

    protected void initializeSelectionStatement(AbstractSession session) {
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.getReferenceTable());
        statement.addField(this.getDirectField().clone());
        statement.setWhereClause(this.getSelectionCriteria());
        this.getSelectionQuery().setSQLStatement(statement);
        this.getContainerPolicy().addAdditionalFieldsToQuery(this.selectionQuery, this.getAdditionalFieldsBaseExpression(this.getSelectionQuery()));
        statement.normalize(session, null);
    }

    protected void initializeSourceKeys(AbstractSession session) {
        for (int index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField field = this.getDescriptor().buildField(this.getSourceKeyFields().get(index));
            this.getSourceKeyFields().set(index, field);
        }
    }

    protected void initializeSourceKeysWithDefaults(AbstractSession session) {
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getSourceKeyFields().addElement(primaryKeyFields.get(index));
        }
    }

    @Override
    protected Expression getAdditionalFieldsBaseExpression(ReadQuery query) {
        if (query.isReadAllQuery()) {
            return ((ReadAllQuery)query).getExpressionBuilder();
        }
        return ((DataReadQuery)query).getSQLStatement().getBuilder().getTable(this.getReferenceTable());
    }

    @Override
    public boolean isDirectCollectionMapping() {
        return true;
    }

    @Override
    public boolean isElementCollectionMapping() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    protected boolean isKeyForSourceSpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public boolean isLockableMapping() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return true;
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        if (iterator.shouldIterateOnPrimitives()) {
            super.iterateOnRealAttributeValue(iterator, realAttributeValue);
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        iterator.iteratePrimitiveForMapping(element, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChangesIntoObject(Object target, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.descriptor.isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfTarget = null;
        AbstractSession session = mergeManager.getSession();
        HashMap addObjects = ((DirectCollectionChangeRecord)changeRecord).getAddObjectMap();
        HashMap removeObjects = ((DirectCollectionChangeRecord)changeRecord).getRemoveObjectMap();
        valueOfTarget = this.isAttributeValueInstantiated(target) && !changeRecord.getOwner().isNew() ? this.getRealCollectionAttributeValueFromObject(target, session) : containerPolicy.containerInstance(addObjects.size());
        if (!this.isAttributeValueInstantiated(target)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object iterator = containerPolicy.iteratorFor(this.getRealCollectionAttributeValueFromObject(source, session));
            while (containerPolicy.hasNext(iterator)) {
                containerPolicy.addInto(containerPolicy.next(iterator, session), valueOfTarget, session);
            }
        } else {
            Object synchronizationTarget = valueOfTarget;
            if (valueOfTarget instanceof IndirectCollection) {
                synchronizationTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
                if (((DirectCollectionChangeRecord)changeRecord).orderHasBeenRepaired() && valueOfTarget instanceof IndirectList) {
                    ((IndirectList)valueOfTarget).setIsListOrderBrokenInDb(false);
                }
            }
            Object object = synchronizationTarget;
            synchronized (object) {
                int i;
                int objectCount;
                for (Object object2 : addObjects.keySet()) {
                    objectCount = (Integer)addObjects.get(object2);
                    for (i = 0; i < objectCount; ++i) {
                        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                            if (containerPolicy.contains(object2, valueOfTarget, session)) continue;
                            containerPolicy.addInto(object2, valueOfTarget, session);
                            continue;
                        }
                        containerPolicy.addInto(object2, valueOfTarget, session);
                    }
                }
                for (Object object2 : removeObjects.keySet()) {
                    objectCount = (Integer)removeObjects.get(object2);
                    for (i = 0; i < objectCount; ++i) {
                        containerPolicy.removeFrom(object2, valueOfTarget, session);
                    }
                }
                if (this.listOrderField != null && ((DirectCollectionChangeRecord)changeRecord).getChangedIndexes() == null) {
                    this.compareListsForChange((List)((DirectCollectionChangeRecord)changeRecord).getOriginalCollection(), (List)((DirectCollectionChangeRecord)changeRecord).getLatestCollection(), changeRecord, session);
                }
                if (((DirectCollectionChangeRecord)changeRecord).getChangedIndexes() != null) {
                    int oldSize = ((DirectCollectionChangeRecord)changeRecord).getOldSize();
                    int newSize = ((DirectCollectionChangeRecord)changeRecord).getNewSize();
                    int delta = newSize - oldSize;
                    Object[] newTail = null;
                    if (delta > 0) {
                        newTail = new Object[delta];
                    }
                    for (Map.Entry entry : ((DirectCollectionChangeRecord)changeRecord).getChangedIndexes().entrySet()) {
                        Object value = entry.getKey();
                        Set[] indexes = (Set[])entry.getValue();
                        Set indexesAfter = indexes[1];
                        if (indexesAfter == null) continue;
                        Iterator itIndexesAfter = indexesAfter.iterator();
                        while (itIndexesAfter.hasNext()) {
                            int index = (Integer)itIndexesAfter.next();
                            if (index < oldSize) {
                                ((List)synchronizationTarget).set(index, value);
                                continue;
                            }
                            newTail[index - oldSize] = value;
                        }
                    }
                    if (delta > 0) {
                        for (int i2 = 0; i2 < delta; ++i2) {
                            ((List)synchronizationTarget).add(newTail[i2]);
                        }
                    } else if (delta < 0) {
                        for (int i3 = oldSize - 1; i3 >= newSize; --i3) {
                            ((List)synchronizationTarget).remove(i3);
                        }
                    }
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        DirectCollectionChangeRecord changeRecord;
        ObjectChangeSet changeSet;
        if (this.descriptor.isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), targetSession));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiatedOrChanged(source)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
        Object newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        boolean fireCollectionChangeEvents = false;
        boolean firePropertyChangeEvent = false;
        ObjectChangeListener listener = null;
        if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null) {
            listener = (ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener();
            if (this.listOrderField == null) {
                fireCollectionChangeEvents = true;
                Object iterator = containerPolicy.iteratorFor(valueOfTarget);
                Integer zero = 0;
                while (containerPolicy.hasNext(iterator)) {
                    CollectionChangeEvent event = containerPolicy.createChangeEvent(target, this.getAttributeName(), valueOfTarget, containerPolicy.next(iterator, mergeManager.getSession()), CollectionChangeEvent.REMOVE, zero, false);
                    listener.internalPropertyChange(event);
                }
                if (newContainer instanceof ChangeTracker) {
                    ((ChangeTracker)newContainer)._persistence_setPropertyChangeListener(((ChangeTracker)target)._persistence_getPropertyChangeListener());
                }
                if (valueOfTarget instanceof ChangeTracker) {
                    ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(null);
                }
            } else {
                firePropertyChangeEvent = true;
            }
        }
        Object originalValueOfTarget = valueOfTarget;
        valueOfTarget = newContainer;
        int i = 0;
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object sourceValue = containerPolicy.next(sourceValuesIterator, mergeManager.getSession());
            if (fireCollectionChangeEvents) {
                CollectionChangeEvent event = containerPolicy.createChangeEvent(target, this.getAttributeName(), valueOfTarget, sourceValue, CollectionChangeEvent.ADD, i, false);
                listener.internalPropertyChange(event);
            }
            containerPolicy.addInto(sourceValue, valueOfTarget, mergeManager.getSession());
            ++i;
        }
        if (fireCollectionChangeEvents && this.descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (changeSet = ((AttributeChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (changeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!changeRecord.isDeferred()) {
                if (!changeRecord.hasChanges()) {
                    changeSet.removeChange(this.getAttributeName());
                }
            } else {
                changeRecord.setLatestCollection(valueOfTarget);
            }
        }
        if (firePropertyChangeEvent) {
            ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new PropertyChangeEvent(target, this.getAttributeName(), originalValueOfTarget, valueOfTarget));
            if (valueOfTarget instanceof ChangeTracker) {
                ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(((ChangeTracker)target)._persistence_getPropertyChangeListener());
            }
            if (originalValueOfTarget instanceof ChangeTracker) {
                ((ChangeTracker)originalValueOfTarget)._persistence_setPropertyChangeListener(null);
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] == Delete) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)event[1], (AbstractRecord)event[2], session);
            }
        } else if (event[0] == Insert) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalInsert((DataModifyQuery)event[1], (AbstractRecord)event[2], session);
            }
        } else if (event[0] == DeleteAll) {
            this.preDelete((DeleteObjectQuery)event[1]);
        } else if (event[0] == DeleteAtIndex) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
        } else if (event[0] == UpdateAtIndex) {
            DataModifyQuery updateAtIndexQuery = (DataModifyQuery)((DataModifyQuery)event[1]).clone();
            updateAtIndexQuery.setModifyRow((AbstractRecord)event[3]);
            updateAtIndexQuery.setHasModifyRow(true);
            updateAtIndexQuery.setIsExecutionClone(true);
            session.executeQuery((DatabaseQuery)updateAtIndexQuery, (AbstractRecord)event[2]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
    }

    @Override
    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl uow) {
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        DatabaseRecord databaseRow = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(objects)) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(referenceKey, sourceKeyValue);
        }
        int orderIndex = 0;
        Object iter = containerPolicy.iteratorFor(objects);
        while (containerPolicy.hasNext(iter)) {
            Object wrappedObject = containerPolicy.nextEntry(iter, query.getSession());
            Object object = containerPolicy.unwrapIteratorResult(wrappedObject);
            if (this.getValueConverter() != null) {
                object = this.getValueConverter().convertObjectValueToDataValue(object, query.getSession());
            }
            databaseRow.put(this.getDirectField(), object);
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{Insert, this.getInsertQuery(), databaseRow.clone()};
                if (this.listOrderField != null) {
                    ((AbstractRecord)event[2]).put(this.listOrderField, (Object)orderIndex++);
                }
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
            } else {
                query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
                if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                    this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRow, query.getSession());
                }
            }
            containerPolicy.propogatePostInsert(query, wrappedObject);
        }
    }

    public Object getFieldValue(Object attributeValue, AbstractSession session) {
        if (this.valueConverter != null) {
            return this.valueConverter.convertObjectValueToDataValue(attributeValue, session);
        }
        return attributeValue;
    }

    @Override
    public Vector getFieldsForTranslationInAggregate() {
        return this.getSourceKeyFields();
    }

    @Override
    public void postUpdate(WriteObjectQuery writeQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (writeQuery.getObjectChangeSet() != null) {
            if (this.listOrderField != null) {
                this.postUpdateWithChangeSetListOrder(writeQuery);
            } else {
                this.postUpdateWithChangeSet(writeQuery);
            }
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        if (writeQuery.getSession().isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), writeQuery.getSession())) {
            return;
        }
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.setObject(writeQuery.getObject());
        deleteQuery.setSession(writeQuery.getSession());
        deleteQuery.setTranslationRow(writeQuery.getTranslationRow());
        if (writeQuery.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[3];
            event[0] = DeleteAll;
            event[1] = deleteQuery;
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.preDelete(deleteQuery);
        }
        this.postInsert(writeQuery);
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeQuery) throws DatabaseException {
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectCollectionChangeRecord changeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
        }
        for (Object object : changeRecord.getRemoveObjectMap().keySet()) {
            AbstractRecord thisRow = writeQuery.getTranslationRow().clone();
            Object value = this.getFieldValue(object, writeQuery.getSession());
            Object[] event = new Object[3];
            event[0] = Delete;
            if (value == null) {
                event[1] = this.getDeleteNullQuery();
            } else {
                thisRow.add(this.getDirectField(), value);
                event[1] = this.getDeleteQuery();
            }
            event[2] = thisRow;
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            Integer count = (Integer)changeRecord.getCommitAddMap().get(object);
            if (count == null) continue;
            for (int counter = count.intValue(); counter > 0; --counter) {
                thisRow = writeQuery.getTranslationRow().clone();
                thisRow.add(this.getDirectField(), value);
                event = new Object[]{Insert, this.getInsertQuery(), thisRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            }
        }
        for (Object object : changeRecord.getAddObjectMap().keySet()) {
            Integer count = (Integer)changeRecord.getAddObjectMap().get(object);
            for (int counter = count.intValue(); counter > 0; --counter) {
                AbstractRecord thisRow = writeQuery.getTranslationRow().clone();
                Object value = object;
                if (this.getValueConverter() != null) {
                    value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
                }
                thisRow.add(this.getDirectField(), value);
                Object[] event = new Object[]{Insert, this.getInsertQuery(), thisRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            }
        }
    }

    protected void postUpdateWithChangeSetListOrder(WriteObjectQuery writeQuery) throws DatabaseException {
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectCollectionChangeRecord changeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
        }
        boolean shouldRepairOrder = false;
        if ((List)changeRecord.getLatestCollection() instanceof IndirectList) {
            shouldRepairOrder = ((IndirectList)changeRecord.getLatestCollection()).isListOrderBrokenInDb();
        }
        if (shouldRepairOrder) {
            DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
            deleteQuery.setObject(writeQuery.getObject());
            deleteQuery.setSession(writeQuery.getSession());
            deleteQuery.setTranslationRow(writeQuery.getTranslationRow());
            Object[] eventDeleteAll = new Object[]{DeleteAll, deleteQuery};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, eventDeleteAll);
            for (int i = 0; i < ((List)changeRecord.getLatestCollection()).size(); ++i) {
                Object value = ((List)changeRecord.getLatestCollection()).get(i);
                value = this.getFieldValue(value, writeQuery.getSession());
                AbstractRecord insertRow = writeQuery.getTranslationRow().clone();
                insertRow.add(this.getDirectField(), value);
                insertRow.add(this.listOrderField, i);
                Object[] event = new Object[]{Insert, this.getInsertQuery(), insertRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            }
            ((IndirectList)changeRecord.getLatestCollection()).setIsListOrderBrokenInDb(false);
            changeRecord.setOrderHasBeenRepaired(true);
            return;
        }
        if (changeRecord.getChangedIndexes() == null) {
            this.compareListsForChange((List)changeRecord.getOriginalCollection(), (List)changeRecord.getLatestCollection(), changeRecord, writeQuery.getSession());
        }
        for (Map.Entry entry : changeRecord.getChangedIndexes().entrySet()) {
            Object[] event;
            Iterator itBefore;
            Object value = entry.getKey();
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
            }
            Set[] indexes = (Set[])entry.getValue();
            Set indexesBefore = indexes[0];
            Set indexesAfter = indexes[1];
            if (indexesAfter == null) {
                AbstractRecord deleteRow = writeQuery.getTranslationRow().clone();
                Object[] event2 = new Object[3];
                event2[0] = Delete;
                if (value == null) {
                    event2[1] = this.getDeleteNullQuery();
                } else {
                    deleteRow.add(this.getDirectField(), value);
                    event2[1] = this.getDeleteQuery();
                }
                event2[2] = deleteRow;
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event2);
                continue;
            }
            if (indexesAfter.isEmpty()) {
                itBefore = indexesBefore.iterator();
                while (itBefore.hasNext()) {
                    AbstractRecord deleteAtIndexRow = writeQuery.getTranslationRow().clone();
                    deleteAtIndexRow.add(this.getDirectField(), value);
                    deleteAtIndexRow.add(this.listOrderField, itBefore.next());
                    event = new Object[]{DeleteAtIndex, this.deleteAtIndexQuery, deleteAtIndexRow};
                    writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
                }
                continue;
            }
            if (indexesBefore == null || indexesBefore.isEmpty()) {
                Iterator itAfter = indexesAfter.iterator();
                while (itAfter.hasNext()) {
                    AbstractRecord insertRow = writeQuery.getTranslationRow().clone();
                    insertRow.add(this.getDirectField(), value);
                    insertRow.add(this.listOrderField, itAfter.next());
                    event = new Object[]{Insert, this.getInsertQuery(), insertRow};
                    writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
                }
                continue;
            }
            itBefore = indexesBefore.iterator();
            Iterator itAfter = indexesAfter.iterator();
            while (itBefore.hasNext() || itAfter.hasNext()) {
                Object[] event3;
                if (itBefore.hasNext()) {
                    if (itAfter.hasNext()) {
                        AbstractRecord updateAtIndexRow = writeQuery.getTranslationRow().clone();
                        updateAtIndexRow.add(this.getDirectField(), value);
                        updateAtIndexRow.add(this.listOrderField, itBefore.next());
                        event3 = new Object[4];
                        event3[0] = UpdateAtIndex;
                        event3[1] = this.updateAtIndexQuery;
                        event3[2] = updateAtIndexRow;
                        DatabaseRecord modifyRow = new DatabaseRecord(1);
                        modifyRow.add(this.listOrderField, itAfter.next());
                        event3[3] = modifyRow;
                        writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event3);
                        continue;
                    }
                    AbstractRecord deleteAtIndexRow = writeQuery.getTranslationRow().clone();
                    deleteAtIndexRow.add(this.getDirectField(), value);
                    deleteAtIndexRow.add(this.listOrderField, itBefore.next());
                    event3 = new Object[]{DeleteAtIndex, this.deleteAtIndexQuery, deleteAtIndexRow};
                    writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event3);
                    continue;
                }
                AbstractRecord insertRow = writeQuery.getTranslationRow().clone();
                insertRow.add(this.getDirectField(), value);
                insertRow.add(this.listOrderField, itAfter.next());
                event3 = new Object[]{Insert, this.getInsertQuery(), insertRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event3);
            }
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        if (!this.isCascadeOnDeleteSetOnDatabase) {
            this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
            query.getSession().executeQuery((DatabaseQuery)this.deleteAllQuery, query.getTranslationRow());
        }
        if (this.historyPolicy != null && this.historyPolicy.shouldHandleWrites()) {
            if (this.isCascadeOnDeleteSetOnDatabase) {
                this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
            }
            this.historyPolicy.mappingLogicalDelete(this.deleteAllQuery, query.getTranslationRow(), query.getSession());
        }
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, ClassDescriptor descriptor, AbstractSession session) {
        Enumeration<DatabaseField> sourceFieldsEnum = this.getSourceKeyFields().elements();
        while (sourceFieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = sourceFieldsEnum.nextElement();
            if (translationRow.containsKey(sourceKey)) continue;
            Object value = descriptor.getObjectBuilder().extractValueFromObjectForField(object, sourceKey, session);
            translationRow.put(sourceKey, value);
        }
    }

    protected void initOrRebuildSelectQuery() {
        this.selectionQuery.setSQLStatement(new SQLSelectStatement());
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow) {
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        if (!this.isRemotelyInitialized()) {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
            this.remotelyInitialized();
        }
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return null;
    }

    public void setAttributeClassification(Class attributeClassification) {
        this.attributeClassification = attributeClassification;
    }

    public void setAttributeClassificationName(String attributeClassificationName) {
        this.attributeClassificationName = attributeClassificationName;
    }

    protected void setDeleteQuery(ModifyQuery query) {
        this.changeSetDeleteQuery = query;
    }

    public void setDeleteSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteQuery(query);
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        if (this.selectionQuery.isDataReadQuery()) {
            ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
        }
    }

    public void setCustomDeleteQuery(ModifyQuery query) {
        this.setDeleteQuery(query);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomDeleteAtIndexQuery(ModifyQuery query) {
        this.deleteAtIndexQuery = query;
        this.hasCustomDeleteAtIndexQuery = true;
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.setInsertQuery(query);
        this.setHasCustomInsertQuery(true);
    }

    public void setCustomUpdateAtIndexQuery(ModifyQuery query) {
        this.updateAtIndexQuery = query;
        this.hasCustomUpdateAtIndexQuery = true;
    }

    public void setDirectField(DatabaseField field) {
        this.directField = field;
    }

    public void setDirectFieldClassification(Class fieldType) {
        this.getDirectField().setType(fieldType);
    }

    public void setDirectFieldClassificationName(String className) {
        this.getDirectField().setTypeName(className);
    }

    public void setDirectFieldName(String fieldName) {
        this.setDirectField(new DatabaseField(fieldName));
    }

    protected void setHasCustomDeleteQuery(boolean bool) {
        this.hasCustomDeleteQuery = bool;
    }

    protected void setHasCustomInsertQuery(boolean bool) {
        this.hasCustomInsertQuery = bool;
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.insertQuery = insertQuery;
    }

    public void setInsertSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomInsertQuery(query);
    }

    @Override
    public void setReferenceClass(Class referenceClass) {
    }

    @Override
    public void setReferenceClassName(String referenceClassName) {
    }

    public void setReferenceKeyFieldName(String fieldName) {
        this.getReferenceKeyFields().addElement(new DatabaseField(fieldName));
    }

    public void setReferenceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setReferenceKeyFields(fields);
    }

    public void setReferenceKeyFields(Vector<DatabaseField> aVector) {
        this.referenceKeyFields = aVector;
    }

    public void setReferenceTable(DatabaseTable table) {
        this.referenceTable = table;
    }

    @Override
    public void setSelectionCriteria(Expression anExpression) {
        if (this.getSelectionQuery().isReadAllQuery()) {
            ((ReadAllQuery)this.getSelectionQuery()).setSelectionCriteria(anExpression);
        } else {
            this.getSelectionQuery().getSQLStatement().setWhereClause(anExpression);
        }
    }

    public void setReferenceTableName(String tableName) {
        if (tableName == null) {
            this.setReferenceTable(null);
        } else {
            this.setReferenceTable(new DatabaseTable(tableName));
        }
    }

    @Override
    protected void setSelectionQueryContainerPolicy(ContainerPolicy containerPolicy) {
        ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setHistoryPolicy(HistoryPolicy policy) {
        this.historyPolicy = policy;
        if (policy != null) {
            policy.setMapping(this);
        }
    }

    @Override
    public void setSessionName(String name) {
        super.setSessionName(name);
        this.getInsertQuery().setSessionName(name);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    @Override
    public void collectQueryParameters(Set<DatabaseField> cacheFields) {
        for (DatabaseField field : this.getSourceKeyFields()) {
            cacheFields.add(field);
        }
    }

    @Override
    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        DirectCollectionChangeRecord collectionRecord = (DirectCollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object objectToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        this.simpleAddToCollectionChangeRecord(objectToAdd, null, false, changeSet, session, true);
    }

    protected void simpleAddToCollectionChangeRecord(Object objectToAdd, Integer index, boolean isSet, ObjectChangeSet changeSet, AbstractSession session, boolean isChangeApplied) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(changeSet.getUnitOfWorkClone(), session);
            if (this.listOrderField != null) {
                ArrayList originalListCopy = new ArrayList((List)collection);
                if (index == null) {
                    originalListCopy.remove(originalListCopy.size() - 1);
                } else {
                    originalListCopy.remove(index);
                }
                collectionChangeRecord.setOriginalCollection(originalListCopy);
                collectionChangeRecord.setLatestCollection(collection);
            } else {
                collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), session);
                collectionChangeRecord.setFirstToAddAlreadyInCollection(isChangeApplied);
            }
        }
        if (!collectionChangeRecord.isDeferred() && this.listOrderField == null) {
            collectionChangeRecord.addAdditionChange(objectToAdd, 1);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object objectToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        this.simpleRemoveFromCollectionChangeRecord(objectToRemove, null, false, changeSet, session, true);
    }

    protected void simpleRemoveFromCollectionChangeRecord(Object objectToRemove, Integer index, boolean isSet, ObjectChangeSet changeSet, AbstractSession session, boolean isChangeApplied) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(changeSet.getUnitOfWorkClone(), session);
            if (this.listOrderField != null) {
                ArrayList<Object> originalListCopy = new ArrayList<Object>((List)collection);
                if (isSet) {
                    originalListCopy.set(index, objectToRemove);
                } else {
                    originalListCopy.add(index, objectToRemove);
                }
                collectionChangeRecord.setOriginalCollection(originalListCopy);
                collectionChangeRecord.setLatestCollection(collection);
            } else {
                collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), session);
                collectionChangeRecord.setFirstToRemoveAlreadyOutCollection(isChangeApplied);
                if (isSet) {
                    collectionChangeRecord.setFirstToAddAlreadyInCollection(isChangeApplied);
                }
            }
        }
        if (!collectionChangeRecord.isDeferred() && this.listOrderField == null) {
            collectionChangeRecord.addRemoveChange(objectToRemove, 1);
        }
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.recreateOriginalCollection(oldValue, uow);
        }
        collectionChangeRecord.setLatestCollection(newValue);
    }

    @Override
    public void updateCollectionChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, UnitOfWorkImpl uow) {
        if (event != null) {
            Object value = event.getNewValue();
            if (event.getChangeType() == CollectionChangeEvent.ADD) {
                this.simpleAddToCollectionChangeRecord(value, event.getIndex(), event.isSet(), changeSet, uow, event.isChangeApplied());
            } else if (event.getChangeType() == CollectionChangeEvent.REMOVE) {
                this.simpleRemoveFromCollectionChangeRecord(value, event.getIndex(), event.isSet(), changeSet, uow, event.isChangeApplied());
            } else {
                throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
            }
        }
    }

    @Override
    public void useMapClass(Class concreteClass, String methodName) {
        throw ValidationException.illegalUseOfMapInDirectCollection(this, concreteClass, methodName);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession session, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        boolean extendingPessimisticLockScope;
        if (this.descriptor.isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object result = null;
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    return this.getAttributeValueFromObject(cached);
                }
                return result;
            }
            if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return this.indirectionPolicy.buildIndirectObject(new ValueHolder(null));
            }
        }
        if (sourceQuery.isObjectLevelReadQuery() && (((ObjectLevelReadQuery)sourceQuery).isAttributeBatchRead(this.descriptor, this.getAttributeName()) || sourceQuery.isReadAllQuery() && this.shouldUseBatchReading())) {
            return this.batchedValueFromRow(row, (ObjectLevelReadQuery)sourceQuery, cacheKey);
        }
        if (this.shouldUseValueFromRowWithJoin(joinManager, sourceQuery)) {
            return this.valueFromRowInternalWithJoin(row, joinManager, sourceQuery, cacheKey, session, isTargetProtected);
        }
        ReadQuery targetQuery = this.getSelectionQuery();
        boolean bl = extendingPessimisticLockScope = this.isExtendingPessimisticLockScope(sourceQuery) && this.extendPessimisticLockScope == ForeignReferenceMapping.ExtendPessimisticLockScope.TARGET_QUERY;
        if (this.getHistoryPolicy() != null || sourceQuery.getSession().getAsOfClause() != null || sourceQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)sourceQuery).hasAsOfClause() && (sourceQuery.shouldCascadeAllParts() || sourceQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || sourceQuery.shouldCascadeByMapping() && this.cascadeRefresh) || extendingPessimisticLockScope) {
            targetQuery = (ReadQuery)targetQuery.clone();
            SQLSelectStatement statement = new SQLSelectStatement();
            statement.addTable(this.getReferenceTable());
            statement.addField(this.getDirectField().clone());
            if (this.isDirectMapMapping()) {
                statement.addField(((DirectMapMapping)this).getDirectKeyField().clone());
            }
            statement.setWhereClause((Expression)this.getSelectionCriteria().clone());
            if (sourceQuery.isObjectLevelReadQuery()) {
                statement.getBuilder().asOf(((ObjectLevelReadQuery)sourceQuery).getAsOfClause());
            }
            if (extendingPessimisticLockScope) {
                statement.setLockingClause(new ForUpdateClause(sourceQuery.getLockMode()));
            }
            if (this.getHistoryPolicy() != null) {
                ExpressionBuilder builder = statement.getBuilder();
                if (sourceQuery.getSession().getAsOfClause() != null) {
                    builder.asOf(sourceQuery.getSession().getAsOfClause());
                } else if (builder.getAsOfClause() == null) {
                    builder.asOf(AsOfClause.NO_CLAUSE);
                }
                Expression temporalExpression = this.getHistoryPolicy().additionalHistoryExpression(builder);
                statement.setWhereClause(statement.getWhereClause().and(temporalExpression));
                if (builder.hasAsOfClause()) {
                    statement.getTables().set(0, this.getHistoryPolicy().getHistoricalTables().elementAt(0));
                }
            }
            statement.normalize(sourceQuery.getSession(), null);
            targetQuery.setSQLStatement(statement);
        }
        return this.getIndirectionPolicy().valueFromQuery(targetQuery, row, sourceQuery.getSession());
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    @Override
    public boolean isCandidateForPrivateOwnedRemoval() {
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }
}

