/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class StoredFunctionDefinition
extends StoredProcedureDefinition {
    public StoredFunctionDefinition() {
        this.addOutputArgument(new FieldDefinition());
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(session.getPlatform()));
        }
        super.buildCreationWriter(session, writer);
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(session.getPlatform()));
        }
        super.buildDeletionWriter(session, writer);
        return writer;
    }

    public String getCreationHeader() {
        return "CREATE FUNCTION ";
    }

    public String getDeletionHeader() {
        return "DROP FUNCTION ";
    }

    public int getFirstArgumentIndex() {
        return 1;
    }

    public void setReturnType(Class type2) {
        FieldDefinition argument = (FieldDefinition)this.getArguments().firstElement();
        argument.setType(type2);
    }

    protected void printReturn(Writer writer, AbstractSession session) throws ValidationException {
        try {
            session.getPlatform().printStoredFunctionReturnKeyWord(writer);
            FieldDefinition argument = (FieldDefinition)this.getArguments().firstElement();
            this.printArgument(argument, writer, session);
            writer.write("\n");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }
}

