/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.logging.LogDomains;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.j2ee.AppClientModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.EJBModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.EntityBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.J2EEApplicationImpl;
import org.glassfish.admin.amx.impl.j2ee.J2EEManagedObjectImplBase;
import org.glassfish.admin.amx.impl.j2ee.JCAResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JDBCResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JMSResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JNDIResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JTAResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JavaMailResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.MessageDrivenBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.Metadata;
import org.glassfish.admin.amx.impl.j2ee.MetadataImpl;
import org.glassfish.admin.amx.impl.j2ee.RMI_IIOPResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.ResourceAdapterImpl;
import org.glassfish.admin.amx.impl.j2ee.ResourceAdapterModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.ServletImpl;
import org.glassfish.admin.amx.impl.j2ee.SingletonSessionBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.StatefulSessionBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.StatelessSessionBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.URLResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.WebModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.loader.J2EEInjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.intf.config.AMXConfigGetters;
import org.glassfish.admin.amx.intf.config.Application;
import org.glassfish.admin.amx.intf.config.ApplicationRef;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.Module;
import org.glassfish.admin.amx.intf.config.Resource;
import org.glassfish.admin.amx.intf.config.ResourceRef;
import org.glassfish.admin.amx.intf.config.Server;
import org.glassfish.admin.amx.j2ee.AppClientModule;
import org.glassfish.admin.amx.j2ee.EJBModule;
import org.glassfish.admin.amx.j2ee.EntityBean;
import org.glassfish.admin.amx.j2ee.J2EEApplication;
import org.glassfish.admin.amx.j2ee.J2EEManagedObject;
import org.glassfish.admin.amx.j2ee.J2EEServer;
import org.glassfish.admin.amx.j2ee.MessageDrivenBean;
import org.glassfish.admin.amx.j2ee.ResourceAdapter;
import org.glassfish.admin.amx.j2ee.ResourceAdapterModule;
import org.glassfish.admin.amx.j2ee.Servlet;
import org.glassfish.admin.amx.j2ee.SingletonSessionBean;
import org.glassfish.admin.amx.j2ee.StatefulSessionBean;
import org.glassfish.admin.amx.j2ee.StatelessSessionBean;
import org.glassfish.admin.amx.j2ee.WebModule;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegistrationSupport {
    private final Map<ObjectName, ObjectName> mConfigRefTo77 = new HashMap<ObjectName, ObjectName>();
    private final J2EEServer mJ2EEServer;
    private final MBeanServer mMBeanServer;
    private final ProxyFactory mProxyFactory;
    private final RefListener mResourceRefListener;
    private final Server mServerConfig;
    private final String mResourceRefType;
    private final String mApplicationRefType;
    private final Logger mLogger = LogDomains.getLogger(RegistrationSupport.class, "javax.enterprise.system.amx");
    public static final Map<String, Class> CONFIG_RESOURCE_TYPES = MapUtil.toMap(new Object[]{"jdbc-resource", JDBCResourceImpl.class, "java-mail-resource", JavaMailResourceImpl.class, "jca-resource", JCAResourceImpl.class, "jms-resource", JMSResourceImpl.class, "jndi-resource", JNDIResourceImpl.class, "jta-resource", JTAResourceImpl.class, "rmi-iiop-resource", RMI_IIOPResourceImpl.class, "url-resource", URLResourceImpl.class}, String.class, Class.class);

    private static void cdebug(Object o) {
        System.out.println("" + o);
    }

    public RegistrationSupport(J2EEServer server) {
        this.mJ2EEServer = server;
        this.mMBeanServer = (MBeanServer)server.extra().mbeanServerConnection();
        this.mProxyFactory = server.extra().proxyFactory();
        this.mResourceRefType = Util.deduceType(ResourceRef.class);
        this.mApplicationRefType = Util.deduceType(ApplicationRef.class);
        this.mServerConfig = this.getDomainConfig().getServers().getServer().get(this.mJ2EEServer.getName());
        ObjectName test = this.mJ2EEServer.objectName();
        this.mResourceRefListener = new RefListener();
        this.registerApplications();
    }

    protected void cleanup() {
        this.mResourceRefListener.stopListening();
    }

    public void start() {
        this.mResourceRefListener.startListening();
    }

    private Domain getDomainConfig() {
        return new AMXConfigGetters(this.mJ2EEServer).domainConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeploymentDescriptor(BundleDescriptor bundleDesc) {
        ArchivistFactory archivistFactory = J2EEInjectedValues.getInstance().getArchivistFactory();
        String dd = "unavailable";
        ByteArrayOutputStream out = null;
        try {
            Archivist moduleArchivist = archivistFactory.getArchivist(bundleDesc.getModuleDescriptor().getModuleType());
            DeploymentDescriptorFile<BundleDescriptor> ddFile = moduleArchivist.getStandardDDFile();
            out = new ByteArrayOutputStream();
            ddFile.write(bundleDesc, out);
            String charsetName = "UTF-8";
            dd = out.toString("UTF-8");
        }
        catch (Exception e) {
            dd = null;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ee) {}
            }
        }
        return dd;
    }

    private ObjectName createAppMBeans(Application appConfig, com.sun.enterprise.deployment.Application application, MetadataImpl meta) {
        ObjectName objectName;
        String appLocation = appConfig.getLocation();
        boolean isStandalone = application.isVirtual();
        ObjectName parentMBean = null;
        ObjectName top = null;
        if (isStandalone) {
            parentMBean = this.mJ2EEServer.objectName();
        } else {
            String xmlDesc = this.getDeploymentDescriptor(application);
            if (xmlDesc != null) {
                meta.setDeploymentDescriptor(xmlDesc);
            }
            top = parentMBean = this.registerJ2EEChild(this.mJ2EEServer.objectName(), meta, J2EEApplication.class, J2EEApplicationImpl.class, application.getName());
        }
        for (EjbBundleDescriptor ejbBundleDescriptor : application.getEjbBundleDescriptors()) {
            objectName = this.registerEjbModuleAndItsComponents(parentMBean, meta, appConfig, ejbBundleDescriptor);
            if (!isStandalone) continue;
            assert (top == null);
            top = objectName;
        }
        for (WebBundleDescriptor webBundleDescriptor : application.getWebBundleDescriptors()) {
            objectName = this.registerWebModuleAndItsComponents(parentMBean, meta, appConfig, webBundleDescriptor);
            if (!isStandalone) continue;
            assert (top == null);
            top = objectName;
        }
        for (ConnectorDescriptor connectorDescriptor : application.getRarDescriptors()) {
            assert (top == null);
            top = this.registerResourceAdapterModuleAndItsComponents(parentMBean, meta, appConfig, connectorDescriptor, appLocation);
        }
        for (ApplicationClientDescriptor applicationClientDescriptor : application.getApplicationClientDescriptors()) {
            assert (top == null);
            top = this.registerAppClient(parentMBean, meta, appConfig, applicationClientDescriptor);
        }
        this.mLogger.fine("Registered JSR 77 MBeans for application/module: " + top);
        return top;
    }

    private Module getModuleConfig(Application appConfig, String name) {
        Map<String, Module> modules = appConfig.childrenMap(Module.class);
        if (modules.get(name) == null) {
            throw new IllegalArgumentException("Can't find module named " + name + " in " + appConfig);
        }
        return modules.get(name);
    }

    private ObjectName registerEjbModuleAndItsComponents(ObjectName parentMBean, MetadataImpl meta, Application appConfig, EjbBundleDescriptor ejbBundleDescriptor) {
        String xmlDesc = this.getDeploymentDescriptor(ejbBundleDescriptor);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String moduleName = ejbBundleDescriptor.getModuleName();
        String appLocation = appConfig.getLocation();
        Module moduleConfig = this.getModuleConfig(appConfig, moduleName);
        meta.setCorrespondingConfig(moduleConfig.objectName());
        ObjectName ejbModuleObjectName = this.registerJ2EEChild(parentMBean, meta, EJBModule.class, EJBModuleImpl.class, moduleName);
        meta.remove("Config");
        meta.remove("DeploymentDescriptor");
        for (EjbDescriptor desc : ejbBundleDescriptor.getEjbs()) {
            ObjectName ejbObjectName = this.createEJBMBean(ejbModuleObjectName, meta, desc);
        }
        return ejbModuleObjectName;
    }

    private ObjectName createEJBMBean(ObjectName parentMBean, MetadataImpl meta, EjbDescriptor ejbDescriptor) {
        String ejbName = ejbDescriptor.getName();
        String ejbType = ejbDescriptor.getType();
        String ejbSessionType = ejbType.equals("Session") ? ((EjbSessionDescriptor)ejbDescriptor).getSessionType() : null;
        Class intf = null;
        Class impl = null;
        if (ejbType.equals("Entity")) {
            intf = EntityBean.class;
            impl = EntityBeanImpl.class;
        } else if (ejbType.equals("Message-driven")) {
            intf = MessageDrivenBean.class;
            impl = MessageDrivenBeanImpl.class;
        } else if (ejbType.equals("Session")) {
            if (ejbSessionType.equals("Stateless")) {
                intf = StatelessSessionBean.class;
                impl = StatelessSessionBeanImpl.class;
            } else if (ejbSessionType.equals("Stateful")) {
                intf = StatefulSessionBean.class;
                impl = StatefulSessionBeanImpl.class;
            } else if (ejbSessionType.equals("Singleton")) {
                intf = SingletonSessionBean.class;
                impl = SingletonSessionBeanImpl.class;
            } else {
                throw new IllegalArgumentException("Unknown ejbSessionType: " + ejbSessionType + ", expected Stateless or Stateful");
            }
        }
        return this.registerJ2EEChild(parentMBean, meta, intf, impl, ejbName);
    }

    private ObjectName registerWebModuleAndItsComponents(ObjectName parentMBean, MetadataImpl meta, Application appConfig, WebBundleDescriptor webBundleDescriptor) {
        String xmlDesc = this.getDeploymentDescriptor(webBundleDescriptor);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String moduleName = webBundleDescriptor.getModuleName();
        String appLocation = appConfig.getLocation();
        Module moduleConfig = this.getModuleConfig(appConfig, moduleName);
        meta.setCorrespondingConfig(moduleConfig.objectName());
        ObjectName webModuleObjectName = this.registerJ2EEChild(parentMBean, meta, WebModule.class, WebModuleImpl.class, moduleName);
        meta.remove("Config");
        meta.remove("DeploymentDescriptor");
        for (WebComponentDescriptor desc : webBundleDescriptor.getWebComponentDescriptors()) {
            String servletName = desc.getCanonicalName();
            ObjectName on = this.registerJ2EEChild(webModuleObjectName, meta, Servlet.class, ServletImpl.class, servletName);
        }
        return webModuleObjectName;
    }

    public ObjectName registerResourceAdapterModuleAndItsComponents(ObjectName parentMBean, MetadataImpl meta, Application appConfig, ConnectorDescriptor bundleDesc, String appLocation) {
        meta.setCorrespondingConfig(appConfig.objectName());
        ObjectName objectName = this.createRARModuleMBean(parentMBean, meta, appConfig, bundleDesc);
        Module moduleConfig = this.getModuleConfig(appConfig, bundleDesc.getModuleName());
        meta.setCorrespondingConfig(moduleConfig.objectName());
        ObjectName rarObjectName = this.registerJ2EEChild(objectName, meta, ResourceAdapter.class, ResourceAdapterImpl.class, bundleDesc.getName());
        return objectName;
    }

    private ObjectName createRARModuleMBean(ObjectName parentMBean, MetadataImpl meta, Application appConfig, ConnectorDescriptor bundleDesc) {
        String appLocation = appConfig.getLocation();
        String xmlDesc = this.getDeploymentDescriptor(bundleDesc);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String resAdName = bundleDesc.getModuleName();
        ObjectName objectName = this.registerJ2EEChild(parentMBean, meta, ResourceAdapterModule.class, ResourceAdapterModuleImpl.class, resAdName);
        return objectName;
    }

    public ObjectName registerAppClient(ObjectName parentMBean, MetadataImpl meta, Application appConfig, ApplicationClientDescriptor bundleDesc) {
        String appLocation = appConfig.getLocation();
        String xmlDesc = this.getDeploymentDescriptor(bundleDesc);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String moduleName = bundleDesc.getModuleDescriptor().getModuleName();
        return this.registerJ2EEChild(parentMBean, meta, AppClientModule.class, AppClientModuleImpl.class, moduleName);
    }

    protected void registerApplications() {
        Map<String, ApplicationRef> appRefConfigs = this.mServerConfig.getApplicationRef();
        for (ApplicationRef ref : appRefConfigs.values()) {
            try {
                ObjectName objectName = this.processApplicationRef(ref);
            }
            catch (Exception e) {
                this.mLogger.log(Level.INFO, "amx.exception.app.register", new Object[]{ref.getName(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName processApplicationRef(ApplicationRef ref) {
        ApplicationRegistry appRegistry = J2EEInjectedValues.getInstance().getApplicationRegistry();
        MetadataImpl meta = new MetadataImpl();
        meta.setCorrespondingRef(ref.objectName());
        String appName = ref.getName();
        ApplicationInfo appInfo = appRegistry.get(appName);
        if (appInfo == null) {
            this.mLogger.fine("Unable to get ApplicationInfo for application: " + appName);
            return null;
        }
        com.sun.enterprise.deployment.Application app = appInfo.getMetaData(com.sun.enterprise.deployment.Application.class);
        if (app == null) {
            if (appInfo.isJavaEEApp()) {
                this.mLogger.log(Level.WARNING, "amx.null.appinfo", appName);
            }
            return null;
        }
        Application appConfig = new AMXConfigGetters(ref).getApplication(appName);
        if (appConfig == null) {
            this.mLogger.log(Level.WARNING, "amx.error.getappconfig", appName);
            return null;
        }
        meta.setCorrespondingConfig(appConfig.objectName());
        ObjectName mbean77 = this.createAppMBeans(appConfig, app, meta);
        Map<ObjectName, ObjectName> map = this.mConfigRefTo77;
        synchronized (map) {
            this.mConfigRefTo77.put(ref.objectName(), mbean77);
        }
        return mbean77;
    }

    protected <I extends J2EEManagedObject, C extends J2EEManagedObjectImplBase> ObjectName registerJ2EEChild(ObjectName parent, Metadata metadataIn, Class<I> intf, Class<C> clazz, String name) {
        ObjectName objectName = null;
        String j2eeType = Util.deduceType(intf);
        MetadataImpl metadata = new MetadataImpl(metadataIn);
        try {
            Constructor<C> c = clazz.getConstructor(ObjectName.class, Metadata.class);
            J2EEManagedObjectImplBase impl = (J2EEManagedObjectImplBase)c.newInstance(parent, metadata);
            objectName = new ObjectNameBuilder(this.mMBeanServer, parent).buildChildObjectName(j2eeType, name);
            objectName = this.mMBeanServer.registerMBean(impl, objectName).getObjectName();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register " + j2eeType + "=" + name + " as child of " + parent, e);
        }
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName processResourceRef(ResourceRef ref) {
        if (!this.mResourceRefType.equals(ref.type())) {
            throw new IllegalArgumentException("Not a resource-ref: " + ref.objectName());
        }
        if (!this.mServerConfig.objectName().equals(ref.parent().objectName())) {
            RegistrationSupport.cdebug("ResourceRef is not a child of server " + this.mServerConfig.objectName());
            return null;
        }
        Resource amxConfig = new AMXConfigGetters(ref).getResource(ref.getName());
        if (amxConfig == null) {
            throw new IllegalArgumentException("ResourceRef refers to non-existent resource: " + ref);
        }
        String configType = amxConfig.type();
        Class implClass = CONFIG_RESOURCE_TYPES.get(configType);
        if (implClass == null) {
            this.mLogger.fine("Unrecognized resource type for JSR 77 purposes: " + amxConfig.objectName());
            return null;
        }
        Class intf = (Class)ClassUtil.getFieldValue(implClass, "INTF");
        String j2eeType = Util.deduceType(intf);
        ObjectName mbean77 = null;
        try {
            MetadataImpl meta = new MetadataImpl();
            meta.setCorrespondingRef(ref.objectName());
            meta.setCorrespondingConfig(amxConfig.objectName());
            mbean77 = this.registerJ2EEChild(this.mJ2EEServer.objectName(), meta, intf, implClass, amxConfig.getName());
            Map<ObjectName, ObjectName> map = this.mConfigRefTo77;
            synchronized (map) {
                this.mConfigRefTo77.put(ref.objectName(), mbean77);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.INFO, "amx.exception.jsr77app.register", new Object[]{ref.objectName(), e});
        }
        return mbean77;
    }

    private final class RefListener
    implements NotificationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notifIn, Object handback) {
            if (!(notifIn instanceof MBeanServerNotification)) {
                return;
            }
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            if (!RegistrationSupport.this.mJ2EEServer.objectName().getDomain().equals(objectName.getDomain())) {
                return;
            }
            String type2 = Util.getTypeProp(objectName);
            if (notif.getType().equals("JMX.mbean.registered")) {
                if (type2.equals(RegistrationSupport.this.mResourceRefType)) {
                    RegistrationSupport.this.mLogger.fine("New ResourceRef MBEAN registered: " + objectName);
                    ResourceRef ref = RegistrationSupport.this.mProxyFactory.getProxy(objectName, ResourceRef.class);
                    RegistrationSupport.this.processResourceRef(ref);
                } else if (type2.equals(RegistrationSupport.this.mApplicationRefType)) {
                    RegistrationSupport.this.mLogger.fine("NEW ApplicationRef MBEAN registered: " + objectName);
                    ApplicationRef ref = RegistrationSupport.this.mProxyFactory.getProxy(objectName, ApplicationRef.class);
                    RegistrationSupport.this.processApplicationRef(ref);
                }
            } else if (notif.getType().equals("JMX.mbean.unregistered")) {
                Map map = RegistrationSupport.this.mConfigRefTo77;
                synchronized (map) {
                    ObjectName mbean77 = (ObjectName)RegistrationSupport.this.mConfigRefTo77.remove(objectName);
                    if (mbean77 != null) {
                        RegistrationSupport.this.mLogger.fine("Unregistering MBEAN for ref: " + objectName);
                        try {
                            RegistrationSupport.this.mMBeanServer.unregisterMBean(mbean77);
                        }
                        catch (Exception e) {
                            RegistrationSupport.this.mLogger.log(Level.WARNING, "amx.unregister.mbean", new Object[]{objectName, e});
                        }
                    }
                }
            }
        }

        public void startListening() {
            try {
                RegistrationSupport.this.mMBeanServer.addNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this, null, null);
            }
            catch (JMException e) {
                throw new RuntimeException(e);
            }
            Map<String, ResourceRef> resourceRefs = RegistrationSupport.this.mServerConfig.getResourceRef();
            for (ResourceRef ref : resourceRefs.values()) {
                RegistrationSupport.this.processResourceRef(ref);
            }
        }

        public void stopListening() {
            try {
                RegistrationSupport.this.mMBeanServer.removeNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this);
            }
            catch (JMException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

