/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee.loader;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.j2ee.DASJ2EEServerImpl;
import org.glassfish.admin.amx.impl.j2ee.J2EEDomainImpl;
import org.glassfish.admin.amx.impl.j2ee.MetadataImpl;
import org.glassfish.admin.amx.impl.j2ee.loader.AMXJ2EEStartupServiceMBean;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.j2ee.J2EEDomain;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public final class AMXJ2EEStartupService
implements PostConstruct,
PreDestroy,
AMXJ2EEStartupServiceMBean,
ConfigListener {
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    InjectedValues mCore;
    @Inject
    private com.sun.enterprise.config.serverbeans.Domain domain;
    private static final Logger logger = LogDomains.getLogger(AMXJ2EEStartupService.class, "javax.enterprise.system.amx");
    @Inject
    Habitat mHabitat;
    @Inject
    private ApplicationRegistry mAppsRegistry;

    private static void debug(String s) {
        System.out.println(s);
    }

    public InjectedValues getCore() {
        return this.mCore;
    }

    public ApplicationRegistry getApplicationRegistry() {
        return this.mAppsRegistry;
    }

    public void postConstruct() {
        try {
            this.mMBeanServer.registerMBean(this, OBJECT_NAME);
            this.addListenerToServer();
        }
        catch (JMException e) {
            throw new Error(e);
        }
    }

    private void addListenerToServer() {
        Servers servers = this.domain.getServers();
        ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(servers));
        bean.addListener(this);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        return ConfigSupport.sortAndDispatch(propertyChangeEvents, new PropertyChangeHandler(propertyChangeEvents), logger);
    }

    public void preDestroy() {
        this.unloadAMXMBeans();
    }

    private DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy();
    }

    public ObjectName getJ2EEDomain() {
        return this.getDomainRootProxy().child("J2EEDomain").extra().objectName();
    }

    private J2EEDomain getJ2EEDomainProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getProxy(this.getJ2EEDomain(), J2EEDomain.class);
    }

    public synchronized ObjectName loadAMXMBeans() {
        FeatureAvailability.getInstance().waitForFeature("AMXCoreReady", "" + this);
        FeatureAvailability.getInstance().waitForFeature("AMXConfigReady", "" + this);
        DomainRoot domainRootProxy = ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
        ObjectName domainRoot = domainRootProxy.objectName();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.mMBeanServer, domainRoot);
        String domainName = Util.getNameProp(domainRoot);
        MetadataImpl metadata = new MetadataImpl();
        metadata.add("Config", domainRootProxy.child(Domain.class).objectName());
        String serverName = this.mHabitat.getComponent(Server.class).getName();
        J2EEDomainImpl impl = new J2EEDomainImpl(domainRoot, metadata);
        impl.setServerName(serverName);
        ObjectName objectName = objectNames.buildChildObjectName(J2EEDomain.class);
        try {
            objectName = this.mMBeanServer.registerMBean(impl, objectName).getObjectName();
        }
        catch (JMException e) {
            throw new Error(e);
        }
        logger.log(Level.INFO, "amx.J2EEDomain.registered", objectName);
        return objectName;
    }

    public synchronized void unloadAMXMBeans() {
        J2EEDomain j2eeDomain = this.getJ2EEDomainProxy();
        if (j2eeDomain != null) {
            ImplUtil.unregisterAMXMBeans(j2eeDomain);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyChangeHandler
    implements Changed {
        private PropertyChangeHandler(PropertyChangeEvent[] events) {
        }

        @Override
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
            switch (type2) {
                case ADD: {
                    if (!(changedInstance instanceof Server)) break;
                    Server server = (Server)changedInstance;
                    String serverName = server.getName();
                    DomainRoot domainRootProxy = ProxyFactory.getInstance(AMXJ2EEStartupService.this.mMBeanServer).getDomainRootProxy(false);
                    MetadataImpl meta = new MetadataImpl();
                    meta.setCorrespondingConfig(domainRootProxy.getDomain().as(Domain.class).getServers().getServer().get(serverName).objectName());
                    DASJ2EEServerImpl impl = new DASJ2EEServerImpl(AMXJ2EEStartupService.this.getJ2EEDomain(), meta);
                    ObjectName serverObjectName = new ObjectNameBuilder(AMXJ2EEStartupService.this.mMBeanServer, AMXJ2EEStartupService.this.getJ2EEDomain()).buildChildObjectName("J2EEServer", serverName);
                    try {
                        AMXJ2EEStartupService.this.mMBeanServer.registerMBean(impl, serverObjectName).getObjectName();
                        break;
                    }
                    catch (JMException e) {
                        throw new Error(e);
                    }
                }
                case REMOVE: {
                    if (!(changedInstance instanceof Server)) break;
                    Server server = (Server)changedInstance;
                    String serverName = server.getName();
                    ObjectName serverObjectName = new ObjectNameBuilder(AMXJ2EEStartupService.this.mMBeanServer, AMXJ2EEStartupService.this.getJ2EEDomain()).buildChildObjectName("J2EEServer", serverName);
                    try {
                        Set<ObjectName> serverSet = AMXJ2EEStartupService.this.mMBeanServer.queryNames(new ObjectName(serverObjectName.toString() + ",*"), null);
                        for (ObjectName element : serverSet) {
                            AMXJ2EEStartupService.this.mMBeanServer.unregisterMBean(element);
                        }
                        break;
                    }
                    catch (JMException e) {
                        throw new Error(e);
                    }
                }
            }
            return null;
        }
    }
}

