/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.FutureStatsProviders;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.probe.provider.StatsProviderInfo;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.impl.client.AgentAttacher;
import org.glassfish.flashlight.provider.ProbeProviderEventListener;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class MonitoringBootstrap
implements Init,
PostConstruct,
PreDestroy,
EventListener,
ModuleLifecycleListener,
ConfigListener {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private ModulesRegistry registry;
    @Inject
    protected ProbeProviderFactory probeProviderFactory;
    @Inject
    protected ProbeClientMediator pcm;
    @Inject
    Events events;
    @Inject
    ServerEnvironment serverEnv;
    @Inject(optional=true)
    MonitoringService monitoringService = null;
    @Inject
    private ProbeRegistry probeRegistry;
    @Inject
    Habitat habitat;
    @Inject
    Transactions transactions;
    private Domain domain;
    Map<String, Module> map = Collections.synchronizedMap(new WeakHashMap());
    List<String> appList = Collections.synchronizedList(new ArrayList());
    private static final String INSTALL_ROOT_URI_PROPERTY_NAME = "com.sun.aas.installRootURI";
    private static final Logger logger = LogDomains.getLogger(MonitoringBootstrap.class, "javax.enterprise.system.tools.monitor");
    private final String PROBE_PROVIDER_CLASS_NAMES = "probe-provider-class-names";
    private final String PROBE_PROVIDER_XML_FILE_NAMES = "probe-provider-xml-file-names";
    private final String DELIMITER = ",";
    private StatsProviderManagerDelegateImpl spmd;
    private boolean monitoringEnabled;
    private boolean hasDiscoveredXMLProviders = false;

    public void postConstruct() {
        this.domain = this.habitat.getComponent(Domain.class);
        this.transactions.addListenerForType(ContainerMonitoring.class, this);
        this.transactions.addListenerForType(MonitoringService.class, this);
        this.transactions.addListenerForType(ModuleMonitoringLevels.class, this);
        this.monitoringEnabled = this.monitoringService != null ? Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled()) : false;
        if (!this.monitoringEnabled) {
            return;
        }
        this.events.register(this);
        boolean isDiscoverXMLProbeProviders = false;
        this.enableMonitoringForProbeProviders(isDiscoverXMLProbeProviders);
    }

    private void discoverProbeProviders() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "discoveringProbeProviders", new Object[]{"Discovering the ProbeProviders"});
        }
        for (Module m : this.registry.getModules()) {
            if (m.getState() != ModuleState.READY && m.getState() != ModuleState.RESOLVED) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" In (discoverProbeProviders) ModuleState - " + (Object)((Object)m.getState()) + " : " + m.getName());
            }
            this.verifyModule(m);
        }
    }

    public void preDestroy() {
        ProbeRegistry.cleanup();
        if (this.spmd != null) {
            this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.serverEnv.getInstanceName(), this.monitoringService);
            StatsProviderManager.setStatsProviderManagerDelegate(this.spmd);
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "discoveringXmlProbeProviders");
            }
            this.discoverXMLProviders();
        }
    }

    public void setStatsProviderManagerDelegate() {
        if (this.spmd != null) {
            return;
        }
        this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.serverEnv.getInstanceName(), this.monitoringService);
        StatsProviderManager.setStatsProviderManagerDelegate(this.spmd);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" StatsProviderManagerDelegate is assigned");
        }
        AMXGlassfish amxg = AMXGlassfish.DEFAULT;
        amxg.listenForDomainRoot(ManagementFactory.getPlatformMBeanServer(), this.spmd);
    }

    public void moduleResolved(Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    public synchronized void moduleStarted(Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    private synchronized void verifyModule(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (!this.map.containsKey(str)) {
            this.map.put(str, module);
            this.addProvider(module);
        }
    }

    public synchronized void registerProbes(String appName, File appDir, ClassLoader cl) {
        if (appName == null) {
            return;
        }
        if (cl == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Null classloader passed for application : " + appName);
            }
            return;
        }
        if (!this.appList.contains(appName)) {
            this.appList.add(appName);
            this.addProvider(appDir, cl);
        }
    }

    public synchronized void moduleStopped(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
    }

    public void moduleInstalled(Module module) {
    }

    public void moduleUpdated(Module module) {
    }

    private void addProvider(Module module) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Adding the Provider - verified the module");
        }
        String mname = module.getName();
        ClassLoader mcl = module.getClassLoader();
        ModuleDefinition md = module.getModuleDefinition();
        Manifest mf = null;
        if (md != null) {
            mf = md.getManifest();
        }
        if (mf != null) {
            this.processManifest(mf, mcl);
        }
        this.handleFutureStatsProviders();
    }

    private void addProvider(File appDir, ClassLoader classLoader) {
        File manifestFile = new File(appDir, "META-INF" + File.separator + "MANIFEST.MF");
        String appDirPath = "";
        Manifest mf = null;
        if (manifestFile != null) {
            try {
                appDirPath = appDir.getCanonicalPath();
                FileInputStream fis = new FileInputStream(manifestFile);
                mf = new Manifest(fis);
            }
            catch (IOException ex) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Can't access META-INF" + File.separator + "MANIFEST.MF" + " for " + appDirPath);
                    logger.fine(ex.getLocalizedMessage());
                }
                return;
            }
            if (mf != null) {
                this.processManifest(mf, classLoader);
            }
        }
        this.handleFutureStatsProviders();
    }

    private void processManifest(Manifest mf, ClassLoader mcl) {
        if (mf != null) {
            Attributes attrs = mf.getMainAttributes();
            String cnames = null;
            String xnames = null;
            if (attrs != null) {
                StringTokenizer st;
                cnames = attrs.getValue("probe-provider-class-names");
                if (cnames != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("probe providers = " + cnames);
                    }
                    st = new StringTokenizer(cnames, ",");
                    while (st.hasMoreTokens()) {
                        try {
                            String clStr = st.nextToken();
                            if (clStr != null) {
                                clStr = clStr.trim();
                            }
                            if (mcl == null) continue;
                            this.processProbeProviderClass(mcl.loadClass(clStr));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "unableToLoadProbeProvider", e);
                        }
                    }
                }
                if ((xnames = attrs.getValue("probe-provider-xml-file-names")) != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("xnames = " + xnames);
                    }
                    st = new StringTokenizer(xnames, ",");
                    while (st.hasMoreTokens()) {
                        this.processProbeProviderXML(mcl, st.nextToken(), true);
                    }
                }
            }
        }
    }

    public void handleFutureStatsProviders() {
        if (FutureStatsProviders.isEmpty()) {
            return;
        }
        ArrayList<StatsProviderInfo> removeList = new ArrayList<StatsProviderInfo>();
        Iterator<StatsProviderInfo> it = FutureStatsProviders.iterator();
        while (it.hasNext()) {
            StatsProviderInfo spInfo = it.next();
            try {
                this.spmd.tryToRegister(spInfo);
                removeList.add(spInfo);
            }
            catch (RuntimeException re) {}
        }
        for (StatsProviderInfo spInfo : removeList) {
            FutureStatsProviders.remove(spInfo);
        }
    }

    private void discoverXMLProviders() {
        if (this.hasDiscoveredXMLProviders) {
            return;
        }
        try {
            URI xmlProviderDirStr = new URI(System.getProperty(INSTALL_ROOT_URI_PROPERTY_NAME) + "/" + "lib" + "/" + "monitor");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProviderXML's Dir = " + xmlProviderDirStr.getPath());
            }
            File xmlProviderDir = new File(xmlProviderDirStr.getPath());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProviderXML's Dir exists = " + xmlProviderDir.exists());
                logger.fine("ProviderXML's Dir path - " + xmlProviderDir.getAbsolutePath());
            }
            this.loadXMLProviders(xmlProviderDir);
            this.hasDiscoveredXMLProviders = true;
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "unableToProcessXMLProbeProvider", ex);
        }
    }

    private void loadXMLProviders(File xmlProvidersDir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = xmlProvidersDir.listFiles(filter);
        if (files == null) {
            return;
        }
        HashMap<String, File> providerMap = new HashMap<String, File>();
        for (File file : files) {
            Module module;
            int index;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found the provider xml - " + file.getAbsolutePath());
            }
            if ((index = file.getName().indexOf("-:")) == -1) continue;
            String moduleName = file.getName().substring(0, index);
            providerMap.put(moduleName, file);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" The provider xml belongs to - \"" + moduleName + "\"");
            }
            if (!this.map.containsKey(moduleName)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Module found (containsKey)");
            }
            if ((module = this.map.get(moduleName)) == null) {
                logger.log(Level.SEVERE, "monitoringMissingModuleFromXmlProbeProviders", new Object[]{moduleName});
                continue;
            }
            ClassLoader mcl = module.getClassLoader();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ModuleClassLoader = " + mcl);
                logger.fine("XML File path = " + file.getAbsolutePath());
            }
            this.processProbeProviderXML(mcl, file.getAbsolutePath(), false);
        }
    }

    private void removeProvider(Module module) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("removeProvider ...");
        }
    }

    private void processProbeProviderClass(Class cls) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("processProbeProviderClass for " + cls);
        }
        try {
            this.probeProviderFactory.getProbeProvider(cls);
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "unableToLoadProbeProvider", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "unableToLoadProbeProvider", ex);
        }
    }

    private void processProbeProviderXML(ClassLoader mcl, String xname, boolean inBundle) {
        this.probeProviderFactory.processXMLProbeProviders(mcl, xname, inBundle);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        StatsProviderRegistry spr;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" spmd = " + this.spmd);
        }
        StatsProviderRegistry statsProviderRegistry = spr = this.spmd == null ? null : this.spmd.getStatsProviderRegistry();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("spr = " + spr);
        }
        for (PropertyChangeEvent event : propertyChangeEvents) {
            boolean oldEnabled;
            if (event == null) continue;
            String propName = event.getPropertyName();
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (newVal == null || newVal.equals(oldVal) || !this.ok(propName)) continue;
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                String oldEnabled2;
                String newEnabled = newVal.toString().toUpperCase();
                String string = oldEnabled2 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "levelChangeEventReceived", new Object[]{propName, newEnabled, oldEnabled2});
                }
                if (newEnabled.equals(oldEnabled2) || spr == null) continue;
                this.handleLevelChange(propName, newEnabled);
                continue;
            }
            if (event.getSource() instanceof ContainerMonitoring) {
                String oldEnabled3;
                ContainerMonitoring cm = (ContainerMonitoring)event.getSource();
                String newEnabled = newVal.toString().toUpperCase();
                String string = oldEnabled3 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "levelChangeEventReceived", new Object[]{propName, newEnabled, oldEnabled3});
                }
                if (newEnabled.equals(oldEnabled3) || spr == null) continue;
                this.handleLevelChange(cm.getName(), newEnabled);
                continue;
            }
            if (!(event.getSource() instanceof MonitoringService)) continue;
            boolean newEnabled = Boolean.parseBoolean(newVal.toString());
            boolean bl = oldVal == null ? !newEnabled : (oldEnabled = Boolean.parseBoolean(oldVal.toString()));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "levelChangeEventReceived", new Object[]{propName, newEnabled, oldEnabled});
            }
            if (newEnabled == oldEnabled) continue;
            this.handleServiceChange(spr, propName, newEnabled);
        }
        return null;
    }

    private void handleLevelChange(String propName, String enabledStr) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In handleLevelChange(), spmd = " + this.spmd + "  Enabled=" + enabledStr);
        }
        if (!this.ok(propName)) {
            return;
        }
        if (this.spmd == null) {
            return;
        }
        if (this.parseLevelsBoolean(enabledStr)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "enableStatsMonitoring", new Object[]{propName, enabledStr});
            }
            try {
                this.spmd.enableStatsProviders(propName);
            }
            catch (RuntimeException rte) {
                logger.log(Level.INFO, rte.getMessage());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "", rte);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "disableStatsMonitoring", propName);
            }
            this.spmd.disableStatsProviders(propName);
        }
    }

    private void handleServiceChange(StatsProviderRegistry spr, String propName, boolean enabled) {
        if (!this.ok(propName)) {
            return;
        }
        if (propName.equals("mbean-enabled")) {
            if (spr == null) {
                return;
            }
            if (enabled) {
                logger.log(Level.INFO, "mbeanEnabled");
                this.spmd.registerAllGmbal();
            } else {
                logger.log(Level.INFO, "mbeanDisabled");
                this.spmd.unregisterAllGmbal();
            }
        } else if (propName.equals("dtrace-enabled")) {
            logger.log(Level.INFO, "dtraceEnabled");
            this.probeProviderFactory.dtraceEnabledChanged(enabled);
        } else if (propName.equals("monitoring-enabled")) {
            this.probeProviderFactory.monitoringEnabledChanged(enabled);
            if (enabled) {
                logger.log(Level.INFO, "monitoringEnabled");
                AgentAttacher.attachAgent();
                this.enableMonitoringForProbeProviders(true);
                this.spmd.updateAllStatsProviders();
            } else {
                logger.log(Level.INFO, "monitoringDisabled");
                this.disableMonitoringForProbeProviders();
                this.spmd.disableAllStatsProviders();
            }
        }
    }

    private void enableMonitoringForProbeProviders(boolean isDiscoverXMLProviders) {
        this.discoverProbeProviders();
        this.registry.register(this);
        if (isDiscoverXMLProviders) {
            this.discoverXMLProviders();
        }
        this.setStatsProviderManagerDelegate();
        this.probeProviderFactory.addProbeProviderEventListener(new ProcessProbes());
    }

    private void disableMonitoringForProbeProviders() {
        this.registry.unregister(this);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean parseLevelsBoolean(String s) {
        return !this.ok(s) || !s.equals("OFF");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessProbes
    implements ProbeProviderEventListener {
        private ProcessProbes() {
        }

        @Override
        public <T> void probeProviderAdded(String moduleProviderName, String moduleName, String probeProviderName, String invokerId, Class<T> providerClazz, T provider) {
            MonitoringBootstrap.this.handleFutureStatsProviders();
        }
    }
}

