/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="operating-system-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Operating System Statistics")
public class JVMOSStatsProvider {
    private OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private StringStatisticImpl arch = new StringStatisticImpl("Architecture", "String", "Operating system architecture");
    private CountStatisticImpl availableProcessors = new CountStatisticImpl("AvailableProcessors", "count", "Number of processors available to the Java virtual machine");
    private StringStatisticImpl osName = new StringStatisticImpl("Name", "String", "Operating system name");
    private StringStatisticImpl osVersion = new StringStatisticImpl("Version", "String", "operating system version");

    @ManagedAttribute(id="arch-current")
    @Description(value="operating system architecture")
    public StringStatistic getArch() {
        this.arch.setCurrent(this.osBean.getArch());
        return this.arch;
    }

    @ManagedAttribute(id="availableprocessors-count")
    @Description(value="number of processors available to the Java virtual machine")
    public CountStatistic getAvailableProcessors() {
        this.availableProcessors.setCount(this.osBean.getAvailableProcessors());
        return this.availableProcessors;
    }

    @ManagedAttribute(id="name-current")
    @Description(value="operating system name")
    public StringStatistic getOSName() {
        this.osName.setCurrent(this.osBean.getName());
        return this.osName;
    }

    @ManagedAttribute(id="version-current")
    @Description(value="operating system version")
    public StringStatistic getOSVersion() {
        this.osVersion.setCurrent(this.osBean.getVersion());
        return this.osVersion;
    }
}

