/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.util;

import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.IOException;

public class HostVerifier
implements ServerHostKeyVerifier {
    private KnownHosts knownHosts;

    public HostVerifier(KnownHosts knownHosts) {
        if (knownHosts == null) {
            throw new IllegalArgumentException("Known hosts database cannot be null");
        }
        this.knownHosts = knownHosts;
    }

    public boolean verifyServerHostKey(String hostName, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        int result = this.knownHosts.verifyHostkey(hostName, serverHostKeyAlgorithm, serverHostKey);
        switch (result) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                this.knownHosts.addHostkey(new String[]{hostName}, serverHostKeyAlgorithm, serverHostKey);
                return true;
            }
        }
        throw new IllegalStateException("Cannot verify server key");
    }
}

