/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-javamail-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.javamail.resource")
public class DeleteJavaMailResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJavaMailResource.class);
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private ResourceUtil resourceUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isResourceExists(this.domain.getResources(), this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.mail.resource.notfound", "A Mail resource named {0} does not exist.", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.environment.isDas()) {
            if ("domain".equals(this.target)) {
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 0) {
                    report.setMessage(localStrings.getLocalString("delete.mail.resource.resource-ref.exist", "mail-resource [ {0} ] is referenced in aninstance/cluster target, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(this.jndiName, this.target)) {
                    report.setMessage(localStrings.getLocalString("delete.mail.resource.no.resource-ref", "mail-resource [ {0} ] is not referenced in target [ {1} ]", this.jndiName, this.target));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 1) {
                    report.setMessage(localStrings.getLocalString("delete.mail.resource.multiple.resource-refs", "mail-resource [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        try {
            this.resourceUtil.deleteResourceRef(this.jndiName, this.target);
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    MailResource resource = (MailResource)DeleteJavaMailResource.this.domain.getResources().getResourceByName(MailResource.class, DeleteJavaMailResource.this.jndiName);
                    return param.getResources().remove(resource);
                }
            }, this.domain.getResources());
            report.setMessage(localStrings.getLocalString("delete.mail.resource.success", "Mail resource {0} deleted", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.mail.resource.failed", "Unable to delete mail resource {0}", this.jndiName) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
        }
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        return resources.getResourceByName(MailResource.class, jndiName) != null;
    }
}

