/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi;

import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.glassfish.deployment.common.DeploymentUtils;

public class DeploymentFactoryInstaller {
    private static DeploymentFactoryInstaller dfInstaller = null;
    private final String J2EE_DEPLOYMENT_MANAGER_REPOSITORY = "lib" + File.separator + "deployment";
    private static final String J2EE_DEPLOYMENT_MANAGER = "J2EE-DeploymentFactory-Implementation-Class";
    private static final String J2EE_HOME = "com.sun.enterprise.home";
    private static final Logger sLogger = LogDomains.getLogger(DeploymentUtils.class, "javax.enterprise.system.tools.deployment");

    private DeploymentFactoryInstaller() {
    }

    public static DeploymentFactoryInstaller getInstaller() {
        if (dfInstaller == null) {
            dfInstaller = new DeploymentFactoryInstaller();
            dfInstaller.initialize();
        }
        return dfInstaller;
    }

    public File[] getListOfDeploymentFactoryFiles() {
        File repository = new File(System.getProperty("com.sun.aas.installRoot") + File.separator + this.J2EE_DEPLOYMENT_MANAGER_REPOSITORY);
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine("J2EE Deployment factory repository = " + repository.getAbsolutePath());
        }
        if (!repository.exists()) {
            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{"Cannot find any deployment manager"});
            return null;
        }
        return repository.listFiles();
    }

    public void addDeploymentFactory(File newDM) throws IOException {
        int number = 1;
        File repository = new File(System.getProperty(J2EE_HOME) + File.separator + this.J2EE_DEPLOYMENT_MANAGER_REPOSITORY);
        File to = new File(repository, newDM.getName());
        while (to.exists()) {
            to = new File(repository, newDM.getName() + number);
            ++number;
        }
        ArchivistUtils.copy(new BufferedInputStream(new FileInputStream(newDM)), new BufferedOutputStream(new FileOutputStream(to)));
        this.installDeploymentFactory(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installDeploymentFactory(File installedDM) throws IOException {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine("Installing Deployment factory = " + installedDM.getAbsolutePath());
        }
        ZipFile jarFile = null;
        Manifest m = null;
        try {
            jarFile = new JarFile(installedDM);
            m = ((JarFile)jarFile).getManifest();
        }
        finally {
            jarFile.close();
            jarFile = null;
        }
        String className = m.getMainAttributes().getValue(J2EE_DEPLOYMENT_MANAGER);
        URL[] urls = new URL[]{installedDM.toURI().toURL()};
        URLClassLoader urlClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        Class<?> factory = null;
        try {
            factory = urlClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{"Unable to load declared DeploymentManagerFactory"});
            throw new IllegalArgumentException(className + " is not present in the " + installedDM.getName());
        }
        Object df = null;
        try {
            df = factory.newInstance();
        }
        catch (Exception ie) {
            sLogger.log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{className});
            sLogger.log(Level.SEVERE, "Error occurred", ie);
            throw new IllegalArgumentException("Cannot install " + installedDM.getName());
        }
        if (!(df instanceof DeploymentFactory)) {
            throw new IllegalArgumentException("The " + className + " declared as a DeploymentFactory does implement the DeploymentFactory interface");
        }
        DeploymentFactoryManager.getInstance().registerDeploymentFactory(df);
    }

    protected void initialize() {
        File[] elligibleFiles = this.getListOfDeploymentFactoryFiles();
        if (elligibleFiles == null) {
            return;
        }
        for (int i = 0; i < elligibleFiles.length; ++i) {
            try {
                this.installDeploymentFactory(elligibleFiles[i]);
                continue;
            }
            catch (Exception ioe) {
                sLogger.log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{elligibleFiles[i].getName()});
                sLogger.log(Level.SEVERE, "Error occurred", ioe);
            }
        }
    }
}

