/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.internal.deployment.Verifier;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.tracing.TracingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand,
EventListener {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    @Inject
    Applications apps;
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;
    @Inject
    Events events;
    @Inject
    VersioningService versioningService;
    private File safeCopyOfApp = null;
    private File safeCopyOfDeploymentPlan = null;
    private File originalPathValue;
    private List<String> previousTargets = new ArrayList<String>();
    private Properties previousVirtualServers = new Properties();
    private Properties previousEnabledAttributes = new Properties();

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public void execute(AdminCommandContext context) {
        block122: {
            boolean isDirectoryDeployed;
            Properties undeployProps;
            ApplicationConfigInfo savedAppConfig;
            DeploymentContextImpl initialContext;
            ArchiveHandler archiveHandler;
            ExtendedDeploymentContext deploymentContext;
            File expansionDir;
            ReadableArchive archive;
            Logger logger;
            ActionReport report;
            DeploymentTracing tracing;
            DeploymentTracing timing;
            DeployCommandSupplementalInfo suppInfo;
            block118: {
                block108: {
                    block107: {
                        block106: {
                            this.events.register(this);
                            suppInfo = new DeployCommandSupplementalInfo();
                            context.getActionReport().setResultType(DeployCommandSupplementalInfo.class, suppInfo);
                            timing = new DeploymentTracing();
                            tracing = null;
                            if (System.getProperty("org.glassfish.deployment.trace") != null) {
                                tracing = new DeploymentTracing();
                            }
                            report = context.getActionReport();
                            logger = context.getLogger();
                            this.originalPathValue = this.path;
                            if (this.path.exists()) break block106;
                            report.setMessage(localStrings.getLocalString("fnf", "File not found", this.path.getAbsolutePath()));
                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                            this.events.unregister(this);
                            return;
                        }
                        if (this.path.canRead()) break block107;
                        report.setMessage(localStrings.getLocalString("fnr", "File {0} does not have read permission", this.path.getAbsolutePath()));
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        this.events.unregister(this);
                        return;
                    }
                    if (!this.snifferManager.hasNoSniffers()) break block108;
                    String msg = localStrings.getLocalString("nocontainer", "No container services registered, done...");
                    report.failure(logger, msg);
                    this.events.unregister(this);
                    return;
                }
                try {
                    archive = this.archiveFactory.openArchive(this.path, this);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.ARCHIVE_OPENED);
                    }
                }
                catch (IOException e) {
                    String msg = localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", this.path.getAbsolutePath());
                    if (this.logReportedErrors.booleanValue()) {
                        report.failure(logger, msg, e);
                    } else {
                        report.setMessage(msg + this.path.getAbsolutePath() + e.toString());
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    }
                    this.events.unregister(this);
                    return;
                }
                try {
                    expansionDir = null;
                    deploymentContext = null;
                    archiveHandler = this.deployment.getArchiveHandler(archive, this.type);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.ARCHIVE_HANDLER_OBTAINED);
                    }
                    if (archiveHandler != null) break block109;
                    report.failure(logger, localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", this.path.getName()));
                    Object var30_15 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", this.path.getAbsolutePath()), e2);
                    }
                    if (tracing != null) {
                        tracing.print(System.out);
                        TracingUtilities.dump("org.glassfish.javaee.core.deployment.DolProvider", System.out);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        report.setResultType(String.class, this.name);
                        report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", this.name));
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", this.name, timing.elapsed()));
                    } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        String errorMessage = report.getMessage();
                        Throwable cause = report.getFailureCause();
                        if (cause != null) {
                            String causeMessage = cause.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                errorMessage = errorMessage + " : " + cause.getMessage();
                            }
                            logger.log(Level.SEVERE, errorMessage, cause.getCause());
                        }
                        report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", errorMessage));
                        report.setFailureCause(null);
                        if (expansionDir != null) {
                            try {
                                FileArchive arch = DeploymentUtils.openAsFileArchive(expansionDir, this.archiveFactory);
                                arch.delete();
                            }
                            catch (IOException ex) {
                                String msg = localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", expansionDir.getAbsolutePath());
                                report.failure(logger, msg, ex);
                            }
                        }
                    }
                    if (deploymentContext != null) {
                        deploymentContext.postDeployClean(true);
                    }
                    Object var37_51 = null;
                    this.events.unregister(this);
                }
                catch (Throwable throwable) {
                    Object var37_55 = null;
                    this.events.unregister(this);
                    throw throwable;
                }
                {
                    block112: {
                        File reposDir;
                        boolean isRegistered;
                        String versionIdentifier;
                        block109: {
                            return;
                        }
                        initialContext = new DeploymentContextImpl(report, logger, archive, this, this.env);
                        if (tracing != null) {
                            initialContext.addModuleMetaData(tracing);
                            tracing.addMark(DeploymentTracing.Mark.INITIAL_CONTEXT_CREATED);
                        }
                        if (this.name == null) {
                            this.name = archiveHandler.getDefaultApplicationName(archive, initialContext);
                        } else {
                            DeploymentUtils.validateApplicationName(this.name);
                        }
                        if (tracing != null) {
                            tracing.addMark(DeploymentTracing.Mark.APPNAME_DETERMINED);
                        }
                        boolean isUntagged = VersioningUtils.isUntagged(this.name);
                        if (this.name != null && !isUntagged && this.type != null && this.type.equals("osgi")) {
                            ActionReport.MessagePart msgPart = context.getActionReport().getTopMessagePart();
                            msgPart.setChildrenType("WARNING");
                            ActionReport.MessagePart childPart = msgPart.addChild();
                            childPart.setMessage(VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.osgi.warning", "OSGi bundles will not use the GlassFish versioning, any version information embedded as part of the name option will be ignored"));
                            this.name = VersioningUtils.getUntaggedName(this.name);
                        }
                        if (isUntagged && (versionIdentifier = archiveHandler.getVersionIdentifier(archive)) != null && !versionIdentifier.isEmpty()) {
                            StringBuilder sb = new StringBuilder(this.name).append(":").append(versionIdentifier);
                            this.name = sb.toString();
                        }
                        this.isredeploy = (isRegistered = this.deployment.isRegistered(this.name)) && this.force != false;
                        this.deployment.validateDeploymentTarget(this.target, this.name, this.isredeploy);
                        if (tracing != null) {
                            tracing.addMark(DeploymentTracing.Mark.TARGET_VALIDATED);
                        }
                        ActionReport.MessagePart part = report.getTopMessagePart();
                        part.addProperty("name", this.name);
                        savedAppConfig = new ApplicationConfigInfo(this.apps.getModule(Application.class, this.name));
                        undeployProps = this.handleRedeploy(this.name, report);
                        if (this.enabled == null) {
                            this.enabled = Boolean.TRUE;
                        }
                        if (!this.keepreposdir.booleanValue() && (reposDir = new File(this.env.getApplicationRepositoryPath(), VersioningUtils.getRepositoryName(this.name))).exists()) {
                            FileArchive arch = DeploymentUtils.openAsFileArchive(reposDir, this.archiveFactory);
                            arch.delete();
                        }
                        if (DeploymentUtils.isDomainTarget(this.target) || !this.enabled.booleanValue()) break block112;
                        try {
                            this.versioningService.handleDisable(this.name, this.target, report);
                        }
                        catch (VersioningSyntaxException e) {
                            report.failure(logger, e.getMessage());
                            Object var30_16 = null;
                            try {
                                archive.close();
                            }
                            catch (IOException e2) {
                                logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", this.path.getAbsolutePath()), e2);
                            }
                            if (tracing != null) {
                                tracing.print(System.out);
                                TracingUtilities.dump("org.glassfish.javaee.core.deployment.DolProvider", System.out);
                            }
                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                report.setResultType(String.class, this.name);
                                report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", this.name));
                                logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", this.name, timing.elapsed()));
                            } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                                String errorMessage = report.getMessage();
                                Throwable cause = report.getFailureCause();
                                if (cause != null) {
                                    String causeMessage = cause.getMessage();
                                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                        errorMessage = errorMessage + " : " + cause.getMessage();
                                    }
                                    logger.log(Level.SEVERE, errorMessage, cause.getCause());
                                }
                                report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", errorMessage));
                                report.setFailureCause(null);
                                if (expansionDir != null) {
                                    try {
                                        FileArchive arch = DeploymentUtils.openAsFileArchive(expansionDir, this.archiveFactory);
                                        arch.delete();
                                    }
                                    catch (IOException ex) {
                                        String msg = localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", expansionDir.getAbsolutePath());
                                        report.failure(logger, msg, ex);
                                    }
                                }
                            }
                            if (deploymentContext != null) {
                                deploymentContext.postDeployClean(true);
                            }
                            Object var37_52 = null;
                            this.events.unregister(this);
                            return;
                        }
                    }
                    File source = new File(archive.getURI().getSchemeSpecificPart());
                    isDirectoryDeployed = true;
                    if (!source.isDirectory()) {
                        isDirectoryDeployed = false;
                        this.path = expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                        break block115;
                    }
                    String versionFromSameDir = this.versioningService.getVersionFromSameDir(source);
                    if (this.force.booleanValue() || versionFromSameDir == null) break block115;
                    report.failure(logger, VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.dual.inplace", "GlassFish do not support versioning for directory deployment when using the same directory. The directory {0} is already assigned to the version {1}.", source.getPath(), versionFromSameDir));
                    Object var30_17 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", this.path.getAbsolutePath()), e2);
                    }
                    if (tracing != null) {
                        tracing.print(System.out);
                        TracingUtilities.dump("org.glassfish.javaee.core.deployment.DolProvider", System.out);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        report.setResultType(String.class, this.name);
                        report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", this.name));
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", this.name, timing.elapsed()));
                    } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        String errorMessage = report.getMessage();
                        Throwable cause = report.getFailureCause();
                        if (cause != null) {
                            String causeMessage = cause.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                errorMessage = errorMessage + " : " + cause.getMessage();
                            }
                            logger.log(Level.SEVERE, errorMessage, cause.getCause());
                        }
                        report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", errorMessage));
                        report.setFailureCause(null);
                        if (expansionDir != null) {
                            try {
                                FileArchive arch = DeploymentUtils.openAsFileArchive(expansionDir, this.archiveFactory);
                                arch.delete();
                            }
                            catch (IOException ex) {
                                String msg = localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", expansionDir.getAbsolutePath());
                                report.failure(logger, msg, ex);
                            }
                        }
                    }
                    if (deploymentContext == null) break block118;
                    deploymentContext.postDeployClean(true);
                }
            }
            Object var37_53 = null;
            this.events.unregister(this);
            {
                block119: {
                    block115: {
                        return;
                    }
                    deploymentContext = this.deployment.getBuilder(logger, this, report).source(archive).archiveHandler(archiveHandler).build(initialContext);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.CONTEXT_CREATED);
                        deploymentContext.addModuleMetaData(tracing);
                    }
                    if (undeployProps != null) {
                        deploymentContext.getAppProps().putAll((Map<?, ?>)undeployProps);
                    }
                    if (this.properties != null || this.property != null) {
                        if (this.properties == null) {
                            this.properties = new Properties();
                        }
                        if (this.property != null) {
                            this.properties.putAll((Map<?, ?>)this.property);
                        }
                    }
                    if (this.properties != null) {
                        deploymentContext.getAppProps().putAll((Map<?, ?>)this.properties);
                        this.validateDeploymentProperties(this.properties, deploymentContext);
                    }
                    deploymentContext.clean();
                    Properties appProps = deploymentContext.getAppProps();
                    String appLocation = DeploymentUtils.relativizeWithinDomainIfPossible(deploymentContext.getSource().getURI());
                    appProps.setProperty("location", appLocation);
                    appProps.setProperty("object-type", "user");
                    if (this.contextroot != null) {
                        appProps.setProperty("context-root", this.contextroot);
                    }
                    appProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                    savedAppConfig.store(appProps);
                    deploymentContext.addTransientAppMetaData("previousTargets", this.previousTargets);
                    deploymentContext.addTransientAppMetaData("previousVirtualServers", this.previousVirtualServers);
                    deploymentContext.addTransientAppMetaData("previousEnabledAttributes", this.previousEnabledAttributes);
                    Transaction t = this.deployment.prepareAppConfigChanges(deploymentContext);
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.DEPLOY);
                    }
                    ApplicationInfo appInfo = this.type == null ? this.deployment.deploy(deploymentContext) : this.deployment.deploy(this.deployment.prepareSniffersForOSGiDeployment(this.type, deploymentContext), deploymentContext);
                    Artifacts downloadableArtifacts = DeploymentUtils.downloadableArtifacts(deploymentContext);
                    Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts(deploymentContext);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        try {
                            this.moveAppFilesToPermanentLocation(deploymentContext, logger);
                            this.recordFileLocations(appProps);
                            downloadableArtifacts.record(appProps);
                            generatedArtifacts.record(appProps);
                            this.deployment.registerAppInDomainXML(appInfo, deploymentContext, t);
                            suppInfo.setDeploymentContext(deploymentContext);
                            ActionReport.ExitCode worstExitCode = ActionReport.ExitCode.SUCCESS;
                            for (ActionReport subReport : report.getSubActionsReport()) {
                                ActionReport.ExitCode actionExitCode = subReport.getActionExitCode();
                                if (!actionExitCode.isWorse(worstExitCode)) continue;
                                worstExitCode = actionExitCode;
                            }
                            report.setActionExitCode(worstExitCode);
                            report.setResultType(String.class, this.name);
                        }
                        catch (Exception e) {
                            this.deployment.undeploy(this.name, deploymentContext);
                            deploymentContext.clean();
                            throw e;
                        }
                    }
                    if (tracing != null) {
                        tracing.addMark(DeploymentTracing.Mark.REGISTRATION);
                    }
                    if (this.retrieve == null) break block119;
                    DeployCommand.retrieveArtifacts(context, downloadableArtifacts.getArtifacts(), this.retrieve, false);
                }
                Object var30_18 = null;
                try {
                    archive.close();
                }
                catch (IOException e2) {
                    logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", this.path.getAbsolutePath()), e2);
                }
                if (tracing != null) {
                    tracing.print(System.out);
                    TracingUtilities.dump("org.glassfish.javaee.core.deployment.DolProvider", System.out);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    report.setResultType(String.class, this.name);
                    report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", this.name));
                    logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", this.name, timing.elapsed()));
                } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                    String errorMessage = report.getMessage();
                    Throwable cause = report.getFailureCause();
                    if (cause != null) {
                        String causeMessage = cause.getMessage();
                        if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                            errorMessage = errorMessage + " : " + cause.getMessage();
                        }
                        logger.log(Level.SEVERE, errorMessage, cause.getCause());
                    }
                    report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", errorMessage));
                    report.setFailureCause(null);
                    if (expansionDir != null) {
                        try {
                            FileArchive arch = DeploymentUtils.openAsFileArchive(expansionDir, this.archiveFactory);
                            arch.delete();
                        }
                        catch (IOException ex) {
                            String msg = localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", expansionDir.getAbsolutePath());
                            report.failure(logger, msg, ex);
                        }
                    }
                }
                if (deploymentContext != null) {
                    deploymentContext.postDeployClean(true);
                }
                break block122;
                {
                    catch (Throwable e) {
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setMessage(e.getMessage());
                        report.setFailureCause(e);
                        Object var30_19 = null;
                        try {
                            archive.close();
                        }
                        catch (IOException e2) {
                            logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", this.path.getAbsolutePath()), e2);
                        }
                        if (tracing != null) {
                            tracing.print(System.out);
                            TracingUtilities.dump("org.glassfish.javaee.core.deployment.DolProvider", System.out);
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            report.setResultType(String.class, this.name);
                            report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", this.name));
                            logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", this.name, timing.elapsed()));
                        } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                            String errorMessage = report.getMessage();
                            Throwable cause = report.getFailureCause();
                            if (cause != null) {
                                String causeMessage = cause.getMessage();
                                if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                    errorMessage = errorMessage + " : " + cause.getMessage();
                                }
                                logger.log(Level.SEVERE, errorMessage, cause.getCause());
                            }
                            report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", errorMessage));
                            report.setFailureCause(null);
                            if (expansionDir != null) {
                                try {
                                    FileArchive arch = DeploymentUtils.openAsFileArchive(expansionDir, this.archiveFactory);
                                    arch.delete();
                                }
                                catch (IOException ex) {
                                    String msg = localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", expansionDir.getAbsolutePath());
                                    report.failure(logger, msg, ex);
                                }
                            }
                        }
                        if (deploymentContext != null) {
                            deploymentContext.postDeployClean(true);
                        }
                        break block122;
                    }
                }
                catch (Throwable throwable) {
                    Object var30_20 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.FINE, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", this.path.getAbsolutePath()), e2);
                    }
                    if (tracing != null) {
                        tracing.print(System.out);
                        TracingUtilities.dump("org.glassfish.javaee.core.deployment.DolProvider", System.out);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        report.setResultType(String.class, this.name);
                        report.setMessage(localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", this.name));
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", this.name, timing.elapsed()));
                    } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        String errorMessage = report.getMessage();
                        Throwable cause = report.getFailureCause();
                        if (cause != null) {
                            String causeMessage = cause.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                errorMessage = errorMessage + " : " + cause.getMessage();
                            }
                            logger.log(Level.SEVERE, errorMessage, cause.getCause());
                        }
                        report.setMessage(localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", errorMessage));
                        report.setFailureCause(null);
                        if (expansionDir != null) {
                            try {
                                FileArchive arch = DeploymentUtils.openAsFileArchive(expansionDir, this.archiveFactory);
                                arch.delete();
                            }
                            catch (IOException ex) {
                                String msg = localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", expansionDir.getAbsolutePath());
                                report.failure(logger, msg, ex);
                            }
                        }
                    }
                    if (deploymentContext != null) {
                        deploymentContext.postDeployClean(true);
                    }
                    throw throwable;
                }
            }
        }
        Object var37_54 = null;
        this.events.unregister(this);
    }

    private void moveAppFilesToPermanentLocation(ExtendedDeploymentContext deploymentContext, Logger logger) throws IOException {
        File finalUploadDir = deploymentContext.getAppInternalDir();
        finalUploadDir.mkdirs();
        this.safeCopyOfApp = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.originalPathValue, logger, this.env);
        this.safeCopyOfDeploymentPlan = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.deploymentplan, logger, this.env);
    }

    private void recordFileLocations(Properties appProps) throws URISyntaxException {
        if (this.safeCopyOfApp != null) {
            appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible(this.safeCopyOfApp.toURI()));
        }
        if (this.safeCopyOfDeploymentPlan != null) {
            appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible(this.safeCopyOfDeploymentPlan.toURI()));
        }
    }

    private Properties handleRedeploy(String name, ActionReport report) throws Exception {
        if (this.isredeploy.booleanValue()) {
            Application app = this.apps.getModule(Application.class, name);
            this.settingsFromDomainXML(app);
            ParameterMap parameters = new ParameterMap();
            parameters.add("DEFAULT", name);
            parameters.add("target", this.target);
            parameters.add("keepreposdir", this.keepreposdir.toString());
            parameters.add("isredeploy", this.isredeploy.toString());
            if (this.dropandcreatetables != null) {
                parameters.add("droptables", this.dropandcreatetables.toString());
            }
            parameters.add("_ignoreCascade", this.force.toString());
            if (this.keepstate != null) {
                parameters.add("keepstate", this.keepstate.toString());
            }
            ActionReport subReport = report.addSubActionsReport();
            subReport.setExtraProperties(new Properties());
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.add("keepSessions");
            propertyNames.add("preserveAppScopedResources");
            this.populatePropertiesToParameterMap(parameters, propertyNames);
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", subReport);
            inv.parameters(parameters).execute();
            return subReport.getExtraProperties();
        }
        return null;
    }

    private void populatePropertiesToParameterMap(ParameterMap parameters, List<String> propertyNamesList) {
        Properties props = new Properties();
        if (this.properties != null) {
            for (String propertyName : propertyNamesList) {
                if (!this.properties.containsKey(propertyName)) continue;
                props.put(propertyName, this.properties.getProperty(propertyName));
            }
        }
        parameters.add("properties", DeploymentUtils.propertiesValue(props, ':'));
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir) {
        DeployCommand.retrieveArtifacts(context, app, targetLocalDir, true);
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir, boolean reportErrorsInTopReport) {
        DeployCommand.retrieveArtifacts(context, DeploymentUtils.downloadableArtifacts(app).getArtifacts(), targetLocalDir, reportErrorsInTopReport);
    }

    private static void retrieveArtifacts(AdminCommandContext context, Collection<Artifacts.FullAndPartURIs> artifactInfo, String targetLocalDir, boolean reportErrorsInTopReport) {
        Logger logger = context.getLogger();
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            boolean retrieveArtifacts = false;
            if (outboundPayload == null) {
                outboundPayload = PayloadImpl.Outbound.newInstance();
                retrieveArtifacts = true;
            }
            Properties props = new Properties();
            props.setProperty("file-xfer-root", targetLocalDir.replace('\\', '/'));
            for (Artifacts.FullAndPartURIs uriPair : artifactInfo) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "About to download artifact {0}", uriPair.getFull());
                }
                outboundPayload.attachFile("application/octet-stream", uriPair.getPart(), "files", props, new File(uriPair.getFull().getSchemeSpecificPart()));
            }
            if (retrieveArtifacts) {
                String msg;
                File targetLocalFile = new File(targetLocalDir);
                if (targetLocalFile.exists()) {
                    msg = localStrings.getLocalString("download.errFileExists", "Unable to generate files. File [{0}] already exists.", targetLocalFile.getAbsolutePath());
                    throw new Exception(msg);
                }
                if (!targetLocalFile.getParentFile().exists()) {
                    msg = localStrings.getLocalString("download.errParentFileMissing", "Unable to generate files. Directory [{0}] does not exist.", targetLocalFile.getParent());
                    throw new Exception(msg);
                }
                FileOutputStream targetStream = new FileOutputStream(targetLocalFile);
                outboundPayload.writeTo(targetStream);
                targetStream.flush();
                targetStream.close();
            }
        }
        catch (Exception e) {
            String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
            logger.log(Level.SEVERE, errorMsg, e);
            ActionReport report = context.getActionReport();
            if (!reportErrorsInTopReport) {
                report = report.addSubActionsReport();
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            report.setMessage(errorMsg);
            report.setFailureCause(e);
        }
    }

    private void settingsFromDomainXML(Application app) {
        if (this.name != null) {
            String compatProp;
            if (this.contextroot == null && app.getContextRoot() != null) {
                this.previousContextRoot = app.getContextRoot();
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            this.previousTargets = this.domain.getAllReferencedTargetsForApplication(this.name);
            if (this.virtualservers == null) {
                if (DeploymentUtils.isDomainTarget(this.target)) {
                    for (String tgt : this.previousTargets) {
                        String vs = this.domain.getVirtualServersForApplication(tgt, this.name);
                        if (vs == null) continue;
                        this.previousVirtualServers.put(tgt, vs);
                    }
                } else {
                    this.virtualservers = this.domain.getVirtualServersForApplication(this.target, this.name);
                }
            }
            if (this.enabled == null) {
                if (DeploymentUtils.isDomainTarget(this.target)) {
                    for (String tgt : this.previousTargets) {
                        this.previousEnabledAttributes.put(tgt, this.domain.getEnabledForApplication(tgt, this.name));
                    }
                    this.previousEnabledAttributes.put("domain", app.getEnabled());
                    this.enabled = this.deployment.isAppEnabled(app);
                } else {
                    this.enabled = Boolean.valueOf(this.domain.getEnabledForApplication(this.target, this.name));
                }
            }
            if ((compatProp = app.getDeployProperties().getProperty("compatibility")) != null) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                if (this.properties.getProperty("compatibility") == null) {
                    this.properties.setProperty("compatibility", compatProp);
                }
            }
        }
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION)) {
            DeploymentContext context = (DeploymentContext)event.hook();
            if (this.verify.booleanValue()) {
                Verifier verifier = this.habitat.getByContract(Verifier.class);
                if (verifier != null) {
                    verifier.verify(context);
                } else {
                    context.getLogger().warning("Verifier is not installed yet. Install verifier module.");
                }
            }
        }
    }

    private void validateDeploymentProperties(Properties properties, DeploymentContext context) {
        String compatProp = properties.getProperty("compatibility");
        if (compatProp != null && !compatProp.equals("v2")) {
            String warningMsg = localStrings.getLocalString("compat.value.not.supported", "{0} is not a supported value for compatibility property.", compatProp);
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            subReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            subReport.setMessage(warningMsg);
            context.getLogger().log(Level.WARNING, warningMsg);
        }
    }
}

