/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.impl;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.annotation.impl.EjbJarScanner;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationUtils;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class EjbInWarScanner
extends EjbJarScanner {
    public void process(File archiveFile, EjbBundleDescriptor desc, ClassLoader classLoader) throws IOException {
        File[] jarFiles;
        File lib;
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archiveFile);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        this.archiveFile = archiveFile;
        this.classLoader = classLoader;
        if (!archiveFile.isDirectory()) {
            return;
        }
        File webinf = new File(archiveFile, "WEB-INF");
        File classes = new File(webinf, "classes");
        if (classes.exists()) {
            this.addScanDirectory(classes);
        }
        if ((lib = new File(webinf, "lib")).exists() && (jarFiles = lib.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".jar");
            }
        })) != null && jarFiles.length > 0) {
            for (File jarFile : jarFiles) {
                if (jarFile.isDirectory()) {
                    this.addScanDirectory(jarFile);
                    continue;
                }
                this.addScanJar(jarFile);
            }
        }
        for (EjbDescriptor ejbDesc : desc.getEjbs()) {
            if (!(ejbDesc instanceof EjbSessionDescriptor) && !(ejbDesc instanceof EjbMessageBeanDescriptor)) continue;
            this.addScanClassName(ejbDesc.getEjbClassName());
        }
        for (EjbInterceptor interceptor : desc.getInterceptors()) {
            this.addScanClassName(interceptor.getInterceptorClassName());
        }
    }
}

