/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.util;

import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolChooser;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolFactory;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.internal.api.Globals;

public class S1ASThreadPoolManager
implements ThreadPoolManager {
    static Logger _logger = LogDomains.getLogger(S1ASThreadPoolManager.class, "javax.enterprise.system.util");
    private static final int DEFAULT_NUMBER_OF_QUEUES = 0;
    private static final int DEFAULT_MIN_THREAD_COUNT = 10;
    private static final int DEFAULT_MAX_THREAD_COUNT = 200;
    private static HashMap idToIndexTable = new HashMap();
    private static HashMap indexToIdTable = new HashMap();
    private static ArrayList threadpoolList = new ArrayList();
    private static String defaultID;
    private static ThreadPoolManager s1asThreadPoolMgr;
    private static IIOPUtils _iiopUtils;

    public static ThreadPoolManager getThreadPoolManager() {
        return s1asThreadPoolMgr;
    }

    S1ASThreadPoolManager() {
        try {
            _iiopUtils = Globals.getDefaultHabitat().getByType(IIOPUtils.class);
            Collection<com.sun.grizzly.config.dom.ThreadPool> tpCol = _iiopUtils.getAllThreadPools();
            com.sun.grizzly.config.dom.ThreadPool[] allThreadPools = tpCol.toArray(new com.sun.grizzly.config.dom.ThreadPool[tpCol.size()]);
            for (int i = 0; i < allThreadPools.length; ++i) {
                this.createThreadPools(allThreadPools[i], i);
            }
            defaultID = (String)indexToIdTable.get(new Integer(0));
        }
        catch (NullPointerException npe) {
            _logger.log(Level.FINE, "Server Context is NULL. Ignoring and proceeding.");
        }
    }

    private void createThreadPools(com.sun.grizzly.config.dom.ThreadPool threadpoolBean, int index) {
        int idleTimeoutInSeconds;
        int maxThreads;
        int minThreads;
        String threadpoolId;
        block17: {
            block16: {
                block15: {
                    block14: {
                        threadpoolId = null;
                        minThreads = 10;
                        maxThreads = 200;
                        idleTimeoutInSeconds = 120000;
                        try {
                            threadpoolId = threadpoolBean.getName();
                        }
                        catch (NullPointerException npe) {
                            if (!_logger.isLoggable(Level.WARNING)) break block14;
                            _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                        }
                    }
                    try {
                        String minThreadsValue = threadpoolBean.getMinThreadPoolSize();
                        minThreads = Integer.parseInt(minThreadsValue);
                    }
                    catch (NullPointerException npe) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                            _logger.log(Level.WARNING, "Using default value for steady-threadpool-size = " + minThreads);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!_logger.isLoggable(Level.WARNING)) break block15;
                        _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                        _logger.log(Level.WARNING, "Using default value for min-threadpool-size = " + minThreads);
                    }
                }
                try {
                    String maxThreadsValue = threadpoolBean.getMaxThreadPoolSize();
                    maxThreads = Integer.parseInt(maxThreadsValue);
                }
                catch (NullPointerException npe) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                        _logger.log(Level.WARNING, "Using default value for max-threadpool-size = " + maxThreads);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!_logger.isLoggable(Level.WARNING)) break block16;
                    _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                    _logger.log(Level.WARNING, "Using default value for max-threadpool-size = " + maxThreads);
                }
            }
            try {
                String timeoutValue = threadpoolBean.getIdleThreadTimeoutSeconds();
                idleTimeoutInSeconds = Integer.parseInt(timeoutValue);
            }
            catch (NullPointerException npe) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "ThreadPoolBean may be null ", npe);
                    _logger.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = " + idleTimeoutInSeconds);
                }
            }
            catch (NumberFormatException nfe) {
                if (!_logger.isLoggable(Level.WARNING)) break block17;
                _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", nfe);
                _logger.log(Level.WARNING, "Using default value for idle-thread-timeout-in-seconds = " + idleTimeoutInSeconds);
            }
        }
        ThreadPoolFactory threadPoolFactory = new ThreadPoolFactory();
        ThreadPool threadpool = threadPoolFactory.create(minThreads, maxThreads, idleTimeoutInSeconds * 1000, threadpoolId, _iiopUtils.getCommonClassLoader());
        threadpoolList.add(threadpool);
        idToIndexTable.put(threadpoolId, new Integer(index));
        indexToIdTable.put(new Integer(index), threadpoolId);
    }

    public ThreadPool getThreadPool(String id) throws NoSuchThreadPoolException {
        Integer i = (Integer)idToIndexTable.get(id);
        if (i == null) {
            throw new NoSuchThreadPoolException();
        }
        try {
            ThreadPool threadpool = (ThreadPool)threadpoolList.get(i);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    public ThreadPool getThreadPool(int numericIdForThreadpool) throws NoSuchThreadPoolException {
        try {
            ThreadPool threadpool = (ThreadPool)threadpoolList.get(numericIdForThreadpool);
            return threadpool;
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new NoSuchThreadPoolException();
        }
    }

    public int getThreadPoolNumericId(String id) {
        Integer i = (Integer)idToIndexTable.get(id);
        return i == null ? 0 : i;
    }

    public String getThreadPoolStringId(int numericIdForThreadpool) {
        String id = (String)indexToIdTable.get(new Integer(numericIdForThreadpool));
        return id == null ? defaultID : id;
    }

    public ThreadPool getDefaultThreadPool() {
        try {
            return this.getThreadPool(0);
        }
        catch (NoSuchThreadPoolException nstpe) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "No default ThreadPool defined ", nstpe);
            }
            return null;
        }
    }

    public ThreadPoolChooser getThreadPoolChooser(String componentId) {
        return null;
    }

    public ThreadPoolChooser getThreadPoolChooser(int componentIndex) {
        return null;
    }

    public void setThreadPoolChooser(String componentId, ThreadPoolChooser aThreadPoolChooser) {
    }

    public int getThreadPoolChooserNumericId(String componentId) {
        return 0;
    }

    public void close() {
    }

    static {
        s1asThreadPoolMgr = new S1ASThreadPoolManager();
    }
}

