/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.extras.osgicontainer.BundleClassLoader;
import org.glassfish.extras.osgicontainer.OSGiContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDeployedBundle
implements ApplicationContainer<OSGiContainer> {
    private Bundle bundle;

    public OSGiDeployedBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public OSGiContainer getDescriptor() {
        return null;
    }

    @Override
    public boolean start(ApplicationContext startupContext) throws Exception {
        return this.resume();
    }

    @Override
    public boolean stop(ApplicationContext stopContext) {
        return this.suspend();
    }

    @Override
    public boolean suspend() {
        if (!OSGiDeployedBundle.isFragment(this.bundle)) {
            this.stopBundle();
        }
        return true;
    }

    @Override
    public boolean resume() throws Exception {
        if (!OSGiDeployedBundle.isFragment(this.bundle)) {
            this.startBundle();
        }
        return true;
    }

    @Override
    public ClassLoader getClassLoader() {
        return new BundleClassLoader(this.bundle);
    }

    private static boolean isFragment(Bundle b) {
        return b.getHeaders().get("Fragment-Host") != null;
    }

    private void startBundle() throws BundleException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl1 = this.getClassLoader();
            assert (cl1 != null);
            Thread.currentThread().setContextClassLoader(cl1);
            this.bundle.start(3);
            System.out.println("Started " + this.bundle);
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    private void stopBundle() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl1 = this.getClassLoader();
            assert (cl1 != null);
            Thread.currentThread().setContextClassLoader(cl1);
            this.bundle.stop(1);
            System.out.println("Stopped " + this.bundle);
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

