/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.grizzly.config.ConfigAwareElement;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.http.ProcessorTaskFactory;
import com.sun.grizzly.http.ajp.AjpConfiguration;
import com.sun.grizzly.http.ajp.AjpProcessorTaskFactory;
import com.sun.grizzly.http.ajp.ShutdownHandler;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="grizzly-ajp")
@ContractProvided(value=ProcessorTaskFactory.class)
public class AjpProcessorTaskFactoryProvider
extends AjpProcessorTaskFactory
implements ConfigAwareElement<NetworkListener> {
    private static final Logger LOGGER = LogDomains.getLogger(AjpProcessorTaskFactoryProvider.class, "javax.enterprise.system.core");

    public AjpProcessorTaskFactoryProvider() {
        super(new AjpConfigurationImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Habitat habitat, NetworkListener networkListener) {
        String configFileName = networkListener.getJkConfigurationFile();
        if (configFileName != null) {
            Properties props;
            File configFile = new File(configFileName);
            if (!configFile.exists()) {
                LOGGER.log(Level.WARNING, "JK configuration file {0} is not found.", configFileName);
                return;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(configFile);
                props = new Properties();
                props.load(is);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error loading JK configuration from file {0}: {1} '{2}'", new Object[]{configFileName, e.getClass().getName(), e.getMessage()});
                return;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ignored) {}
                }
            }
            this.configure(props);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AjpConfigurationImpl
    implements AjpConfiguration {
        private final Queue<ShutdownHandler> shutdownHandlers = new ConcurrentLinkedQueue<ShutdownHandler>();
        private String secret;
        private boolean isTomcatAuthentication = true;
        private boolean isShutdownEnabled = false;

        private AjpConfigurationImpl() {
        }

        @Override
        public Queue<ShutdownHandler> getShutdownHandlers() {
            return this.shutdownHandlers;
        }

        @Override
        public boolean isTomcatAuthentication() {
            return this.isTomcatAuthentication;
        }

        @Override
        public void setTomcatAuthentication(boolean isTomcatAuthentication) {
            this.isTomcatAuthentication = isTomcatAuthentication;
        }

        @Override
        public String getSecret() {
            return this.secret;
        }

        @Override
        public void setSecret(String requiredSecret) {
            this.secret = requiredSecret;
        }

        @Override
        public boolean isShutdownEnabled() {
            return this.isShutdownEnabled;
        }

        @Override
        public void setShutdownEnabled(boolean isShutdownEnabled) {
            this.isShutdownEnabled = isShutdownEnabled;
        }
    }
}

