/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.jdbc.admin.cli.JDBCResourceManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-jdbc-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.jdbc.resource")
public class CreateJdbcResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcResource.class);
    @Param(name="connectionpoolid", alias="poolName")
    private String connectionPoolId;
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(optional=true)
    private String description;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true)
    private String target = "server";
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private JDBCResourceManager jdbcMgr;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("jndi-name", this.jndiName);
        attrList.put("pool-name", this.connectionPoolId);
        attrList.put("description", this.description);
        attrList.put("enabled", this.enabled.toString());
        try {
            rs = this.jdbcMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.jdbc.resource.failed", "JDBC resource {0} creation failed", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

