/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.embedded;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.internal.embedded.Port;
import org.glassfish.kernel.embedded.PortsImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@Scoped(value=PerLookup.class)
public class PortImpl
implements Port {
    @Inject
    CommandRunner runner = null;
    @Inject(name="plain")
    ActionReport report = null;
    @Inject
    PortsImpl ports;
    @Inject
    NetworkConfig config;
    @Inject
    HttpService httpService;
    String listenerName;
    int number;
    String defaultVirtualServer = "server";

    public void setPortNumber(int portNumber) {
        this.number = portNumber;
    }

    public void close() {
        this.removeListener();
        this.ports.remove(this);
    }

    private void removeListener() {
        try {
            ConfigSupport.apply(new ConfigCode(){

                public Object run(ConfigBeanProxy[] params) throws PropertyVetoException, TransactionFailure {
                    NetworkListeners nt = (NetworkListeners)params[0];
                    VirtualServer vs = (VirtualServer)params[1];
                    Protocols protocols = (Protocols)params[2];
                    List<Protocol> protos = protocols.getProtocol();
                    for (Protocol proto : protos) {
                        if (!proto.getName().equals(PortImpl.this.listenerName)) continue;
                        protos.remove(proto);
                        break;
                    }
                    List<NetworkListener> list = nt.getNetworkListener();
                    for (NetworkListener listener : list) {
                        if (!listener.getName().equals(PortImpl.this.listenerName)) continue;
                        list.remove(listener);
                        break;
                    }
                    String regex = PortImpl.this.listenerName + ",?";
                    String lss = vs.getNetworkListeners();
                    if (lss != null) {
                        vs.setNetworkListeners(lss.replaceAll(regex, ""));
                    }
                    return null;
                }
            }, this.config.getNetworkListeners(), this.httpService.getVirtualServerByName(this.defaultVirtualServer), this.config.getProtocols());
        }
        catch (TransactionFailure tf) {
            tf.printStackTrace();
            throw new RuntimeException(tf);
        }
    }

    public int getPortNumber() {
        return this.number;
    }
}

