/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiejb;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgijavaeebase.OSGiJavaEEArchive;
import org.glassfish.osgijavaeebase.URIable;
import org.osgi.framework.Bundle;

public class EJBBundle
extends OSGiJavaEEArchive {
    public EJBBundle(Bundle[] fragments, Bundle host) {
        super(fragments, host);
    }

    protected void init() {
        OSGiJavaEEArchive.EffectiveBCP bcp = this.getEffectiveBCP();
        ArrayList<OSGiJavaEEArchive.BCPEntry> bcpEntries = new ArrayList<OSGiJavaEEArchive.BCPEntry>(bcp.getBCPEntries());
        Collections.reverse(bcpEntries);
        for (OSGiJavaEEArchive.BCPEntry bcpEntry : bcpEntries) {
            bcpEntry.accept(new OSGiJavaEEArchive.BCPEntry.BCPEntryVisitor(){

                public void visitDir(OSGiJavaEEArchive.DirBCPEntry bcpEntry) {
                    this.visitBCPEntry(bcpEntry);
                }

                public void visitJar(OSGiJavaEEArchive.JarBCPEntry bcpEntry) {
                    if (bcpEntry.getName().equals(".")) {
                        OSGiBundleArchive subArchive = EJBBundle.this.getArchive(bcpEntry.getBundle());
                        this.addEntriesForSubArchive(subArchive);
                    } else {
                        this.visitBCPEntry(bcpEntry);
                    }
                }

                private void visitBCPEntry(OSGiJavaEEArchive.BCPEntry bcpEntry) {
                    try {
                        ReadableArchive subArchive = EJBBundle.this.getArchive(bcpEntry.getBundle()).getSubArchive(bcpEntry.getName());
                        this.addEntriesForSubArchive(subArchive);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                private void addEntriesForSubArchive(Archive subArchive) {
                    final URIable uriableArchive = (URIable)((Object)subArchive);
                    for (final String subEntry : Collections.list(subArchive.entries())) {
                        OSGiJavaEEArchive.ArchiveEntry archiveEntry = new OSGiJavaEEArchive.ArchiveEntry(){

                            public String getName() {
                                return subEntry;
                            }

                            public URI getURI() throws URISyntaxException {
                                return uriableArchive.getEntryURI(subEntry);
                            }

                            public InputStream getInputStream() throws IOException {
                                try {
                                    return this.getURI().toURL().openStream();
                                }
                                catch (URISyntaxException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        };
                        EJBBundle.this.getEntries().put(archiveEntry.getName(), archiveEntry);
                    }
                }
            });
        }
    }
}

