/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.JarHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARManifestProcessor {
    private static Logger logger = Logger.getLogger(WARManifestProcessor.class.getPackage().getName());
    private static final String DEFAULT_MAN_VERSION = "2";
    private static final String DEFAULT_IMPORT_PACKAGE = "javax.servlet; javax.servlet.http; version=2.5, javax.servlet.jsp; javax.servlet.jsp.tagext;javax.el; javax.servlet.jsp.el; version=2.1";
    private static final String DEFAULT_BUNDLE_CP = "WEB-INF/classes";
    private static final AtomicInteger nextBsnId = new AtomicInteger();
    private static final String DEFAULT_BSN_PREFIX = "org.glassfish.fighterfish.autogenerated_";
    private static Attributes.Name[] supportedQueryParamNames = new Attributes.Name[]{new Attributes.Name("Bundle-SymbolicName"), new Attributes.Name("Bundle-Version"), new Attributes.Name("Bundle-ManifestVersion"), new Attributes.Name("Import-Package"), new Attributes.Name("Web-ContextPath")};

    public static Map<String, String> readQueryParams(String query) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (query != null) {
            logger.logp(Level.FINE, "WARManifestProcessor", "readQueryParams", "Input query params = {0}", new Object[]{query});
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                int eq = next.indexOf("=");
                String name = next;
                String value = null;
                if (eq != -1) {
                    name = next.substring(0, eq);
                    if (eq + 1 < next.length()) {
                        value = next.substring(eq + 1);
                    }
                }
                for (Attributes.Name supportedQueryParamName : supportedQueryParamNames) {
                    if (!supportedQueryParamName.toString().equalsIgnoreCase(name)) continue;
                    name = supportedQueryParamName.toString();
                }
                queryParams.put(name, value);
            }
            logger.logp(Level.FINE, "WARManifestProcessor", "readQueryParams", "Canonicalized query params = {0}", new Object[]{queryParams});
        }
        return queryParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest processManifest(URL url, String query) throws IOException {
        JarInputStream jis = new JarInputStream(url.openStream());
        try {
            Manifest oldManifest = jis.getManifest();
            Manifest newManifest = new Manifest(oldManifest);
            Attributes attrs = newManifest.getMainAttributes();
            Map<String, String> queryParams = WARManifestProcessor.readQueryParams(WARManifestProcessor.decode(query));
            if (WARManifestProcessor.isWAB(jis)) {
                if (queryParams.keySet().size() != 1) {
                    throw new IllegalArgumentException("Only Web-ContextPath can be customized using webbundle scheme for a WAB");
                }
                WARManifestProcessor.processWCP(queryParams, attrs);
            } else {
                WARManifestProcessor.processWCP(queryParams, attrs);
                WARManifestProcessor.processBMV(queryParams, attrs);
                WARManifestProcessor.processBSN(queryParams, attrs);
                WARManifestProcessor.processBV(queryParams, attrs);
                WARManifestProcessor.processBCP(queryParams, attrs, jis);
                WARManifestProcessor.processIP(queryParams, attrs);
                attrs.putValue("DynamicImport-Package", "*");
                WARManifestProcessor.processSignatures(newManifest);
            }
            logger.logp(Level.FINE, "WARManifestProcessor", "processManifest", "New Attributes of the bundle = {0}", new Object[]{attrs});
            newManifest.write(System.err);
            Manifest manifest = newManifest;
            return manifest;
        }
        finally {
            jis.close();
        }
    }

    private static String decode(String encodedQuery) {
        String decodedQuery;
        logger.logp(Level.FINE, "WARManifestProcessor", "decode", "encodedQuery = {0}", new Object[]{encodedQuery});
        try {
            decodedQuery = new URI("http://localhost/index.html?" + encodedQuery).getQuery();
        }
        catch (URISyntaxException e) {
            logger.logp(Level.INFO, "WARManifestProcessor", "decode", "Assuming this is already decoded because of {0} ", new Object[]{e});
            decodedQuery = encodedQuery;
        }
        logger.logp(Level.FINE, "WARManifestProcessor", "decode", "decodedQuery = {0}", new Object[]{decodedQuery});
        return decodedQuery;
    }

    private static boolean isWAB(JarInputStream jis) {
        Attributes attrs = jis.getManifest().getMainAttributes();
        return !Collections.disjoint(attrs.keySet(), Arrays.asList(supportedQueryParamNames));
    }

    private static void processWCP(Map<String, String> queryParams, Attributes attrs) {
        String contextPath = queryParams.get("Web-ContextPath");
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        attrs.putValue("Web-ContextPath", contextPath);
    }

    private static void processBMV(Map<String, String> queryParams, Attributes attrs) {
        WARManifestProcessor.process(queryParams, attrs, "Bundle-ManifestVersion", DEFAULT_MAN_VERSION);
    }

    private static void processBSN(Map<String, String> queryParams, Attributes attrs) {
        String defaultSymName = DEFAULT_BSN_PREFIX + nextBsnId.getAndIncrement();
        WARManifestProcessor.process(queryParams, attrs, "Bundle-SymbolicName", defaultSymName);
    }

    private static void processBV(Map<String, String> queryParams, Attributes attrs) {
        WARManifestProcessor.process(queryParams, attrs, "Bundle-Version", null);
    }

    private static void processBCP(Map<String, String> queryParams, Attributes attrs, final JarInputStream jis) throws IOException {
        final ArrayList<String> libs = new ArrayList<String>();
        final ArrayList<String> jarNames = new ArrayList<String>();
        JarHelper.accept(jis, new JarHelper.Visitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visit(JarEntry je) {
                block10: {
                    String name = je.getName();
                    String LIB_DIR = "WEB-INF/lib/";
                    String JAR_EXT = ".jar";
                    if (!je.isDirectory() && name.endsWith(JAR_EXT)) {
                        String jarName;
                        jarNames.add(name);
                        if (name.startsWith(LIB_DIR) && !(jarName = name.substring(LIB_DIR.length())).contains("/")) {
                            libs.add(name);
                            try {
                                JarInputStream libJarIs = new JarInputStream(jis);
                                try {
                                    String classPath = libJarIs.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                                    if (classPath == null || classPath.isEmpty()) break block10;
                                    logger.logp(Level.FINE, "WARManifestProcessor", "visit", "jar {0} has a Class-Path entry of {1}", new Object[]{name, classPath});
                                    try {
                                        String referencedJarName = null;
                                        referencedJarName = URI.create(name).resolve(classPath).toString();
                                        logger.logp(Level.INFO, "WARManifestProcessor", "visit", "Resolved Class-Path {0} to entry name {1} ", new Object[]{classPath, referencedJarName});
                                        if (!libs.contains(referencedJarName)) {
                                            libs.add(referencedJarName);
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.logp(Level.WARNING, "WARManifestProcessor", "visit", "Unexpected exception while trying to compute referenced classpath for " + name, e);
                                    }
                                }
                                finally {
                                    libJarIs.closeEntry();
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
            }
        });
        String cp = WARManifestProcessor.convertToCP(libs, jarNames);
        cp = cp.length() > 0 ? DEFAULT_BUNDLE_CP.concat(",").concat(cp) : DEFAULT_BUNDLE_CP;
        logger.logp(Level.FINE, "WARManifestProcessor", "processBCP", "cp = {0}", new Object[]{cp});
        WARManifestProcessor.process(queryParams, attrs, "Bundle-ClassPath", cp);
    }

    private static void processIP(Map<String, String> queryParams, Attributes attrs) {
        WARManifestProcessor.process(queryParams, attrs, "Import-Package", DEFAULT_IMPORT_PACKAGE);
    }

    private static void processSignatures(Manifest manifest) {
        for (Attributes attrs : manifest.getEntries().values()) {
            for (Object key : attrs.keySet().toArray()) {
                String keyName = key.toString();
                if (!keyName.endsWith("-Digest") && !keyName.contains("-Digest-") && !keyName.equals("Magic")) continue;
                attrs.remove(key);
            }
        }
    }

    private static String convertToCP(List<String> cpJars, List<String> allJarNames) {
        StringBuilder cp = new StringBuilder();
        for (String cpJar : cpJars) {
            if (!allJarNames.contains(cpJar)) {
                logger.logp(Level.INFO, "WARManifestProcessor", "convertToCP", "Excluding {0}, as there is no jar by this name in the war", new Object[]{cpJar});
                continue;
            }
            if (cp.length() > 0) {
                cp.append(",");
            }
            cp.append(cpJar);
        }
        return cp.toString();
    }

    private static void process(Map<String, String> deployerOptions, Attributes developerOptions, String key, String defaultOption) {
        String deployerOption = deployerOptions.get(key);
        String developerOption = developerOptions.getValue(key);
        String finalOption = defaultOption;
        if (deployerOption != null) {
            finalOption = deployerOption;
        } else if (developerOption != null) {
            finalOption = developerOption;
        }
        if (finalOption != null && !finalOption.equals(developerOption)) {
            developerOptions.putValue(key, finalOption);
        }
    }
}

