/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.WeldDeployer;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JCDIServiceImpl
implements JCDIService {
    @Inject
    private WeldDeployer weldDeployer;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;
    private Logger logger = Logger.getLogger(JCDIServiceImpl.class.getName());

    @Override
    public boolean isCurrentModuleJCDIEnabled() {
        BundleDescriptor bundle = null;
        Object inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            return false;
        }
        JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(((ComponentInvocation)inv).getComponentId());
        if (componentEnv != null) {
            if (componentEnv instanceof BundleDescriptor) {
                bundle = (BundleDescriptor)((Object)componentEnv);
            } else if (componentEnv instanceof com.sun.enterprise.deployment.EjbDescriptor) {
                bundle = ((com.sun.enterprise.deployment.EjbDescriptor)componentEnv).getEjbBundleDescriptor();
            }
        }
        return bundle != null ? this.isJCDIEnabled(bundle) : false;
    }

    @Override
    public boolean isJCDIEnabled(BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        return this.weldDeployer.is299Enabled(topLevelBundleDesc);
    }

    @Override
    public boolean isCDIScoped(Class<?> clazz) {
        return clazz.isAnnotationPresent(RequestScoped.class) || clazz.isAnnotationPresent(ApplicationScoped.class) || clazz.isAnnotationPresent(SessionScoped.class) || clazz.isAnnotationPresent(ConversationScoped.class);
    }

    @Override
    public void setELResolver(ServletContext servletContext) throws NamingException {
        InitialContext context = new InitialContext();
        BeanManager beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        if (beanManager != null) {
            servletContext.setAttribute("org.glassfish.jsp.beanManagerELResolver", beanManager.getELResolver());
        }
    }

    @Override
    public JCDIService.JCDIInjectionContext createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, Object instance) {
        return this._createJCDIInjectionContext(ejb, instance);
    }

    @Override
    public JCDIService.JCDIInjectionContext createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb) {
        return this._createJCDIInjectionContext(ejb, null);
    }

    private JCDIService.JCDIInjectionContext _createJCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, Object instance) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.getBDAForBeanClass(topLevelBundleDesc, ejb.getEjbClassName());
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl weldManager = bootstrap.getManager(bda);
        EjbDescriptor ejbDesc = weldManager.getEjbDescriptor(ejb.getName());
        Bean bean = weldManager.getBean(ejbDesc);
        InjectionTarget it = weldManager.createInjectionTarget(ejbDesc);
        CreationalContext cc = weldManager.createCreationalContext(bean);
        Object beanInstance = instance;
        if (beanInstance == null) {
            beanInstance = it.produce(cc);
        }
        return new JCDIInjectionContextImpl(it, cc, beanInstance);
    }

    private BeanDeploymentArchive getBDAForBeanClass(BundleDescriptor bundleDesc, String beanClassName) {
        BeanDeploymentArchive topLevelBDA;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "getBDAForBeanClass -- search in " + bundleDesc.getModuleName() + " for " + beanClassName);
        }
        if ((topLevelBDA = this.weldDeployer.getBeanDeploymentArchiveForBundle(bundleDesc)).getBeanClasses().contains(beanClassName)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "JCDIServiceImpl.getBDAForBeanClass:: TopLevelBDA " + topLevelBDA.getId() + " contains beanClassName:" + beanClassName);
            }
            return topLevelBDA;
        }
        for (BeanDeploymentArchive bda : topLevelBDA.getBeanDeploymentArchives()) {
            if (!bda.getBeanClasses().contains(beanClassName)) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "JCDIServiceImpl.getBDAForBeanClass:: subBDA " + bda.getId() + " contains beanClassName:" + beanClassName);
            }
            return bda;
        }
        return topLevelBDA;
    }

    @Override
    public void injectEJBInstance(JCDIService.JCDIInjectionContext injectionCtx) {
        JCDIInjectionContextImpl injectionCtxImpl = (JCDIInjectionContextImpl)injectionCtx;
        injectionCtxImpl.it.inject(injectionCtxImpl.instance, injectionCtxImpl.cc);
    }

    @Override
    public JCDIService.JCDIInjectionContext createManagedObject(Class managedClass, BundleDescriptor bundle) {
        return this.createManagedObject(managedClass, bundle, true);
    }

    @Override
    public void injectManagedObject(Object managedObject, BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        AnnotatedType<?> annotatedType = beanManager.createAnnotatedType(managedObject.getClass());
        InjectionTarget<?> it = beanManager.createInjectionTarget(annotatedType);
        CreationalContext cc = beanManager.createCreationalContext(null);
        it.inject(managedObject, cc);
    }

    @Override
    public JCDIService.JCDIInjectionContext createManagedObject(Class managedClass, BundleDescriptor bundle, boolean invokePostConstruct) {
        WeldBootstrap bootstrap;
        BeanManagerImpl beanManager;
        AnnotatedType annotatedType;
        Object managedObject = null;
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        InjectionTarget<Object> it = ((BeanDeploymentArchiveImpl)bda).getInjectionTarget(annotatedType = (beanManager = (bootstrap = this.weldDeployer.getBootstrapForApp(bundle.getApplication())).getManager(bda)).createAnnotatedType(managedClass));
        if (it == null) {
            it = beanManager.createInjectionTarget(annotatedType);
        }
        CreationalContext cc = beanManager.createCreationalContext(null);
        managedObject = it.produce(cc);
        it.inject(managedObject, cc);
        if (invokePostConstruct) {
            it.postConstruct(managedObject);
        }
        return new JCDIInjectionContextImpl(it, cc, managedObject);
    }

    private class JCDIInjectionContextImpl
    implements JCDIService.JCDIInjectionContext {
        InjectionTarget it;
        CreationalContext cc;
        Object instance;

        JCDIInjectionContextImpl(InjectionTarget it, CreationalContext cc, Object i) {
            this.it = it;
            this.cc = cc;
            this.instance = i;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void cleanup(boolean callPreDestroy) {
            if (callPreDestroy) {
                this.it.preDestroy(this.instance);
            }
            this.it.dispose(this.instance);
            this.cc.release();
        }
    }
}

