/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import javax.script.ScriptException;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.ScriptAssert;
import org.hibernate.validator.util.scriptengine.ScriptEvaluator;
import org.hibernate.validator.util.scriptengine.ScriptEvaluatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptAssertValidator
implements ConstraintValidator<ScriptAssert, Object> {
    private String script;
    private String languageName;
    private String alias;

    @Override
    public void initialize(ScriptAssert constraintAnnotation) {
        this.validateParameters(constraintAnnotation);
        this.script = constraintAnnotation.script();
        this.languageName = constraintAnnotation.lang();
        this.alias = constraintAnnotation.alias();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        Object evaluationResult;
        ScriptEvaluator scriptEvaluator;
        try {
            ScriptEvaluatorFactory evaluatorFactory = ScriptEvaluatorFactory.getInstance();
            scriptEvaluator = evaluatorFactory.getScriptEvaluatorByLanguageName(this.languageName);
        }
        catch (ScriptException e) {
            throw new ConstraintDeclarationException(e);
        }
        try {
            evaluationResult = scriptEvaluator.evaluate(this.script, value, this.alias);
        }
        catch (ScriptException e) {
            throw new ConstraintDeclarationException("Error during execution of script \"" + this.script + "\" occurred.", e);
        }
        if (evaluationResult == null) {
            throw new ConstraintDeclarationException("Script \"" + this.script + "\" returned null, but must return either true or false.");
        }
        if (!(evaluationResult instanceof Boolean)) {
            throw new ConstraintDeclarationException("Script \"" + this.script + "\" returned " + evaluationResult + " (of type " + evaluationResult.getClass().getCanonicalName() + "), but must return either true or false.");
        }
        return Boolean.TRUE.equals(evaluationResult);
    }

    private void validateParameters(ScriptAssert constraintAnnotation) {
        if (constraintAnnotation.script().length() == 0) {
            throw new IllegalArgumentException("The parameter \"script\" must not be empty.");
        }
        if (constraintAnnotation.lang().length() == 0) {
            throw new IllegalArgumentException("The parameter \"lang\" must not be empty.");
        }
        if (constraintAnnotation.alias().length() == 0) {
            throw new IllegalArgumentException("The parameter \"alias\" must not be empty.");
        }
    }
}

