/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.proxy.InterceptorInvocation;
import org.jboss.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.interceptor.reader.ClassMetadataInterceptorReference;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorImpl<T>
extends ManagedBean<T>
implements Interceptor<T> {
    private final InterceptorMetadata<?> interceptorMetadata;
    private final Set<Annotation> interceptorBindingTypes;
    private final boolean serializable;

    public static <T> InterceptorImpl<T> of(WeldClass<T> type2, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new InterceptorImpl<T>(type2, beanManager, services);
    }

    protected InterceptorImpl(WeldClass<T> type2, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(type2, Interceptor.class.getSimpleName() + "-" + type2.getName(), beanManager, services);
        this.interceptorMetadata = beanManager.getInterceptorMetadataReader().getInterceptorMetadata(ClassMetadataInterceptorReference.of(WeldInterceptorClassMetadata.of(type2)));
        this.serializable = type2.isSerializable();
        this.interceptorBindingTypes = new HashSet<Annotation>();
        this.interceptorBindingTypes.addAll(InterceptorImpl.flattenInterceptorBindings(beanManager, this.getWeldAnnotated().getAnnotations()));
        for (Class<Annotation> annotation : this.getStereotypes()) {
            this.interceptorBindingTypes.addAll(InterceptorImpl.flattenInterceptorBindings(beanManager, beanManager.getStereotypeDefinition(annotation)));
        }
        if (this.interceptorBindingTypes.size() == 0) {
            throw new DeploymentException(BeanMessage.MISSING_BINDING_ON_INTERCEPTOR, type2.getName());
        }
        if (Beans.findInterceptorBindingConflicts(beanManager, this.interceptorBindingTypes)) {
            throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType());
        }
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindingTypes;
    }

    public InterceptorMetadata<?> getInterceptorMetadata() {
        return this.interceptorMetadata;
    }

    @Override
    public Object intercept(javax.enterprise.inject.spi.InterceptionType type2, T instance, InvocationContext ctx) {
        try {
            InterceptionType interceptionType = InterceptionType.valueOf(type2.name());
            ArrayList invocations = new ArrayList();
            invocations.add(new InterceptorInvocation<T>(instance, this.interceptorMetadata, interceptionType));
            return new SimpleInterceptionChain(invocations, interceptionType, instance, ctx.getMethod()).invokeNextInterceptor(ctx);
        }
        catch (Throwable e) {
            throw new WeldException(e);
        }
    }

    @Override
    public boolean intercepts(javax.enterprise.inject.spi.InterceptionType type2) {
        return this.interceptorMetadata.getInterceptorMethods(InterceptionType.valueOf(type2.name())).size() > 0;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    protected void defaultPostConstruct(T instance) {
    }

    @Override
    protected void defaultPreDestroy(T instance) {
    }

    @Override
    public String toString() {
        return "Interceptor [" + this.getBeanClass() + " intercepts " + Formats.formatAnnotations(this.getInterceptorBindings()) + "]";
    }
}

