/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxies {
    public static boolean isTypeProxyable(Type type2) {
        return Proxies.getUnproxyableTypeException(type2) == null;
    }

    public static UnproxyableResolutionException getUnproxyableTypeException(Type type2) {
        return Proxies.getUnproxyableTypeException(type2, null);
    }

    public static boolean isTypesProxyable(Bean<?> declaringBean) {
        return Proxies.getUnproxyableTypesException(declaringBean) == null;
    }

    public static boolean isTypesProxyable(Iterable<? extends Type> types) {
        return Proxies.getUnproxyableTypesException(types) == null;
    }

    public static UnproxyableResolutionException getUnproxyableTypesException(Bean<?> declaringBean) {
        if (declaringBean == null) {
            throw new java.lang.IllegalArgumentException("Null declaring bean!");
        }
        return Proxies.getUnproxyableTypesExceptionInt(declaringBean.getTypes(), declaringBean);
    }

    public static UnproxyableResolutionException getUnproxyableTypesException(Iterable<? extends Type> types) {
        return Proxies.getUnproxyableTypesExceptionInt(types, null);
    }

    private static UnproxyableResolutionException getUnproxyableTypeException(Type type2, Bean<?> declaringBean) {
        Type rawType;
        if (type2 instanceof Class) {
            return Proxies.getUnproxyableClassException((Class)type2, declaringBean);
        }
        if (type2 instanceof ParameterizedType && (rawType = ((ParameterizedType)type2).getRawType()) instanceof Class) {
            return Proxies.getUnproxyableClassException((Class)rawType, declaringBean);
        }
        return new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE_UNKNOWN, type2, Proxies.getDeclaringBeanInfo(declaringBean));
    }

    private static UnproxyableResolutionException getUnproxyableTypesExceptionInt(Iterable<? extends Type> types, Bean<?> declaringBean) {
        for (Type type2 : types) {
            UnproxyableResolutionException e;
            if (Object.class.equals((Object)type2) || (e = Proxies.getUnproxyableTypeException(type2, declaringBean)) == null) continue;
            return e;
        }
        return null;
    }

    private static UnproxyableResolutionException getUnproxyableClassException(Class<?> clazz, Bean<?> declaringBean) {
        Constructor<?> constructor;
        if (clazz.isInterface()) {
            return null;
        }
        try {
            constructor = SecureReflections.getDeclaredConstructor(clazz, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (!InstantiatorFactory.useInstantiators()) {
                return new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE_NO_CONSTRUCTOR, clazz, Proxies.getDeclaringBeanInfo(declaringBean));
            }
            return null;
        }
        if (constructor == null) {
            return new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE_NO_CONSTRUCTOR, clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            if (!InstantiatorFactory.useInstantiators()) {
                return new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE_PRIVATE_CONSTRUCTOR, clazz, constructor, Proxies.getDeclaringBeanInfo(declaringBean));
            }
            return null;
        }
        if (Reflections.isTypeOrAnyMethodFinal(clazz)) {
            return new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE_FINAL_TYPE_OR_METHOD, clazz, Reflections.getNonPrivateFinalMethodOrType(clazz), Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (clazz.isPrimitive()) {
            return new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE_PRIMITIVE, clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (Reflections.isArrayType(clazz)) {
            return new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE_ARRAY_TYPE, clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        return null;
    }

    private static Object getDeclaringBeanInfo(Bean<?> bean) {
        return bean != null ? bean : "<unknown javax.enterprise.inject.spi.Bean instance>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeInfo {
        private final Set<Class<?>> interfaces = new LinkedHashSet();
        private final Set<Class<?>> classes = new LinkedHashSet();

        private TypeInfo() {
        }

        public Class<?> getSuperClass() {
            if (this.classes.isEmpty()) {
                return Object.class;
            }
            Iterator<Class<?>> it = this.classes.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        public Class<?> getSuperInterface() {
            if (this.interfaces.isEmpty()) {
                return null;
            }
            Iterator<Class<?>> it = this.interfaces.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        private TypeInfo add(Type type2) {
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                if (clazz.isInterface()) {
                    this.interfaces.add(clazz);
                } else {
                    this.classes.add(clazz);
                }
            } else if (type2 instanceof ParameterizedType) {
                this.add(((ParameterizedType)type2).getRawType());
            } else {
                throw new IllegalArgumentException(UtilMessage.CANNOT_PROXY_NON_CLASS_TYPE, type2);
            }
            return this;
        }

        public Set<Class<?>> getClasses() {
            return Collections.unmodifiableSet(this.classes);
        }

        public Set<Class<?>> getInterfaces() {
            return Collections.unmodifiableSet(this.interfaces);
        }

        public static TypeInfo of(Set<? extends Type> types) {
            TypeInfo typeInfo = new TypeInfo();
            for (Type type2 : types) {
                typeInfo.add(type2);
            }
            return typeInfo;
        }
    }
}

