/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.reflect.ReflectUtils;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.flashlight.FlashlightUtils;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeClientInvokerFactory;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.impl.client.ProbeClientMethodHandleImpl;
import org.glassfish.flashlight.impl.client.Strings;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.flashlight.transformer.ProbeProviderClassFileTransformer;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FlashlightProbeClientMediator
implements ProbeClientMediator,
PostConstruct {
    private static final ProbeRegistry probeRegistry = ProbeRegistry.getInstance();
    private static final Logger logger = LogDomains.getLogger(FlashlightProbeClientMediator.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlashlightProbeClientMediator.class);
    private static FlashlightProbeClientMediator _me = new FlashlightProbeClientMediator();
    private AtomicInteger clientIdGenerator = new AtomicInteger(0);
    private static ConcurrentHashMap<Integer, Object> clients = new ConcurrentHashMap();

    public void postConstruct() {
        FlashlightProbeClientMediator.initMe(this);
    }

    private static void initMe(FlashlightProbeClientMediator me) {
        _me = me;
    }

    public static FlashlightProbeClientMediator getInstance() {
        return _me;
    }

    public static Object getClient(int id) {
        return clients.get(id);
    }

    @Override
    public Collection<ProbeClientMethodHandle> registerListener(Object listener) {
        return this.registerListener(listener, null);
    }

    @Override
    public Collection<ProbeClientMethodHandle> registerListener(Object listener, String invokerId) {
        ArrayList<ProbeClientMethodHandle> pcms = new ArrayList<ProbeClientMethodHandle>();
        ArrayList<FlashlightProbe> probesRequiringClassTransformation = new ArrayList<FlashlightProbe>();
        if (invokerId != null) {
            invokerId = FlashlightUtils.getUniqueInvokerId(invokerId);
        }
        this.registerJavaListener(listener, pcms, probesRequiringClassTransformation, invokerId);
        this.transformProbes(listener, probesRequiringClassTransformation);
        return pcms;
    }

    public Collection<ProbeClientMethodHandle> registerDTraceListener(FlashlightProbeProvider propro) {
        ArrayList<ProbeClientMethodHandle> pcms = new ArrayList<ProbeClientMethodHandle>();
        ArrayList<FlashlightProbe> probesRequiringClassTransformation = new ArrayList<FlashlightProbe>();
        Object listener = this.registerDTraceListener(propro, pcms, probesRequiringClassTransformation);
        this.transformProbes(listener, probesRequiringClassTransformation);
        return pcms;
    }

    private void registerJavaListener(Object listener, List<ProbeClientMethodHandle> pcms, List<FlashlightProbe> probesRequiringClassTransformation, String invokerId) {
        List<MethodProbe> methodProbePairs = this.handleListenerAnnotations(listener.getClass(), invokerId);
        if (methodProbePairs.isEmpty()) {
            return;
        }
        for (MethodProbe mp : methodProbePairs) {
            FlashlightProbe probe = mp.probe;
            ProbeClientInvoker invoker = ProbeClientInvokerFactory.createInvoker(listener, mp.method, probe);
            ProbeClientMethodHandleImpl hi = new ProbeClientMethodHandleImpl(invoker.getId(), invoker, probe);
            pcms.add(hi);
            if (!probe.addInvoker(invoker)) continue;
            probesRequiringClassTransformation.add(probe);
        }
    }

    private Object registerDTraceListener(FlashlightProbeProvider propro, List<ProbeClientMethodHandle> pcms, List<FlashlightProbe> probesRequiringClassTransformation) {
        Collection<FlashlightProbe> probes = propro.getProbes();
        Object listener = null;
        for (FlashlightProbe probe : probes) {
            ProbeClientInvoker invoker = ProbeClientInvokerFactory.createDTraceInvoker(probe);
            ProbeClientMethodHandleImpl hi = new ProbeClientMethodHandleImpl(invoker.getId(), invoker, probe);
            pcms.add(hi);
            if (probe.addInvoker(invoker)) {
                probesRequiringClassTransformation.add(probe);
            }
            if (listener != null) continue;
            listener = probe.getDTraceProviderImpl();
        }
        return listener;
    }

    @Override
    public void transformProbes(Object listener, List<FlashlightProbe> probes) {
        if (probes.isEmpty()) {
            return;
        }
        int clientID = this.clientIdGenerator.incrementAndGet();
        clients.put(clientID, listener);
        HashMap<Class, ProbeProviderClassFileTransformer> transformers = new HashMap<Class, ProbeProviderClassFileTransformer>();
        for (FlashlightProbe probe : probes) {
            Class clz = probe.getProviderClazz();
            ProbeProviderClassFileTransformer transformer = (ProbeProviderClassFileTransformer)transformers.get(clz);
            if (transformer == null) {
                transformer = new ProbeProviderClassFileTransformer(clz);
                transformers.put(clz, transformer);
            }
            try {
                transformer.regProbe(probe);
            }
            catch (NoSuchMethodException ex) {
                logger.severe(localStrings.getLocalString("bad.transform", "MNTG0505:Error transforming Probe: {0}", new Object[]{ex}));
            }
        }
        for (ProbeProviderClassFileTransformer t : transformers.values()) {
            t.transform();
        }
    }

    private List<MethodProbe> handleListenerAnnotations(Class listenerClass, String invokerId) {
        LinkedList<MethodProbe> mp = new LinkedList<MethodProbe>();
        for (Method method : listenerClass.getMethods()) {
            FlashlightProbe probe;
            ProbeListener probeAnn = method.getAnnotation(ProbeListener.class);
            if (probeAnn == null) continue;
            String probeString = probeAnn.value();
            if (probeString != null && invokerId != null) {
                String[] strArr = probeString.split(":");
                probeString = strArr[0] + ":" + strArr[1] + ":" + strArr[2] + invokerId + ":" + strArr[3];
            }
            if ((probe = probeRegistry.getProbe(probeString)) == null) {
                String errStr = localStrings.getLocalString("probeNotRegistered", "Probe is not registered: {0}", new Object[]{probeString});
                throw new RuntimeException(errStr);
            }
            mp.add(new MethodProbe(method, probe));
        }
        return mp;
    }

    private static class MethodProbe {
        Method method;
        FlashlightProbe probe;

        MethodProbe(Method m, FlashlightProbe p) {
            this.method = m;
            this.probe = p;
            String err = ReflectUtils.equalSignatures((Method)this.method, (Method)p.getProbeMethod());
            if (err != null) {
                throw new RuntimeException(Strings.get("method_mismatch", err));
            }
        }
    }
}

