/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.FlashlightLoggerInfo;

final class AgentAttacherInternal {
    private static final Object syncOnMe = new Object();
    private static final Logger logger = FlashlightLoggerInfo.getLogger();
    private static boolean isAttached = false;

    AgentAttacherInternal() {
    }

    static boolean isAttached() {
        return isAttached;
    }

    static boolean attachAgent() {
        return AgentAttacherInternal.attachAgent(-1, "");
    }

    static boolean attachAgent(int pid, String options) {
        try {
            if (isAttached) {
                return true;
            }
            if (pid < 0) {
                pid = ProcessUtils.getPid();
            }
            if (pid < 0) {
                logger.log(Level.WARNING, "NCLS-MON-0501");
                return false;
            }
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(pid));
            String ir = System.getProperty("com.sun.aas.installRoot");
            File dir = new File(ir, "lib" + File.separator + "monitor");
            if (!dir.isDirectory()) {
                logger.log(Level.WARNING, "NCLS-MON-0503", dir);
                return false;
            }
            File agentJar = new File(dir, "flashlight-agent.jar");
            if (!agentJar.isFile()) {
                logger.log(Level.WARNING, "NCLS-MON-0502", dir);
                return false;
            }
            vm.loadAgent(SmartFile.sanitize((String)agentJar.getPath()), options);
            isAttached = true;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "NCLS-MON-0504", t.getMessage());
            isAttached = false;
        }
        return isAttached;
    }
}

