/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.xml;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.glassfish.flashlight.xml.Provider;
import org.glassfish.flashlight.xml.StaxParser;
import org.glassfish.flashlight.xml.XmlConstants;
import org.glassfish.flashlight.xml.XmlProbe;
import org.glassfish.flashlight.xml.XmlProbeParam;

public class ProbeProviderStaxParser
extends StaxParser {
    private static final Logger logger = FlashlightLoggerInfo.getLogger();
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProbeProviderStaxParser.class);
    private List<Provider> providers = null;

    public ProbeProviderStaxParser(File f) throws XMLStreamException {
        super(f);
    }

    public ProbeProviderStaxParser(InputStream in) throws XMLStreamException {
        super(in);
    }

    public List<Provider> getProviders() {
        if (this.providers == null) {
            try {
                this.read();
            }
            catch (Exception ex) {
                this.close();
            }
        }
        if (this.providers.isEmpty()) {
            logger.log(Level.SEVERE, "NCLS-MON-0306");
        }
        return this.providers;
    }

    @Override
    protected void read() throws XMLStreamException, StaxParser.EndDocumentException {
        this.providers = new ArrayList<Provider>();
        this.skipPast("probe-providers");
        while (true) {
            this.providers.add(this.parseProbeProvider());
        }
    }

    private Provider parseProbeProvider() throws XMLStreamException {
        if (!this.parser.getLocalName().equals(XmlConstants.PROBE_PROVIDER)) {
            String errStr = localStrings.getLocalString("invalidStartElement", "START_ELEMENT is supposed to be {0}, found: {1}", new Object[]{XmlConstants.PROBE_PROVIDER, this.parser.getLocalName()});
            throw new XMLStreamException(errStr);
        }
        Map<String, String> atts = this.parseAttributes();
        List<XmlProbe> probes = this.parseProbes();
        return new Provider(atts.get(XmlConstants.MODULE_PROVIDER_NAME), atts.get(XmlConstants.MODULE_NAME), atts.get(XmlConstants.PROBE_PROVIDER_NAME), atts.get(XmlConstants.PROBE_PROVIDER_CLASS), probes);
    }

    private List<XmlProbe> parseProbes() throws XMLStreamException {
        ArrayList<XmlProbe> probes = new ArrayList<XmlProbe>();
        boolean done = false;
        try {
            this.nextStart();
        }
        catch (StaxParser.EndDocumentException ex) {
            done = true;
        }
        while (!done && this.parser.getEventType() != 8) {
            if (this.parser.getLocalName().equals(XmlConstants.PROBE)) {
                probes.add(this.parseProbe());
                continue;
            }
            done = true;
        }
        return probes;
    }

    private XmlProbe parseProbe() throws XMLStreamException {
        if (!this.parser.getLocalName().equals(XmlConstants.PROBE)) {
            String errStr = localStrings.getLocalString("invalidStartElement", "START_ELEMENT is supposed to be {0}, found: {1}", new Object[]{XmlConstants.PROBE, this.parser.getLocalName()});
            throw new XMLStreamException(errStr);
        }
        ArrayList<XmlProbeParam> params = new ArrayList<XmlProbeParam>();
        Map<String, String> atts = this.parseAttributes();
        String method = null;
        String name = atts.get(XmlConstants.PROBE_NAME);
        boolean self = Boolean.parseBoolean(atts.get(XmlConstants.PROBE_SELF));
        boolean hidden = Boolean.parseBoolean(atts.get(XmlConstants.PROBE_HIDDEN));
        boolean stateful = Boolean.parseBoolean(atts.get(XmlConstants.PROBE_STATEFUL));
        boolean statefulReturn = Boolean.parseBoolean(atts.get(XmlConstants.PROBE_STATEFUL_RETURN));
        boolean statefulException = Boolean.parseBoolean(atts.get(XmlConstants.PROBE_STATEFUL_EXCEPTION));
        String profileNames = atts.get(XmlConstants.PROBE_PROFILE_NAMES);
        boolean done = false;
        while (!done) {
            try {
                this.nextStart();
                String localName = this.parser.getLocalName();
                if (localName.equals(XmlConstants.METHOD)) {
                    method = this.parser.getElementText();
                    continue;
                }
                if (localName.equals(XmlConstants.PROBE_PARAM)) {
                    params.add(this.parseParam());
                    continue;
                }
                done = true;
            }
            catch (StaxParser.EndDocumentException ex) {
                done = true;
            }
        }
        return new XmlProbe(name, method, params, self, hidden, stateful, statefulReturn, statefulException, profileNames);
    }

    private XmlProbeParam parseParam() throws XMLStreamException {
        if (!this.parser.getLocalName().equals(XmlConstants.PROBE_PARAM)) {
            String errStr = localStrings.getLocalString("invalidStartElement", "START_ELEMENT is supposed to be {0}, found: {1}", new Object[]{XmlConstants.PROBE_PARAM, this.parser.getLocalName()});
            throw new XMLStreamException(errStr);
        }
        Map<String, String> atts = this.parseAttributes();
        return new XmlProbeParam(atts.get(XmlConstants.PROBE_PARAM_NAME), atts.get(XmlConstants.PROBE_PARAM_TYPE));
    }
}

