/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.orb.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.Services;
import org.glassfish.internal.api.Target;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-iiop-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.iiop.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE})
public class DeleteIiopListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteIiopListener.class);
    @Param(name="listener_id", primary=true)
    String listener_id;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    Services services;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.byType(Target.class).get();
        Config config = targetUtil.getConfig(this.target);
        ActionReport report = context.getActionReport();
        IiopService iiopService = (IiopService)config.getExtensionByType(IiopService.class);
        if (!this.isIIOPListenerExists(iiopService)) {
            report.setMessage(localStrings.getLocalString("delete.iiop.listener.notexists", "IIOP Listener {0} does not exist.", new Object[]{this.listener_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<IiopService>(){

                public Object run(IiopService param) throws PropertyVetoException, TransactionFailure {
                    List<IiopListener> listenerList = param.getIiopListener();
                    for (IiopListener listener : listenerList) {
                        String currListenerId = listener.getId();
                        if (currListenerId == null || !currListenerId.equals(DeleteIiopListener.this.listener_id)) continue;
                        listenerList.remove(listener);
                        break;
                    }
                    return listenerList;
                }
            }, (ConfigBeanProxy)iiopService);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String actual = e.getMessage();
            report.setMessage(localStrings.getLocalString("delete.iiop.listener.fail", "failed", new Object[]{this.listener_id, actual}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean isIIOPListenerExists(IiopService iiopService) {
        for (IiopListener listener : iiopService.getIiopListener()) {
            String currListenerId = listener.getId();
            if (currListenerId == null || !currListenerId.equals(this.listener_id)) continue;
            return true;
        }
        return false;
    }
}

