/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.extension.CopyObjectPolicy;
import com.sun.corba.ee.spi.extension.ServantCachingPolicy;
import com.sun.corba.ee.spi.extension.ZeroPortPolicy;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactory;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.codegen.Wrapper;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.util.Utility;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.NoSuchObjectLocalException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.glassfish.enterprise.iiop.api.RemoteReferenceFactory;
import org.glassfish.enterprise.iiop.impl.CSIv2Policy;
import org.glassfish.enterprise.iiop.impl.OTSPolicyImpl;
import org.glassfish.enterprise.iiop.impl.POAProtocolMgr;
import org.glassfish.enterprise.iiop.spi.EjbContainerFacade;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;

public final class POARemoteReferenceFactory
extends LocalObject
implements RemoteReferenceFactory,
ServantLocator {
    static final int PASS_BY_VALUE_ID = 0;
    static final int PASS_BY_REFERENCE_ID = 1;
    static final int OTS_POLICY_TYPE = 1398079611;
    static final int CSIv2_POLICY_TYPE = 1398079612;
    static final int REQUEST_DISPATCH_POLICY_TYPE = 1398079613;
    static final int SFSB_VERSION_POLICY_TYPE = 1398079614;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.corba");
    private static final int GET_TIE_EXCEPTION_CODE = 9999;
    private EjbContainerFacade container;
    private EjbDescriptor ejbDescriptor;
    private ClassLoader appClassLoader;
    private ORB orb;
    private POAProtocolMgr protocolMgr;
    private PresentationManager presentationMgr;
    private ReferenceFactory ejbHomeReferenceFactory;
    private PresentationManager.StubFactory ejbHomeStubFactory;
    private String ejbHomeRepositoryId;
    private ReferenceFactory ejbObjectReferenceFactory;
    private PresentationManager.StubFactory ejbObjectStubFactory;
    private String ejbObjectRepositoryId;
    private String remoteBusinessIntf;
    private boolean isRemoteHomeView;
    private String poaId_EJBHome;
    private String poaId_EJBObject;
    static final int EJBID_OFFSET = 0;
    private static final int INSTANCEKEYLEN_OFFSET = 8;
    private static final int INSTANCEKEY_OFFSET = 12;

    POARemoteReferenceFactory(EjbContainerFacade container, POAProtocolMgr protocolMgr, ORB orb, boolean remoteHomeView, String id) {
        this.protocolMgr = protocolMgr;
        this.orb = orb;
        this.poaId_EJBHome = id + "-EJBHome";
        this.poaId_EJBObject = id + "-EJBObject";
        this.presentationMgr = orb.getPresentationManager();
        this.container = container;
        this.ejbDescriptor = container.getEjbDescriptor();
        this.isRemoteHomeView = remoteHomeView;
        this.appClassLoader = container.getClassLoader();
    }

    public int getCSIv2PolicyType() {
        return 1398079612;
    }

    private String getRepositoryId(Class c) throws Exception {
        PresentationManager.ClassData cData = this.presentationMgr.getClassData(c);
        String[] typeIds = cData.getTypeIds();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, ".getRepositoryId: {0}", typeIds[0]);
        }
        return typeIds[0];
    }

    public void setRepositoryIds(Class homeIntf, Class remoteIntf) {
        PresentationManager.StubFactoryFactory sff = ORB.getStubFactoryFactory();
        this.ejbHomeStubFactory = sff.createStubFactory(homeIntf.getName(), false, "", null, this.appClassLoader);
        String[] ejbHomeTypeIds = this.ejbHomeStubFactory.getTypeIds();
        this.ejbHomeRepositoryId = ejbHomeTypeIds[0];
        this.ejbObjectStubFactory = sff.createStubFactory(remoteIntf.getName(), false, "", null, this.appClassLoader);
        String[] ejbObjectTypeIds = this.ejbObjectStubFactory.getTypeIds();
        this.ejbObjectRepositoryId = ejbObjectTypeIds[0];
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, ".setRepositoryIds: {0} {1}", new java.lang.Object[]{this.ejbHomeRepositoryId, this.ejbObjectRepositoryId});
        }
        try {
            this.ejbHomeReferenceFactory = this.createReferenceFactory(this.poaId_EJBHome, this.ejbHomeRepositoryId);
            this.ejbObjectReferenceFactory = this.createReferenceFactory(this.poaId_EJBObject, this.ejbObjectRepositoryId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!this.isRemoteHomeView) {
            this.remoteBusinessIntf = remoteIntf.getName();
        }
    }

    public void cleanupClass(Class clazz) {
        try {
            this.presentationMgr.flushClass(clazz);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "cleanupClass error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceFactory createReferenceFactory(String poaId, String repoid) throws Exception {
        ReferenceFactory referenceFactory;
        block10: {
            try {
                ReferenceFactory rf;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, ".createReferenceFactory->: {0} {1}", new java.lang.Object[]{poaId, repoid});
                }
                ReferenceFactoryManager rfm = (ReferenceFactoryManager)this.orb.resolve_initial_references("ReferenceFactoryManager");
                ArrayList<java.lang.Object> policies = new ArrayList<java.lang.Object>();
                policies.add(ServantCachingPolicy.getPolicy());
                policies.add((java.lang.Object)new OTSPolicyImpl());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, ".createReferenceFactory: {0} {1}: {2}", new java.lang.Object[]{poaId, repoid, this.ejbDescriptor});
                }
                policies.add((java.lang.Object)new CSIv2Policy(this.ejbDescriptor));
                IASEjbExtraDescriptors extraDesc = this.ejbDescriptor.getIASEjbExtraDescriptors();
                String threadPoolName = extraDesc.getUseThreadPoolId();
                int threadPoolNumericID = 0;
                boolean usePassByReference = extraDesc.getPassByReference();
                if (usePassByReference) {
                    policies.add(new CopyObjectPolicy(1));
                }
                if (logger.isLoggable(Level.FINE)) {
                    String jndiName = this.ejbDescriptor.getJndiName();
                    logger.log(Level.FINE, "Using Thread-Pool: [{0} ==> {1}] for jndi name: {2}", new java.lang.Object[]{threadPoolName, threadPoolNumericID, jndiName});
                    logger.log(Level.FINE, "Pass by reference: [{0}] for jndi name: {1}", new java.lang.Object[]{usePassByReference, usePassByReference});
                }
                if (this.ejbDescriptor.allMechanismsRequireSSL()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.WARNING, ".createReferenceFactory: {0} {1}: adding ZeroPortPolicy", new java.lang.Object[]{poaId, repoid});
                    }
                    policies.add(ZeroPortPolicy.getPolicy());
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, ".createReferenceFactory: {0} {1}: policies: {2}", new java.lang.Object[]{poaId, repoid, policies});
                }
                referenceFactory = rf = rfm.create(poaId, repoid, policies, (ServantLocator)this);
                if (!logger.isLoggable(Level.FINE)) break block10;
            }
            catch (Throwable throwable) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, ".createReferenceFactory<-: {0} {1}", new java.lang.Object[]{poaId, repoid});
                }
                throw throwable;
            }
            logger.log(Level.WARNING, ".createReferenceFactory<-: {0} {1}", new java.lang.Object[]{poaId, repoid});
        }
        return referenceFactory;
    }

    public Remote createRemoteReference(byte[] instanceKey) {
        return this.createRef(instanceKey, this.ejbObjectReferenceFactory, this.ejbObjectStubFactory, this.ejbObjectRepositoryId);
    }

    public Remote createHomeReference(byte[] homeKey) {
        return this.createRef(homeKey, this.ejbHomeReferenceFactory, this.ejbHomeStubFactory, this.ejbHomeRepositoryId);
    }

    private void setClassLoader() {
        SecurityManager sman = System.getSecurityManager();
        ClassLoader cl = sman == null ? ((java.lang.Object)((java.lang.Object)this)).getClass().getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return this.getClass().getClassLoader();
            }
        });
        Wrapper._setClassLoader((ClassLoader)cl);
    }

    private Remote createRef(byte[] instanceKey, ReferenceFactory rf, PresentationManager.StubFactory stubFactory, String repoid) {
        try {
            PresentationManager.StubFactory stubFact = stubFactory;
            Object ref = this._createRef(rf, instanceKey, repoid);
            this.setClassLoader();
            Object stub = stubFact.makeStub();
            Delegate delegate = StubAdapter.getDelegate((java.lang.Object)ref);
            StubAdapter.setDelegate((java.lang.Object)stub, (Delegate)delegate);
            return (Remote)stub;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.createreference_exception", e.toString());
            throw new RuntimeException("Unable to create reference ", e);
        }
    }

    private Object _createRef(ReferenceFactory rf, byte[] instanceKey, String repoid) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "\t\tIn POARemoteReferenceFactory._createRef, repositoryId = {0}", repoid);
        }
        byte[] ejbKey = this.createEJBKey(this.ejbDescriptor.getUniqueId(), instanceKey);
        Object obj = rf.createReference(ejbKey);
        return obj;
    }

    private byte[] createEJBKey(long ejbId, byte[] instanceKey) {
        byte[] ejbkey = new byte[12 + instanceKey.length];
        Utility.longToBytes((long)ejbId, (byte[])ejbkey, (int)0);
        Utility.intToBytes((int)instanceKey.length, (byte[])ejbkey, (int)8);
        System.arraycopy(instanceKey, 0, ejbkey, 12, instanceKey.length);
        return ejbkey;
    }

    public void destroyReference(Remote remoteRef, Remote remoteObj) {
        try {
            Util.unexportObject((Remote)remoteObj);
        }
        catch (RuntimeException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Servant preinvoke(byte[] ejbKey, POA adapter, String operation, CookieHolder cookieHolder) throws ForwardRequest {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "In preinvoke for operation:{0}", operation);
        }
        int keyLen = Utility.bytesToInt((byte[])ejbKey, (int)8);
        byte[] instanceKey = new byte[keyLen];
        System.arraycopy(ejbKey, 12, instanceKey, 0, keyLen);
        Servant servant = null;
        try {
            while (servant == null) {
                Remote targetObj = this.container.getTargetObject(instanceKey, this.isRemoteHomeView ? null : this.remoteBusinessIntf);
                if (targetObj == null) continue;
                Tie tie = (Tie)AccessController.doPrivileged(new PrivilegedAction(){

                    public Tie run() {
                        return POARemoteReferenceFactory.this.presentationMgr.getTie();
                    }
                });
                tie.setTarget(targetObj);
                servant = (Servant)tie;
            }
        }
        catch (NoSuchObjectLocalException e) {
            logger.log(Level.SEVERE, "iiop.gettie_exception", e);
            throw new OBJECT_NOT_EXIST(9999, CompletionStatus.COMPLETED_NO);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "iiop.runtime_exception", e);
            throw e;
        }
        return servant;
    }

    public void postinvoke(byte[] ejbKey, POA adapter, String operation, java.lang.Object cookie, Servant servant) {
        Remote target = null;
        if (servant != null) {
            target = ((Tie)servant).getTarget();
        }
        this.container.releaseTargetObject(target);
    }

    public void destroy() {
        try {
            this.ejbHomeReferenceFactory.destroy();
            this.ejbObjectReferenceFactory.destroy();
            this.ejbHomeReferenceFactory = null;
            this.ejbObjectReferenceFactory = null;
            this.container = null;
            this.ejbDescriptor = null;
            this.orb = null;
            this.protocolMgr = null;
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "Exception during POARemoteRefFactory::destroy()", th);
        }
    }

    public boolean hasSameContainerID(Object obj) throws Exception {
        boolean result = false;
        try {
            IOR ior = this.orb.getIOR(obj, false);
            Iterator iter = ior.iterator();
            byte[] oid = null;
            if (iter.hasNext()) {
                TaggedProfile profile = (TaggedProfile)iter.next();
                ObjectKey objKey = profile.getObjectKey();
                oid = objKey.getId().getId();
            }
            if (oid != null && oid.length > 12) {
                long cid = Utility.bytesToLong(oid, (int)0);
                int keyLen = Utility.bytesToInt((byte[])oid, (int)8);
                if (oid.length == keyLen + 12) {
                    boolean bl = result = cid == this.ejbDescriptor.getUniqueId();
                }
                if (logger.isLoggable(Level.FINE)) {
                    StringBuilder sbuf = new StringBuilder();
                    sbuf.append("hasSameContainerID() result: ").append(result).append("; because ==> oid.length: ").append(oid.length).append("; instance-key-length: ").append(keyLen).append("; expected oid.length: ").append(keyLen).append("+").append(12).append("; myContainrID: ").append(this.ejbDescriptor.getUniqueId()).append("; obj.containerID: ").append(cid);
                    logger.log(Level.FINE, sbuf.toString());
                }
            } else if (logger.isLoggable(Level.FINE)) {
                if (oid == null) {
                    logger.log(Level.FINE, "hasSameContainerID() failed because oid=null");
                } else {
                    logger.log(Level.FINE, "hasSameContainerID() failed because oid.length= {0}; but INSTANCE_KEY_OFFSET= {1}", new java.lang.Object[]{oid.length, 12});
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Exception while checking for same containerID", ex);
            throw ex;
        }
        return result;
    }
}

