/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.impl.RoundRobinPolicy;

public class GroupInfoServiceObserverImpl
implements GroupInfoServiceObserver {
    protected static final Logger _logger = LogDomains.getLogger(GroupInfoServiceObserverImpl.class, (String)"javax.enterprise.system.core.naming");
    private GroupInfoService gis;
    private RoundRobinPolicy rr;

    private static void doLog(Level level, String fmt, Object ... args) {
        if (_logger.isLoggable(level)) {
            _logger.log(level, fmt, args);
        }
    }

    private static void fineLog(String fmt, Object ... args) {
        GroupInfoServiceObserverImpl.doLog(Level.FINE, fmt, args);
    }

    public GroupInfoServiceObserverImpl(GroupInfoService gis, RoundRobinPolicy rr) {
        this.gis = gis;
        this.rr = rr;
    }

    public void forceMembershipChange() {
        GroupInfoServiceObserverImpl.fineLog("GroupInfoServiceObserverImpl.forceMembershipChange called", new Object[0]);
        this.doMembershipChange();
    }

    public void membershipChange() {
        GroupInfoServiceObserverImpl.fineLog("GroupInfoServiceObserverImpl.membershipChange called", new Object[0]);
        this.doMembershipChange();
    }

    private void doMembershipChange() {
        try {
            List instanceInfoList = this.gis.getClusterInstanceInfo(null, this.rr.getHostPortList());
            if (instanceInfoList != null && instanceInfoList.size() > 0) {
                this.rr.setClusterInstanceInfo(instanceInfoList);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "groupinfoservice.membership.notification.problem", new Object[]{e});
        }
    }
}

