/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.naming.cosnaming.TransientNameService;
import com.sun.corba.ee.spi.copyobject.CopierManager;
import com.sun.corba.ee.spi.copyobject.CopyobjectDefaults;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.presentation.rmi.InvocationInterceptor;
import com.sun.corba.ee.spi.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.threadpool.ThreadPool;
import com.sun.corba.ee.spi.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.TransportDefault;
import com.sun.corba.ee.spi.transport.TransportManager;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.glassfish.enterprise.iiop.util.S1ASThreadPoolManager;
import org.glassfish.enterprise.iiop.util.ThreadPoolStatsImpl;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.pfl.dynamic.copyobject.spi.ObjectCopierFactory;
import org.omg.CORBA.ORB;

public class PEORBConfigurator
implements ORBConfigurator {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.corba");
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String IIOP_CLEAR_TEXT_CONNECTION = "IIOP_CLEAR_TEXT";
    private static final String DEFAULT_ORB_INIT_HOST = "localhost";
    private static com.sun.corba.ee.spi.orb.ORB theORB;
    private static ThreadPoolManager threadpoolMgr;
    private static boolean txServiceInitialized;
    private Acceptor lazyAcceptor = null;
    private static final Set<String> ANY_ADDRS;

    private GlassFishORBHelper getHelper() {
        IIOPUtils iiopUtils = IIOPUtils.getInstance();
        return (GlassFishORBHelper)iiopUtils.getHabitat().getService(GlassFishORBHelper.class, new Annotation[0]);
    }

    public void configure(DataCollector dc, com.sun.corba.ee.spi.orb.ORB orb) {
        try {
            if (threadpoolMgr != null) {
                orb.setThreadPoolManager(threadpoolMgr);
            }
            ThreadPoolManager tpool = orb.getThreadPoolManager();
            ThreadPool thpool = tpool.getDefaultThreadPool();
            String ThreadPoolName = thpool.getName();
            ThreadPoolStatsImpl tpStats = new ThreadPoolStatsImpl(thpool.getWorkQueue(0).getThreadPool());
            StatsProviderManager.register((String)"orb", (PluginPoint)PluginPoint.SERVER, (String)("thread-pool/orb/threadpool/" + ThreadPoolName), (Object)tpStats);
            PEORBConfigurator.configureCopiers(orb);
            PEORBConfigurator.configureCallflowInvocationInterceptor(orb);
            IIOPUtils iiopUtils = IIOPUtils.getInstance();
            if (iiopUtils.getProcessType().isServer()) {
                List iiop_listener_list = IIOPUtils.getInstance().getIiopService().getIiopListener();
                IiopListener[] iiopListenerBeans = iiop_listener_list.toArray(new IiopListener[iiop_listener_list.size()]);
                this.createORBListeners(iiopUtils, iiopListenerBeans, (ORB)orb);
            }
            if (orb.getORBData().environmentIsGFServer()) {
                new TransientNameService(orb);
            }
            this.getHelper().setORB((ORB)orb);
        }
        catch (NoSuchWorkQueueException ex) {
            Logger.getLogger(PEORBConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void configureCopiers(com.sun.corba.ee.spi.orb.ORB orb) {
        CopierManager cpm = orb.getCopierManager();
        ObjectCopierFactory stream = CopyobjectDefaults.makeORBStreamObjectCopierFactory((com.sun.corba.ee.spi.orb.ORB)orb);
        ObjectCopierFactory reflect = CopyobjectDefaults.makeReflectObjectCopierFactory((com.sun.corba.ee.spi.orb.ORB)orb);
        ObjectCopierFactory fallback = CopyobjectDefaults.makeFallbackObjectCopierFactory((ObjectCopierFactory)reflect, (ObjectCopierFactory)stream);
        ObjectCopierFactory reference = CopyobjectDefaults.getReferenceObjectCopierFactory();
        cpm.registerObjectCopierFactory(fallback, 0);
        cpm.registerObjectCopierFactory(reference, 1);
        cpm.setDefaultId(0);
    }

    public static void setThreadPoolManager() {
        threadpoolMgr = S1ASThreadPoolManager.getThreadPoolManager();
    }

    private static void configureCallflowInvocationInterceptor(com.sun.corba.ee.spi.orb.ORB orb) {
        orb.setInvocationInterceptor(new InvocationInterceptor(){

            public void preInvoke() {
            }

            public void postInvoke() {
            }
        });
    }

    private Acceptor addAcceptor(ORB orb, boolean isLazy, String host, String type, int port) {
        com.sun.corba.ee.spi.orb.ORB theOrb = (com.sun.corba.ee.spi.orb.ORB)orb;
        TransportManager ctm = theOrb.getTransportManager();
        Acceptor acceptor = isLazy ? TransportDefault.makeLazyCorbaAcceptor((com.sun.corba.ee.spi.orb.ORB)theOrb, (int)port, (String)host, (String)type) : TransportDefault.makeStandardCorbaAcceptor((com.sun.corba.ee.spi.orb.ORB)theOrb, (int)port, (String)host, (String)type);
        ctm.registerAcceptor(acceptor);
        return acceptor;
    }

    private String handleAddrAny(String hostAddr) {
        if (ANY_ADDRS.contains(hostAddr)) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException exc) {
                logger.log(Level.WARNING, "Unknown host exception : Setting host to localhost");
                return DEFAULT_ORB_INIT_HOST;
            }
        }
        return hostAddr;
    }

    private void createORBListeners(IIOPUtils iiopUtils, IiopListener[] iiopListenerBeans, ORB orb) {
        if (iiopListenerBeans != null) {
            int lazyCount = 0;
            for (IiopListener ilb : iiopListenerBeans) {
                boolean securityEnabled = Boolean.valueOf(ilb.getSecurityEnabled());
                boolean isLazy = Boolean.valueOf(ilb.getLazyInit());
                if (isLazy) {
                    ++lazyCount;
                }
                if (lazyCount > 1) {
                    throw new IllegalStateException("Invalid iiop-listener " + ilb.getId() + ". Only one iiop-listener can be configured " + "with lazy-init=true");
                }
                int port = Integer.valueOf(ilb.getPort());
                String host = this.handleAddrAny(ilb.getAddress());
                if (!securityEnabled || ilb.getSsl() == null) {
                    Acceptor acceptor = this.addAcceptor(orb, isLazy, host, IIOP_CLEAR_TEXT_CONNECTION, port);
                    if (!isLazy) continue;
                    this.lazyAcceptor = acceptor;
                    continue;
                }
                if (isLazy) {
                    throw new IllegalStateException("Invalid iiop-listener " + ilb.getId() + ". Lazy-init not supported for SSL iiop-listeners");
                }
                Ssl sslBean = ilb.getSsl();
                assert (sslBean != null);
                boolean clientAuth = Boolean.valueOf(sslBean.getClientAuthEnabled());
                String type = clientAuth ? SSL_MUTUALAUTH : SSL;
                this.addAcceptor(orb, isLazy, host, type, port);
            }
            if (lazyCount == 1) {
                this.getHelper().setSelectableChannelDelegate((GlassFishORBHelper.SelectableChannelDelegate)new AcceptorDelegateImpl(this.lazyAcceptor));
            }
        }
    }

    static {
        threadpoolMgr = null;
        txServiceInitialized = false;
        ANY_ADDRS = new HashSet<String>(Arrays.asList("0.0.0.0", "::", "::ffff:0.0.0.0"));
    }

    private static class AcceptorDelegateImpl
    implements GlassFishORBHelper.SelectableChannelDelegate {
        private Acceptor acceptor;

        AcceptorDelegateImpl(Acceptor lazyAcceptor) {
            this.acceptor = lazyAcceptor;
        }

        public void handleRequest(SelectableChannel channel) {
            SocketChannel sch = (SocketChannel)channel;
            Socket socket = sch.socket();
            this.acceptor.processSocket(socket);
        }
    }
}

