/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import com.sun.enterprise.transaction.TransactionSynchronizationRegistryImpl;
import com.sun.enterprise.transaction.UserTransactionImpl;
import com.sun.enterprise.transaction.spi.TransactionOperationsManager;
import com.sun.logging.LogDomains;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
@NamespacePrefixes(value={"java:comp/UserTransaction", "java:comp/TransactionSynchronizationRegistry", "java:appserver/TransactionManager", "java:appserver/TransactionSynchronizationRegistry"})
public class TransactionNamingProxy
implements NamedNamingObjectProxy {
    @Inject
    private Habitat habitat;
    @Inject
    private ExecutorService es;
    @Inject
    private ProcessEnvironment processEnv;
    private static Logger logger = LogDomains.getLogger(TransactionNamingProxy.class, (String)"javax.enterprise.resource.jta");
    static final String USER_TX = "java:comp/UserTransaction";
    static final String USER_TX_NO_JAVA_COMP = "UserTransaction";
    static final String TRANSACTION_SYNC_REGISTRY = "java:comp/TransactionSynchronizationRegistry";
    static final String APPSERVER_TRANSACTION_SYNC_REGISTRY = "java:appserver/TransactionSynchronizationRegistry";
    static final String TRANSACTION_MGR = "java:pm/TransactionManager";
    static final String APPSERVER_TRANSACTION_MGR = "java:appserver/TransactionManager";

    public Object handle(String name) throws NamingException {
        if (USER_TX.equals(name)) {
            this.checkUserTransactionLookupAllowed();
            return this.habitat.getComponent(UserTransactionImpl.class);
        }
        if (TRANSACTION_SYNC_REGISTRY.equals(name) || APPSERVER_TRANSACTION_SYNC_REGISTRY.equals(name)) {
            return this.habitat.getComponent(TransactionSynchronizationRegistryImpl.class);
        }
        if (APPSERVER_TRANSACTION_MGR.equals(name)) {
            return this.habitat.getComponent(TransactionManagerHelper.class);
        }
        return null;
    }

    private void checkUserTransactionLookupAllowed() throws NamingException {
        TransactionOperationsManager toMgr;
        ComponentInvocation inv;
        InvocationManager iv = (InvocationManager)this.habitat.getByContract(InvocationManager.class);
        if (iv != null && (inv = iv.getCurrentInvocation()) != null && (toMgr = (TransactionOperationsManager)inv.getTransactionOperationsManager()) != null) {
            toMgr.userTransactionLookupAllowed();
        }
    }
}

