/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
public class TransactionServiceConfigListener
implements ConfigListener,
PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(TransactionServiceConfigListener.class, (String)"javax.enterprise.resource.jta");
    @Inject(name="default-instance-name")
    private TransactionService ts;
    @Inject
    private Habitat habitat;
    private JavaEETransactionManager tm;
    private static StringManager sm = StringManager.getManager(TransactionServiceConfigListener.class);

    public void setTM(JavaEETransactionManager tm) {
        this.tm = tm;
    }

    public void postConstruct() {
        Config c = (Config)this.habitat.getComponent(Config.class, "default-instance-name");
        ModuleMonitoringLevels mml = c.getMonitoringService().getModuleMonitoringLevels();
        ((ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)mml)).addListener((ConfigListener)this);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unprocessedEvents = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent event : events) {
            String eventName = event.getPropertyName();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            boolean accepted = true;
            _logger.log(Level.FINE, "Got TransactionService change event ==== {0} {1} {2} {3}", new Object[]{event.getSource(), eventName, oldValue, newValue});
            if (oldValue != null && oldValue.equals(newValue)) {
                _logger.log(Level.FINE, "Event {0} did not change existing value of {1}", new Object[]{eventName, oldValue});
                continue;
            }
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                if (eventName.equals("transaction-service")) {
                    String newlevel = newValue.toString();
                    _logger.log(Level.FINE, "Changing transaction monitoring level");
                    if ("OFF".equals(newlevel)) {
                        this.tm.setMonitoringEnabled(false);
                    } else if ("LOW".equals(newlevel) || "HIGH".equals(newlevel)) {
                        this.tm.setMonitoringEnabled(true);
                    }
                }
            } else if (eventName.equals("timeout-in-seconds")) {
                try {
                    this.tm.setDefaultTransactionTimeout(Integer.parseInt((String)newValue, 10));
                    _logger.log(Level.FINE, " Transaction Timeout interval event processed for: {0}", newValue);
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "transaction.reconfig_txn_timeout_failed", ex);
                }
            } else if (eventName.equals("keypoint-interval") || eventName.equals("retry-timeout-in-seconds")) {
                this.tm.handlePropertyUpdate(eventName, newValue);
                _logger.log(Level.FINE, "{0} reconfig event processed for new value: {1}", new Object[]{eventName, newValue});
            } else if (event.getPropertyName().equals("value")) {
                eventName = ((Property)event.getSource()).getName();
                _logger.log(Level.FINE, "Got Property change event for {0}", eventName);
                if (eventName.equals("purge-cancelled-transactions-after")) {
                    String v = (String)newValue;
                    if (v == null || v.length() == 0) {
                        this.tm.setPurgeCancelledTtransactionsAfter(0);
                    } else {
                        this.tm.setPurgeCancelledTtransactionsAfter(Integer.parseInt(v, 10));
                    }
                } else {
                    accepted = false;
                }
            } else if (event.getPropertyName().equals("name") || event.getPropertyName().equals("property")) {
                _logger.log(Level.FINE, "...skipped");
            } else {
                accepted = false;
            }
            if (accepted) continue;
            String msg = sm.getString("enterprise_distributedtx.restart_required", (Object)eventName);
            _logger.log(Level.INFO, msg);
            unprocessedEvents.add(new UnprocessedChangeEvent(event, msg));
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }
}

