/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.Cache;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.transaction.TransactionServiceConfigListener;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionAdminBean;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.transaction.monitoring.TransactionServiceProbeProvider;
import com.sun.enterprise.transaction.monitoring.TransactionServiceStatsProvider;
import com.sun.enterprise.transaction.spi.JavaEETransactionManagerDelegate;
import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.ResourceHandler;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={TransactionManager.class, JavaEETransactionManager.class})
@Rank(value=50)
public class JavaEETransactionManagerSimplified
implements JavaEETransactionManager,
PostConstruct {
    protected Logger _logger = LogDomains.getLogger(JavaEETransactionManagerSimplified.class, (String)"javax.enterprise.resource.jta");
    @Inject
    private ServiceLocator habitat;
    @Inject
    protected InvocationManager invMgr;
    private JavaEETransactionManagerDelegate delegate;
    private static StringManager sm = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private ThreadLocal<JavaEETransaction> transactions;
    private ThreadLocal localCallCounter;
    private ThreadLocal<JavaEETransactionManagerDelegate> delegates;
    private boolean multipleEnlistDelists = false;
    private int transactionTimeout;
    private ThreadLocal<Integer> txnTmout = new ThreadLocal();
    private int purgeCancelledTtransactions = 0;
    private static final Hashtable statusMap = new Hashtable();
    private List activeTransactions = Collections.synchronizedList(new ArrayList());
    private boolean monitoringEnabled = false;
    private TransactionServiceProbeProvider monitor;
    private Hashtable txnTable = null;
    private Cache resourceTable;
    private Timer _timer = new Timer("transaction-manager", true);

    public JavaEETransactionManagerSimplified() {
        this.transactions = new ThreadLocal();
        this.localCallCounter = new ThreadLocal();
        this.delegates = new ThreadLocal();
    }

    public void postConstruct() {
        this.initDelegates();
        this.initProperties();
    }

    private void initProperties() {
        int maxEntries = 8192;
        float loadFactor = 0.75f;
        try {
            float f;
            String loadFactorValue;
            int temp;
            String maxEntriesValue;
            String mEnlistDelists = System.getProperty("ALLOW_MULTIPLE_ENLISTS_DELISTS");
            if ("true".equals(mEnlistDelists)) {
                this.multipleEnlistDelists = true;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "TM: multiple enlists, delists are enabled");
                }
            }
            if ((maxEntriesValue = System.getProperty("JTA_RESOURCE_TABLE_MAX_ENTRIES")) != null && (temp = Integer.parseInt(maxEntriesValue)) > 0) {
                maxEntries = temp;
            }
            if ((loadFactorValue = System.getProperty("JTA_RESOURCE_TABLE_DEFAULT_LOAD_FACTOR")) != null && (f = Float.parseFloat(loadFactorValue)) > 0.0f) {
                loadFactor = f;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.resourceTable = new BaseCache();
        ((BaseCache)this.resourceTable).init(maxEntries, loadFactor, null);
        if (this.habitat != null) {
            String level;
            ModuleMonitoringLevels levels;
            TransactionService txnService = (TransactionService)this.habitat.getService(TransactionService.class, "default-instance-name", new Annotation[0]);
            if (txnService != null) {
                this.transactionTimeout = Integer.parseInt(txnService.getTimeoutInSeconds());
                String v = txnService.getPropertyValue("purge-cancelled-transactions-after");
                if (v != null && v.length() > 0) {
                    this.purgeCancelledTtransactions = Integer.parseInt(v);
                }
                TransactionServiceConfigListener listener = (TransactionServiceConfigListener)this.habitat.getService(TransactionServiceConfigListener.class, new Annotation[0]);
                listener.setTM(this);
            }
            if ((levels = (ModuleMonitoringLevels)this.habitat.getService(ModuleMonitoringLevels.class, new Annotation[0])) != null && !"OFF".equals(level = levels.getTransactionService())) {
                this.monitoringEnabled = true;
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: Tx Timeout = " + this.transactionTimeout);
        }
        try {
            if (Boolean.getBoolean("MONITOR_JTA_RESOURCE_TABLE_STATISTICS")) {
                this.registerStatisticMonitorTask();
            }
            StatsProviderManager.register((String)"transaction-service", (PluginPoint)PluginPoint.SERVER, (String)"transaction-service", (Object)new TransactionServiceStatsProvider(this, this._logger));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.monitor = new TransactionServiceProbeProvider();
    }

    public void clearThreadTx() {
        this.setCurrentTransaction(null);
        this.delegates.set(null);
    }

    public String getTxLogLocation() {
        return this.getDelegate().getTxLogLocation();
    }

    public void registerRecoveryResourceHandler(XAResource xaResource) {
        this.getDelegate().registerRecoveryResourceHandler(xaResource);
    }

    public boolean isNullTransaction() {
        return this.getDelegate().isNullTransaction();
    }

    public void shutdown() {
        this._timer.cancel();
    }

    public void initRecovery(boolean force) {
        this.getDelegate().initRecovery(force);
    }

    public void recover(XAResource[] resourceList) {
        this.getDelegate().recover(resourceList);
    }

    public boolean enlistResource(Transaction tran, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        JavaEETransaction tx;
        if (!h.isTransactional()) {
            return true;
        }
        if (h.isEnlistmentSuspended()) {
            return false;
        }
        if (this.monitoringEnabled && (tx = this.getDelegate().getJavaEETransaction(tran)) != null) {
            ((JavaEETransactionImpl)tx).addResourceName(h.getName());
        }
        if (!(tran instanceof JavaEETransaction)) {
            return this.enlistXAResource(tran, h);
        }
        tx = (JavaEETransactionImpl)tran;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "\n\nIn JavaEETransactionManagerSimplified.enlistResource, h=" + h + " h.xares=" + h.getXAResource() + " tx=" + tx);
        }
        JavaEETransactionManagerDelegate d = this.setDelegate();
        boolean useLAO = d.useLAO();
        if (!(tx.getNonXAResource() == null || useLAO && h.supportsXA())) {
            boolean isSameRM = false;
            try {
                isSameRM = h.getXAResource().isSameRM(tx.getNonXAResource().getXAResource());
            }
            catch (XAException xex) {
                throw new SystemException(sm.getString("enterprise_distributedtx.samerm_excep", (Object)xex));
            }
            catch (Exception ex) {
                throw new SystemException(sm.getString("enterprise_distributedtx.samerm_excep", (Object)ex));
            }
            if (!isSameRM) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.already_has_nonxa"));
            }
        }
        if (h.supportsXA()) {
            if (!d.supportsXAResource()) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.xaresource_not_supported"));
            }
            if (tx.isLocalTx()) {
                d.enlistLAOResource((Transaction)tx, tx.getNonXAResource());
            }
            return this.enlistXAResource((Transaction)tx, h);
        }
        if (tx.isImportedTransaction()) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
        }
        if (tx.getNonXAResource() == null) {
            tx.setNonXAResource(h);
        }
        if (tx.isLocalTx()) {
            try {
                h.getXAResource().start(tx.getLocalXid(), 0);
            }
            catch (XAException ex) {
                throw new RuntimeException(sm.getString("enterprise_distributedtx.xaresource_start_excep"), ex);
            }
            h.enlistedInTransaction((Transaction)tx);
            return true;
        }
        return d.enlistDistributedNonXAResource((Transaction)tx, h);
    }

    public void unregisterComponentResource(TransactionalResource h) {
        Object instance = h.getComponentInstance();
        if (instance == null) {
            return;
        }
        h.setComponentInstance(null);
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        List l = this.getExistingResourceList(instance, inv);
        if (l != null) {
            l.remove(h);
        }
    }

    public void startJTSTx(JavaEETransaction t) throws RollbackException, IllegalStateException, SystemException {
        JavaEETransactionImpl tx = (JavaEETransactionImpl)t;
        TransactionInternal jtsTx = this.getDelegate().startJTSTx((JavaEETransaction)tx, tx.isAssociatedTimeout());
        if (this.monitoringEnabled && this.activeTransactions.remove(tx)) {
            this.monitor.transactionDeactivatedEvent();
        }
        tx.setJTSTx(jtsTx);
        jtsTx.registerSynchronization((Synchronization)new JTSSynchronization(jtsTx, this));
    }

    public List getResourceList(Object instance, ComponentInvocation inv) {
        if (inv == null) {
            return new ArrayList(0);
        }
        List l = null;
        ResourceHandler rh = inv.getResourceHandler();
        if (rh != null) {
            l = rh.getResourceList();
            if (l == null) {
                l = new ArrayList(0);
            }
        } else {
            Object key = this.getResourceTableKey(instance, inv);
            if (key == null) {
                return new ArrayList(0);
            }
            l = (List)this.resourceTable.get(key);
            if (l == null) {
                l = new ArrayList();
                this.resourceTable.put(key, l);
            }
        }
        return l;
    }

    public void enlistComponentResources() throws RemoteException {
        ComponentInvocation inv;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: enlistComponentResources");
        }
        if ((inv = this.invMgr.getCurrentInvocation()) == null) {
            return;
        }
        try {
            Transaction tran = this.getTransaction();
            inv.setTransaction((Object)((JavaEETransaction)tran));
            this.enlistComponentResources(inv);
        }
        catch (InvocationException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
            throw new RemoteException(ex.getMessage(), ex.getNestedException());
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    public boolean delistResource(Transaction tran, TransactionalResource h, int flag) throws IllegalStateException, SystemException {
        if (!h.isTransactional()) {
            return true;
        }
        if (!(tran instanceof JavaEETransaction)) {
            return this.delistJTSResource(tran, h, flag);
        }
        JavaEETransactionImpl tx = (JavaEETransactionImpl)tran;
        if (tx.isLocalTx()) {
            try {
                h.getXAResource().end(tx.getLocalXid(), flag);
            }
            catch (XAException ex) {
                throw new RuntimeException(sm.getString("enterprise_distributedtx.xaresource_end_excep", (Object)ex));
            }
            return true;
        }
        return this.delistJTSResource(tran, h, flag);
    }

    public void delistComponentResources(boolean suspend) throws RemoteException {
        ComponentInvocation inv;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: delistComponentResources");
        }
        if ((inv = this.invMgr.getCurrentInvocation()) == null) {
            return;
        }
        try {
            this.delistComponentResources(inv, suspend);
        }
        catch (InvocationException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
            throw new RemoteException("", ex.getNestedException());
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
            throw new RemoteException("", ex);
        }
    }

    public void registerComponentResource(TransactionalResource h) {
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        if (inv != null) {
            Object instance = inv.getInstance();
            if (instance == null) {
                return;
            }
            h.setComponentInstance(instance);
            List l = this.getResourceList(instance, inv);
            l.add(h);
        }
    }

    private JavaEETransactionImpl initJavaEETransaction(int timeout) {
        JavaEETransactionImpl tx = null;
        tx = timeout > 0 ? new JavaEETransactionImpl(timeout, (JavaEETransactionManager)this) : new JavaEETransactionImpl(this);
        this.setCurrentTransaction(tx);
        return tx;
    }

    public List getExistingResourceList(Object instance, ComponentInvocation inv) {
        if (inv == null) {
            return null;
        }
        List l = null;
        ResourceHandler rh = inv.getResourceHandler();
        if (rh != null) {
            l = rh.getResourceList();
        } else {
            Object key = this.getResourceTableKey(instance, inv);
            if (key != null) {
                l = (List)this.resourceTable.get(key);
            }
        }
        return l;
    }

    public void preInvoke(ComponentInvocation prev) throws InvocationException {
        if (prev != null && prev.getTransaction() != null && !prev.isTransactionCompleting()) {
            this.delistComponentResources(prev, true);
        }
    }

    public void postInvoke(ComponentInvocation curr, ComponentInvocation prev) throws InvocationException {
        if (curr != null && curr.getTransaction() != null) {
            this.delistComponentResources(curr, false);
        }
        if (prev != null && prev.getTransaction() != null && !prev.isTransactionCompleting()) {
            this.enlistComponentResources(prev);
        }
    }

    public void componentDestroyed(Object instance) {
        this.componentDestroyed(instance, null);
    }

    public void componentDestroyed(Object instance, ComponentInvocation inv) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: componentDestroyed" + instance);
            this._logger.log(Level.FINE, "TM: resourceTable before: " + this.resourceTable.getEntryCount());
        }
        List l = (List)this.resourceTable.remove(this.getResourceTableKey(instance, inv));
        this.processResourceList(l);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: resourceTable after: " + this.resourceTable.getEntryCount());
        }
    }

    public void componentDestroyed(ResourceHandler rh) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, " componentDestroyed: " + rh);
        }
        if (rh != null) {
            this.processResourceList(rh.getResourceList());
        }
    }

    public boolean isTimedOut() {
        JavaEETransaction tx = this.transactions.get();
        if (tx != null) {
            return tx.isTimedOut();
        }
        return false;
    }

    public void checkTransactionImport() {
        int[] count = (int[])this.localCallCounter.get();
        if (count != null && count[0] > 0) {
            count[0] = count[0] - 1;
            return;
        }
        this.clearThreadTx();
    }

    public void checkTransactionExport(boolean isLocal) {
        if (isLocal) {
            int[] count = (int[])this.localCallCounter.get();
            if (count == null) {
                count = new int[1];
                this.localCallCounter.set(count);
            }
            count[0] = count[0] + 1;
            return;
        }
        JavaEETransaction tx = this.transactions.get();
        if (tx == null) {
            return;
        }
        if (!tx.isLocalTx()) {
            return;
        }
        if (tx.getNonXAResource() != null) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.cannot_export_transaction_having_nonxa"));
        }
        try {
            this.startJTSTx(tx);
        }
        catch (RollbackException rlex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), rlex);
        }
        catch (IllegalStateException isex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), isex);
        }
        catch (SystemException ex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), ex);
        }
        catch (Exception excep) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), excep);
        }
    }

    public XATerminator getXATerminator() {
        return this.getDelegate().getXATerminator();
    }

    public void release(Xid xid) throws WorkException {
        this.getDelegate().release(xid);
    }

    public void recreate(Xid xid, long timeout) throws WorkException {
        this.getDelegate().recreate(xid, timeout);
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: registerSynchronization");
        }
        try {
            Transaction tran = this.getTransaction();
            if (tran != null) {
                tran.registerSynchronization(sync);
            }
        }
        catch (RollbackException ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.rollbackexcep_in_regsynch", ex);
            throw new IllegalStateException();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.getEffectiveTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void begin(int timeout) throws NotSupportedException, SystemException {
        if (this.transactions.get() != null) {
            throw new NotSupportedException(sm.getString("enterprise_distributedtx.notsupported_nested_transaction"));
        }
        this.setDelegate();
        if (this.getStatus() != 6) {
            throw new NotSupportedException(sm.getString("enterprise_distributedtx.notsupported_nested_transaction"));
        }
        if (this.monitoringEnabled) {
            this.getDelegate().getReadLock().lock();
            try {
                JavaEETransactionImpl tx = this.initJavaEETransaction(timeout);
                this.activeTransactions.add(tx);
                this.monitor.transactionActivatedEvent();
                ComponentInvocation inv = this.invMgr.getCurrentInvocation();
                if (inv == null || inv.getInstance() == null) return;
                tx.setComponentName(inv.getInstance().getClass().getName());
                return;
            }
            finally {
                this.getDelegate().getReadLock().unlock();
            }
        } else {
            this.initJavaEETransaction(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block10: {
            boolean acquiredlock = false;
            try {
                JavaEETransaction tx = this.transactions.get();
                if (tx != null && tx.isLocalTx()) {
                    if (this.monitoringEnabled) {
                        this.getDelegate().getReadLock().lock();
                        acquiredlock = true;
                    }
                    tx.commit();
                    break block10;
                }
                try {
                    this.getDelegate().commitDistributedTransaction();
                }
                finally {
                    if (tx != null) {
                        ((JavaEETransactionImpl)tx).onTxCompletion(true);
                    }
                }
            }
            finally {
                this.setCurrentTransaction(null);
                this.delegates.set(null);
                if (acquiredlock) {
                    this.getDelegate().getReadLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        block10: {
            boolean acquiredlock = false;
            try {
                JavaEETransaction tx = this.transactions.get();
                if (tx != null && tx.isLocalTx()) {
                    if (this.monitoringEnabled) {
                        this.getDelegate().getReadLock().lock();
                        acquiredlock = true;
                    }
                    tx.rollback();
                    break block10;
                }
                try {
                    this.getDelegate().rollbackDistributedTransaction();
                }
                finally {
                    if (tx != null) {
                        ((JavaEETransactionImpl)tx).onTxCompletion(false);
                    }
                }
            }
            finally {
                this.setCurrentTransaction(null);
                this.delegates.set(null);
                if (acquiredlock) {
                    this.getDelegate().getReadLock().unlock();
                }
            }
        }
    }

    public int getStatus() throws SystemException {
        return this.getDelegate().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.getDelegate().getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        JavaEETransaction tx = this.transactions.get();
        if (tx != null && tx.isLocalTx()) {
            if (this.monitoringEnabled) {
                this.getDelegate().getReadLock().lock();
                try {
                    tx.setRollbackOnly();
                }
                finally {
                    this.getDelegate().getReadLock().unlock();
                }
            } else {
                tx.setRollbackOnly();
            }
        } else {
            this.getDelegate().setRollbackOnlyDistributedTransaction();
        }
    }

    public Transaction suspend() throws SystemException {
        return this.getDelegate().suspend(this.transactions.get());
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        JavaEETransaction tx = this.transactions.get();
        if (tx != null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_exist_on_currentThread"));
        }
        if (tobj != null) {
            int status = tobj.getStatus();
            if (status == 4 || status == 3 || status == 6 || status == 5) {
                throw new InvalidTransactionException(sm.getString("enterprise_distributedtx.resume_invalid_transaction", (Object)tobj));
            }
        } else {
            throw new InvalidTransactionException(sm.getString("enterprise_distributedtx.resume_invalid_transaction", (Object)"null"));
        }
        if (tobj instanceof JavaEETransactionImpl) {
            JavaEETransactionImpl javaEETx = (JavaEETransactionImpl)tobj;
            if (!javaEETx.isLocalTx()) {
                this.getDelegate().resume((Transaction)javaEETx.getJTSTx());
            }
            this.setCurrentTransaction(javaEETx);
        } else {
            this.getDelegate().resume(tobj);
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new SystemException(sm.getString("enterprise_distributedtx.invalid_timeout"));
        }
        this.txnTmout.set(seconds);
    }

    public void setPurgeCancelledTtransactionsAfter(int num) {
        this.purgeCancelledTtransactions = num;
    }

    public int getPurgeCancelledTtransactionsAfter() {
        return this.purgeCancelledTtransactions;
    }

    public JavaEETransaction getCurrentTransaction() {
        return this.transactions.get();
    }

    public void setCurrentTransaction(JavaEETransaction t) {
        this.transactions.set(t);
    }

    public XAResourceWrapper getXAResourceWrapper(String clName) {
        return this.getDelegate().getXAResourceWrapper(clName);
    }

    public void handlePropertyUpdate(String name, Object value) {
        this.delegate.handlePropertyUpdate(name, value);
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath, XAResource[] xaresArray) throws Exception {
        return this.delegate.recoverIncompleteTx(delegated, logPath, xaresArray);
    }

    public synchronized void freeze() {
        this.getDelegate().acquireWriteLock();
        this.monitor.freezeEvent(true);
    }

    public synchronized void unfreeze() {
        this.getDelegate().releaseWriteLock();
        this.monitor.freezeEvent(false);
    }

    public boolean isFrozen() {
        return this.getDelegate().isWriteLocked();
    }

    public void cleanTxnTimeout() {
        this.txnTmout.set(null);
    }

    public int getEffectiveTimeout() {
        Integer tmout = this.txnTmout.get();
        if (tmout == null) {
            return this.transactionTimeout;
        }
        return tmout;
    }

    public void setDefaultTransactionTimeout(int seconds) {
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionTimeout = seconds;
    }

    public ArrayList getActiveTransactions() {
        ArrayList<TransactionAdminBean> tranBeans = new ArrayList<TransactionAdminBean>();
        this.txnTable = new Hashtable();
        Object[] activeCopy = this.activeTransactions.toArray();
        for (int i = 0; i < activeCopy.length; ++i) {
            try {
                Transaction tran = (Transaction)activeCopy[i];
                TransactionAdminBean tBean = this.getDelegate().getTransactionAdminBean(tran);
                if (tBean == null) {
                    this._logger.warning("enterprise_distributedtx.txbean_null" + tran);
                    continue;
                }
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "TM: Adding txnId " + tBean.getId() + " to txnTable");
                }
                this.txnTable.put(tBean.getId(), tran);
                tranBeans.add(tBean);
                continue;
            }
            catch (Exception ex) {
                this._logger.log(Level.SEVERE, "transaction.monitor.error_while_getting_monitor_attr", ex);
            }
        }
        return tranBeans;
    }

    public TransactionAdminBean getTransactionAdminBean(Transaction tran) throws SystemException {
        TransactionAdminBean tBean = null;
        if (tran instanceof JavaEETransaction) {
            JavaEETransactionImpl tran1 = (JavaEETransactionImpl)tran;
            String id = tran1.getTransactionId();
            long startTime = tran1.getStartTime();
            String componentName = tran1.getComponentName();
            ArrayList<String> resourceNames = tran1.getResourceNames();
            long elapsedTime = System.currentTimeMillis() - startTime;
            String status = JavaEETransactionManagerSimplified.getStatusAsString(tran.getStatus());
            tBean = new TransactionAdminBean((Object)tran, id, status, elapsedTime, componentName, resourceNames);
        }
        return tBean;
    }

    public void forceRollback(String txnId) throws IllegalStateException, SystemException {
        if (this.txnTable == null || this.txnTable.size() == 0) {
            this.getActiveTransactions();
        }
        if (this.txnTable == null || this.txnTable.get(txnId) == null) {
            String result = sm.getString("transaction.monitor.rollback_invalid_id");
            throw new IllegalStateException(result);
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: Marking txnId " + txnId + " for rollback");
        }
        ((Transaction)this.txnTable.get(txnId)).setRollbackOnly();
    }

    public void setMonitoringEnabled(boolean enabled) {
        this.monitoringEnabled = enabled;
        this.activeTransactions.clear();
    }

    private void _monitorTxCompleted(Object obj, boolean committed) {
        if (obj != null) {
            JavaEETransactionImpl t;
            if (obj instanceof JavaEETransactionImpl && !(t = (JavaEETransactionImpl)obj).isLocalTx()) {
                obj = t.getJTSTx();
            }
            if (this.activeTransactions.remove(obj)) {
                if (committed) {
                    this.monitor.transactionCommittedEvent();
                } else {
                    this.monitor.transactionRolledbackEvent();
                }
            }
        }
    }

    private void registerStatisticMonitorTask() {
        StatisticMonitorTask task = new StatisticMonitorTask();
        int statInterval = 120000;
        try {
            String interval = System.getProperty("MONITOR_JTA_RESOURCE_TABLE_SECONDS");
            int temp = Integer.parseInt(interval);
            if (temp > 0) {
                statInterval = temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._timer.scheduleAtFixedRate((TimerTask)task, 0L, (long)statInterval);
    }

    public static String getStatusAsString(int status) {
        return (String)statusMap.get(status);
    }

    private void delistComponentResources(ComponentInvocation inv, boolean suspend) throws InvocationException {
        try {
            Transaction tran = (Transaction)inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                List l = this.getExistingResourceList(inv.getInstance(), inv);
                if (l == null || l.size() == 0) {
                    return;
                }
                int flag = suspend ? 0x2000000 : 0x4000000;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    TransactionalResource h = (TransactionalResource)it.next();
                    try {
                        if (!h.isEnlisted()) continue;
                        this.delistResource(tran, h, flag);
                    }
                    catch (IllegalStateException ex) {
                        if (!this._logger.isLoggable(Level.FINE)) continue;
                        this._logger.log(Level.FINE, "TM: Exception in delistResource", ex);
                    }
                    catch (Exception ex) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.log(Level.FINE, "TM: Exception in delistResource", ex);
                        }
                        it.remove();
                        this.handleResourceError(h, ex, tran);
                    }
                }
            }
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_delist", ex);
        }
    }

    protected boolean enlistXAResource(Transaction tran, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: enlistResource");
        }
        if (this.resourceEnlistable(h)) {
            XAResource res = h.getXAResource();
            boolean result = tran.enlistResource(res);
            if (!h.isEnlisted()) {
                h.enlistedInTransaction(tran);
            }
            return result;
        }
        return true;
    }

    private void enlistComponentResources(ComponentInvocation inv) throws InvocationException {
        try {
            Transaction tran = (Transaction)inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                List l = this.getExistingResourceList(inv.getInstance(), inv);
                if (l == null || l.size() == 0) {
                    return;
                }
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    TransactionalResource h = (TransactionalResource)it.next();
                    try {
                        this.enlistResource(tran, h);
                    }
                    catch (Exception ex) {
                        it.remove();
                        this.handleResourceError(h, ex, tran);
                    }
                }
            }
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_enlist", ex);
        }
    }

    private void processResourceList(List l) {
        if (l != null && l.size() > 0) {
            for (TransactionalResource h : l) {
                try {
                    h.closeUserConnection();
                }
                catch (Exception ex) {
                    if (!this._logger.isLoggable(Level.FINE)) continue;
                    this._logger.log(Level.WARNING, "enterprise_distributedtx.pooling_excep", ex);
                }
            }
            l.clear();
        }
    }

    private void handleResourceError(TransactionalResource h, Exception ex, Transaction tran) {
        if (this._logger.isLoggable(Level.FINE) && h.isTransactional()) {
            this._logger.log(Level.FINE, "TM: HandleResourceError " + h.getXAResource() + "," + ex);
        }
        try {
            if (tran != null && h.isTransactional() && h.isEnlisted()) {
                tran.delistResource(h.getXAResource(), 0x4000000);
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        if (ex instanceof RollbackException) {
            return;
        }
        if (ex instanceof IllegalStateException) {
            try {
                h.closeUserConnection();
            }
            catch (Exception ex2) {}
        } else {
            try {
                h.destroyResource();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    private Object getResourceTableKey(Object instance, ComponentInvocation inv) {
        Object key = null;
        if (inv != null) {
            key = inv.getResourceTableKey();
        }
        if (key == null) {
            key = instance;
        }
        return key;
    }

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    private boolean delistJTSResource(Transaction tran, TransactionalResource h, int flag) throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: delistResource");
        }
        if (!h.isShareable() || this.multipleEnlistDelists) {
            if (h.isTransactional() && h.isEnlisted()) {
                return tran.delistResource(h.getXAResource(), flag);
            }
            return true;
        }
        return true;
    }

    private void remove(Transaction tx) {
        this.getDelegate().removeTransaction(tx);
    }

    JavaEETransactionManagerDelegate getDelegate() {
        JavaEETransactionManagerDelegate d = this.delegates.get();
        return d == null ? this.delegate : d;
    }

    private JavaEETransactionManagerDelegate setDelegate() {
        JavaEETransactionManagerDelegate d = this.delegates.get();
        if (d == null) {
            d = this.delegate;
            this.delegates.set(d);
        }
        return d;
    }

    public boolean isDelegate(JavaEETransactionManagerDelegate d) {
        if (this.delegate == null) {
            return false;
        }
        return d.getClass().getName().equals(this.delegate.getClass().getName());
    }

    private void initDelegates() {
        if (this.habitat == null) {
            return;
        }
        for (JavaEETransactionManagerDelegate d : this.habitat.getAllServices(JavaEETransactionManagerDelegate.class, new Annotation[0])) {
            this.setDelegate(d);
        }
        if (this.delegate != null && this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.INFO, "enterprise_used_delegate_name", this.delegate.getClass().getName());
        }
    }

    public synchronized void setDelegate(JavaEETransactionManagerDelegate d) {
        int curr = 0;
        if (this.delegate != null) {
            curr = this.delegate.getOrder();
        }
        if (d.getOrder() > curr) {
            this.delegate = d;
            this.delegate.setTransactionManager((JavaEETransactionManager)this);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Replaced delegate with " + d.getClass().getName());
            }
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void monitorTxCompleted(Object obj, boolean b) {
        if (this.monitoringEnabled) {
            this._monitorTxCompleted(obj, b);
        }
    }

    public void monitorTxBegin(Transaction tx) {
        if (this.monitoringEnabled) {
            this.activeTransactions.add(tx);
            this.monitor.transactionActivatedEvent();
        }
    }

    public boolean resourceEnlistable(TransactionalResource h) {
        return h.isTransactional() && (!h.isEnlisted() || !h.isShareable() || this.multipleEnlistDelists);
    }

    public boolean isInvocationStackEmpty() {
        return this.invMgr == null || this.invMgr.isInvocationStackEmpty();
    }

    public void setTransactionCompeting(boolean b) {
        ComponentInvocation curr = this.invMgr.getCurrentInvocation();
        if (curr != null) {
            curr.setTransactionCompeting(b);
        }
    }

    public JavaEETransaction createImportedTransaction(TransactionInternal jtsTx) throws SystemException {
        JavaEETransactionImpl tx = new JavaEETransactionImpl(jtsTx, (JavaEETransactionManager)this);
        try {
            jtsTx.registerSynchronization((Synchronization)new JTSSynchronization(jtsTx, this));
        }
        catch (RollbackException rlex) {
            throw new SystemException(rlex.toString());
        }
        catch (IllegalStateException isex) {
            throw new SystemException(isex.toString());
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
        return tx;
    }

    static {
        statusMap.put(0, "Active");
        statusMap.put(1, "MarkedRollback");
        statusMap.put(2, "Prepared");
        statusMap.put(3, "Committed");
        statusMap.put(4, "RolledBack");
        statusMap.put(5, "UnKnown");
        statusMap.put(6, "NoTransaction");
        statusMap.put(7, "Preparing");
        statusMap.put(8, "Committing");
        statusMap.put(9, "RollingBack");
    }

    private static class JTSSynchronization
    implements Synchronization {
        private TransactionInternal jtsTx;
        private JavaEETransactionManagerSimplified javaEETM;

        JTSSynchronization(TransactionInternal jtsTx, JavaEETransactionManagerSimplified javaEETM) {
            this.jtsTx = jtsTx;
            this.javaEETM = javaEETM;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.javaEETM.remove((Transaction)this.jtsTx);
        }
    }

    class StatisticMonitorTask
    extends TimerTask {
        StatisticMonitorTask() {
        }

        @Override
        public void run() {
            if (JavaEETransactionManagerSimplified.this.resourceTable != null) {
                Map stats = JavaEETransactionManagerSimplified.this.resourceTable.getStats();
                Iterator it = stats.entrySet().iterator();
                JavaEETransactionManagerSimplified.this._logger.log(Level.INFO, "********** JavaEETransactionManager resourceTable stats *****");
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    JavaEETransactionManagerSimplified.this._logger.log(Level.INFO, (String)entry.getKey() + ": " + entry.getValue());
                }
            }
        }
    }
}

