/* 
 *  DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *  
 *  Copyright (c) 2007-2010 Oracle and/or its affiliates. All rights reserved.
 *  
 *  The contents of this file are subject to the terms of either the GNU
 *  General Public License Version 2 only ("GPL") or the Common Development
 *  and Distribution License("CDDL") (collectively, the "License").  You
 *  may not use this file except in compliance with the License.  You can
 *  obtain a copy of the License at
 *  https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 *  or packager/legal/LICENSE.txt.  See the License for the specific
 *  language governing permissions and limitations under the License.
 *  
 *  When distributing the software, include this License Header Notice in each
 *  file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 *  
 *  GPL Classpath Exception:
 *  Oracle designates this particular file as subject to the "Classpath"
 *  exception as provided by Oracle in the GPL Version 2 section of the License
 *  file that accompanied this code.
 *  
 *  Modifications:
 *  If applicable, add the following below the License Header, with the fields
 *  enclosed by brackets [] replaced by your own identifying information:
 *  "Portions Copyright [year] [name of copyright owner]"
 *  
 *  Contributor(s):
 *  If you wish your version of this file to be governed by only the CDDL or
 *  only the GPL Version 2, indicate your decision by adding "[Contributor]
 *  elects to include this software in this distribution under the [CDDL or GPL
 *  Version 2] license."  If you don't indicate a single choice of license, a
 *  recipient has the option to distribute your version of this file under
 *  either the CDDL, the GPL Version 2 or to extend the choice of license to
 *  its licensees as provided above.  However, if you add GPL Version 2 code
 *  and therefore, elected the GPL Version 2 license, then the option applies
 *  only if the new code is made subject to such option by the copyright
 *  holder.
 */ 

package org.glassfish.gmbal;

import java.util.Map;
import org.glassfish.external.amx.AMX;


/** Base interface supported by all AMXMBeanInterface MBeans.  All MBeans generated by
 * gmbal comply with this interface, which means that the attributes and
 * operations defined in this Java interface all appear in each
 * MBean generated by calling ManagedObjectManager.register.
 *
 * @author LLoyd Chambers
 * @author Ken Cavanaugh
 *
 */
@ManagedObject
@Description( "Base interface for any MBean that works in the AMX framework" )
public interface AMXMBeanInterface {
    /** Get all metadata about this MBean.
     * @return The descriptor, which will be a ModelMBeanInfoSupport instance.
     */
    public Map<String,?> getMeta();

    /** Usually the same as the ObjectName 'name' property, but can differ
        if the actual name contains characters that must be escaped for an ObjectName and/or
        if the MBean has a mutable name attribute.
       The type property can be obtained from the ObjectName */
    @ManagedAttribute( id=AMX.ATTR_NAME )
    @Description( "Return the name of this MBean.")
    public String getName();

    /** "go up one level": the MBean containing this one, can be null for root
     * @return The container of this MBean (null if already at root).
     */
    @ManagedAttribute( id=AMX.ATTR_PARENT )
    @Description( "The container that contains this MBean" )
    public AMXMBeanInterface getParent();

    /** Containment hierarchy:
        Get all AMXMBeanInterface contained by this one, in no particular order.
        Valid only if isContainer().
     * Note that using an array sidesteps Map/Set/OpenType issues
     * @return All children of this AMXMBeanInterface MBean.
     */
    @ManagedAttribute( id=AMX.ATTR_CHILDREN )
    @Description( "All children of this AMX MBean")
    public AMXMBeanInterface[] getChildren();
}
