/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2000-2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * @(#)PurgeDurableHandler.java	1.10 07/12/07
 */ 

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;

public class PurgeDurableHandler extends AdminCmdHandler
{

    private static boolean DEBUG = getDEBUG();

    public PurgeDurableHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.INFO, this.getClass().getName() + ": " +
                "PurgeDurable: " + cmd_props);
        }

        int status = Status.OK;
        String errMsg = null;

	String durable = (String)cmd_props.get(MessageType.JMQ_DURABLE_NAME);
	String clientID = (String)cmd_props.get(MessageType.JMQ_CLIENT_ID);
        try {
            if (clientID != null && clientID.trim().length() == 0) {
                throw new BrokerException(
                    rb.getKString(rb.X_INVALID_CLIENTID, clientID),
                    Status.BAD_REQUEST);
            }
            HAMonitorService hamonitor = Globals.getHAMonitorService(); 
            if (hamonitor != null && hamonitor.inTakeover()) {
                status = Status.UNAVAILABLE;
                errMsg =  rb.getString(rb.E_CANNOT_PROCEED_TAKEOVER_IN_PROCESS);
                logger.log(Logger.WARNING, this.getClass().getName() + ": " + errMsg);
	    } else  {
                Subscription sub = Subscription.findDurableSubscription(clientID, durable);
                if (sub == null) {
                    errMsg = rb.getKString(rb.X_DURA_SUB_NOT_FOUND, 
                             Subscription.getDSubLogString(clientID, durable));
                    status = Status.NOT_FOUND;
                } else {
                    sub.purge();
                }
            }
        } catch (BrokerException ex) {
            status = ex.getStatusCode();
            errMsg = getMessageFromException(ex);
            if (status == Status.BAD_REQUEST ||
                status == Status.NOT_FOUND ||
                status == Status.UNAVAILABLE) {
                logger.log(logger.ERROR, errMsg);
            } else {
                logger.logStack(logger.ERROR, ex.getMessage(), ex);
            }
        }

	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, MessageType.PURGE_DURABLE_REPLY, status, errMsg);
	parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}
