/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011-2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.messaging.jms;

import javax.jms.InvalidClientIDException;
import com.sun.messaging.jmq.jmsclient.logging.Loggable;

/**
 * <P>
 * This class is the MQ-specific implementation of
 * javax.jms.InvalidClientIDRuntimeException and adds the methods setLogState
 * and getlogState
 **/
public class MQInvalidClientIDRuntimeException extends javax.jms.InvalidClientIDRuntimeException implements Loggable {

	private boolean isLogged = false;

	/**
	 * Constructs a <code>MQInvalidClientIDRuntimeException</code> with the specified detail message
	 * 
	 * @param detailMessage
	 *            a description of the exception
	 **/
	public MQInvalidClientIDRuntimeException(String detailMessage) {
		super(detailMessage);
	}
	
	/**
	 * Constructs a <code>MQInvalidClientIDRuntimeException</code> with the specified detail message
	 * and error code.
	 * 
	 * @param detailMessage
	 *            a description of the exception
	 * @param errorCode
	 *            a provider-specific error code
	 **/
	public MQInvalidClientIDRuntimeException(String detailMessage, String errorCode) {
		super(detailMessage,errorCode);
	}

	/**
	 * Constructs a <code>MQInvalidClientIDRuntimeException</code> with the specified detail message,
	 * error code and cause
	 * 
	 * @param detailMessage
	 *            a description of the exception
	 * @param errorCode
	 *            a provider-specific error code
	 * @param cause
	 *            the underlying cause of this exception
	 */
	public MQInvalidClientIDRuntimeException(String detailMessage, String errorCode, Throwable cause) {
		super(detailMessage, errorCode, cause);
	}
	
	/**
	 * Construct a <code>MQInvalidClientIDRuntimeException</code> to wrap the
	 * specified InvalidClientIDException
	 * 
	 * @param cause the underlying cause of this exception
	 */
	public MQInvalidClientIDRuntimeException(InvalidClientIDException cause) {
		super(cause.getMessage(), cause.getErrorCode(), cause);
	}
	
	/**
	 * Specify whether this object is logged.
	 * 
	 * @param whether this object is logged
	 */
	public void setLogState(boolean state) {
		this.isLogged = state;
	}

	/**
	 * return whether this object is logged
	 * 
	 * @return whether this object is logged
	 */
	public boolean getLogState() {
		return this.isLogged;
	}
}
