/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.reflection;

import java.io.OptionalDataException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Optional;
import java.util.stream.Stream;
import org.glassfish.pfl.basic.reflection.BridgeBase;
import org.glassfish.pfl.basic.reflection.BridgePermission;
import sun.reflect.ReflectionFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Bridge
extends BridgeBase {
    private static final Permission GET_BRIDGE_PERMISSION = new BridgePermission("getBridge");
    private static Bridge bridge = null;
    private final ReflectionFactory reflectionFactory;
    private final StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    private Bridge() {
        this.reflectionFactory = ReflectionFactory.getReflectionFactory();
    }

    public static synchronized Bridge get() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GET_BRIDGE_PERMISSION);
        }
        if (bridge == null) {
            bridge = new Bridge();
        }
        return bridge;
    }

    @Override
    public final ClassLoader getLatestUserDefinedLoader() {
        PrivilegedAction<ClassLoader> privilegedAction = () -> this.stackWalker.walk(this::getLatestUserDefinedLoaderFrame).map(stackFrame -> stackFrame.getDeclaringClass().getClassLoader()).orElseGet(ClassLoader::getPlatformClassLoader);
        return AccessController.doPrivileged(privilegedAction);
    }

    private Optional<StackWalker.StackFrame> getLatestUserDefinedLoaderFrame(Stream<StackWalker.StackFrame> stream) {
        return stream.filter(this::isUserLoader).findFirst();
    }

    private boolean isUserLoader(StackWalker.StackFrame stackFrame) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = stackFrame.getDeclaringClass().getClassLoader();
        if (classLoader2 == null) {
            return false;
        }
        for (classLoader = ClassLoader.getPlatformClassLoader(); classLoader != null && classLoader2 != classLoader; classLoader = classLoader.getParent()) {
        }
        return classLoader2 != classLoader;
    }

    public final <T> Constructor<T> newConstructorForExternalization(Class<T> clazz) {
        return this.reflectionFactory.newConstructorForExternalization(clazz);
    }

    @Override
    public final <T> Constructor<T> newConstructorForSerialization(Class<T> clazz, Constructor<?> constructor) {
        return this.reflectionFactory.newConstructorForSerialization(clazz, constructor);
    }

    @Override
    public <T> Constructor<T> newConstructorForSerialization(Class<T> clazz) {
        return this.reflectionFactory.newConstructorForSerialization(clazz);
    }

    @Override
    public final boolean hasStaticInitializerForSerialization(Class<?> clazz) {
        return this.reflectionFactory.hasStaticInitializerForSerialization(clazz);
    }

    @Override
    public final MethodHandle writeObjectForSerialization(Class<?> clazz) {
        return this.reflectionFactory.writeObjectForSerialization(clazz);
    }

    @Override
    public final MethodHandle readObjectForSerialization(Class<?> clazz) {
        return this.reflectionFactory.readObjectForSerialization(clazz);
    }

    public final MethodHandle readObjectNoDataForSerialization(Class<?> clazz) {
        return this.reflectionFactory.readObjectNoDataForSerialization(clazz);
    }

    @Override
    public final MethodHandle readResolveForSerialization(Class<?> clazz) {
        return this.reflectionFactory.readResolveForSerialization(clazz);
    }

    @Override
    public final MethodHandle writeReplaceForSerialization(Class<?> clazz) {
        return this.reflectionFactory.writeReplaceForSerialization(clazz);
    }

    @Override
    public final OptionalDataException newOptionalDataExceptionForSerialization(boolean bl) {
        return this.reflectionFactory.newOptionalDataExceptionForSerialization(bl);
    }
}

