/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.pfl.dynamic.codegen.impl.MemberInfoBase;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.spi.ClassInfo;
import org.glassfish.pfl.dynamic.codegen.spi.MethodInfo;
import org.glassfish.pfl.dynamic.codegen.spi.Signature;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;

public abstract class MethodInfoBase
extends MemberInfoBase
implements MethodInfo {
    protected Type rtype;
    protected List<Type> exceptions;
    protected List<Variable> arguments;
    protected boolean isConstructor;
    private Signature sig;
    private boolean sigIsCached;
    private int hashValue;
    private boolean hashIsCached;

    protected MethodInfoBase(ClassInfo cinfo, int modifiers) {
        this(cinfo, modifiers, Type._void(), "<init>");
        this.isConstructor = true;
    }

    protected MethodInfoBase(ClassInfo cinfo, int modifiers, Type rtype, String name) {
        super(cinfo, modifiers, name);
        this.rtype = rtype;
        this.exceptions = new ArrayList<Type>();
        this.arguments = new ArrayList<Variable>();
        this.sig = null;
        this.sigIsCached = false;
        this.hashValue = 0;
        this.hashIsCached = false;
        this.isConstructor = false;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    public Type returnType() {
        return this.rtype;
    }

    @Override
    public List<Type> exceptions() {
        return this.exceptions;
    }

    @Override
    public List<Variable> arguments() {
        return this.arguments;
    }

    @Override
    public synchronized Signature signature() {
        if (!this.sigIsCached) {
            ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
            for (Variable var : this.arguments) {
                argTypes.add(((VariableInternal)var).type());
            }
            this.sig = Signature.make(this.rtype, argTypes);
        }
        return this.sig;
    }

    @Override
    public Method getMethod() {
        return null;
    }

    @Override
    public Constructor getConstructor() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)MethodInfo.class.cast(obj);
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.signature().equals(other.signature())) {
            return false;
        }
        return ((Object)this.exceptions()).equals(other.exceptions());
    }

    public synchronized void clearHashCode() {
        this.hashIsCached = false;
        this.hashValue = 0;
    }

    @Override
    public synchronized int hashCode() {
        if (!this.hashIsCached) {
            this.hashValue = super.hashCode();
            this.hashValue ^= this.signature().hashCode();
            this.hashValue ^= ((Object)this.exceptions()).hashCode();
            this.hashIsCached = true;
        }
        return this.hashValue;
    }
}

