/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.copyobject.impl;

import java.util.Map;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopier;
import org.glassfish.pfl.dynamic.copyobject.impl.Exceptions;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;

public abstract class ClassCopierBase
implements ClassCopier {
    private String name;
    private boolean isReflective;

    protected ClassCopierBase(String name) {
        this(name, false);
    }

    protected ClassCopierBase(String name, boolean isReflective) {
        this.name = name;
        this.isReflective = isReflective;
    }

    public final String toString() {
        return "ClassCopier[" + this.name + "]";
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassCopierBase)) {
            return false;
        }
        ClassCopierBase other = (ClassCopierBase)obj;
        return this.name.equals(other.name) && this.isReflective == other.isReflective;
    }

    @Override
    public final Object copy(Map<Object, Object> oldToNew, Object source) throws ReflectiveCopyException {
        Object result = oldToNew.get(source);
        if (result == null) {
            try {
                result = this.createCopy(source);
                oldToNew.put(source, result);
                result = this.doCopy(oldToNew, source, result);
            }
            catch (StackOverflowError ex) {
                throw Exceptions.self.stackOverflow(source, ex);
            }
        }
        return result;
    }

    @Override
    public boolean isReflectiveClassCopier() {
        return this.isReflective;
    }

    protected abstract Object createCopy(Object var1) throws ReflectiveCopyException;

    protected Object doCopy(Map<Object, Object> oldToNew, Object source, Object result) throws ReflectiveCopyException {
        return result;
    }
}

