/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientContainer;
import javax.websocket.ClientEndpointConfiguration;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.DefaultClientEndpointConfiguration;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.TyrusContainerProvider;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ClientManager
implements ClientContainer {
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.grizzly.GrizzlyEngine";
    private final Set<TyrusClientSocket> sockets = new HashSet<TyrusClientSocket>();
    private final TyrusContainer engine;

    public static ClientManager createClient() {
        return ClientManager.createClient(ENGINE_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(String engineProviderClassname) {
        try {
            Class<?> engineProviderClazz = Class.forName(engineProviderClassname);
            Logger.getLogger(ClientManager.class.getName()).info("Provider class loaded: " + engineProviderClassname);
            ClientManager cm = new ClientManager((TyrusContainer)engineProviderClazz.newInstance());
            TyrusContainerProvider.getClientProvider().setContainer((Object)cm);
            return cm;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load provider class: " + engineProviderClassname + ".");
        }
    }

    private ClientManager(TyrusContainer engine) {
        this.engine = engine;
    }

    public void connectToServer(Object endpoint, URI uri) throws DeploymentException {
        this.connectToServer(endpoint, uri.toString());
    }

    public void connectToServer(Object o, String url) throws DeploymentException {
        Endpoint endpoint;
        if (o instanceof Endpoint) {
            endpoint = (Endpoint)o;
        } else {
            endpoint = AnnotatedEndpoint.fromInstance((Object)o);
            if (endpoint == null) {
                throw new DeploymentException(o.getClass().getName() + " is not a valid client endpoint.");
            }
        }
        try {
            EndpointWrapper clientEndpoint = new EndpointWrapper(endpoint, (ClientContainer)this, null);
            ClientEndpointConfiguration config = (ClientEndpointConfiguration)endpoint.getEndpointConfiguration();
            if (config == null) {
                config = new DefaultClientEndpointConfiguration.Builder().build();
            }
            TyrusClientSocket clientSocket = this.engine.openClientSocket(url, config, (SPIEndpoint)clientEndpoint);
            this.sockets.add(clientSocket);
        }
        catch (Exception e) {
            throw new DeploymentException("Connection failed.", (Throwable)e);
        }
    }

    public Set<Session> getActiveSessions() {
        return null;
    }

    public long getMaxSessionIdleTimeout() {
        return 0L;
    }

    public void setMaxSessionIdleTimeout(long timeout) {
    }

    public long getMaxBinaryMessageBufferSize() {
        return 0L;
    }

    public void setMaxBinaryMessageBufferSize(long max) {
    }

    public long getMaxTextMessageBufferSize() {
        return 0L;
    }

    public void setMaxTextMessageBufferSize(long max) {
    }

    public Set<String> getInstalledExtensions() {
        return null;
    }
}

