/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.TyrusServletFilter;
import org.glassfish.tyrus.spi.WebSocketEngine;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class TyrusServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletContainerInitializer.class.getName());
    private static final Set<Class<?>> FILTERED_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(TyrusServerConfiguration.class);
        }
    };

    public void onStartup(Set<Class<?>> classes, final ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        classes.removeAll(FILTERED_CLASSES);
        TyrusServerContainer serverContainer = new TyrusServerContainer(classes){
            private final WebSocketEngine engine;
            {
                super(x0);
                this.engine = new TyrusWebSocketEngine((WebSocketContainer)this);
            }

            public void register(Class<?> endpointClass) throws DeploymentException {
                this.engine.register(endpointClass, ctx.getContextPath());
            }

            public void register(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
                this.engine.register(serverEndpointConfig, ctx.getContextPath());
            }

            public WebSocketEngine getWebSocketEngine() {
                return this.engine;
            }
        };
        ctx.setAttribute(ServerContainer.class.getName(), (Object)serverContainer);
        TyrusServletFilter filter = new TyrusServletFilter((TyrusWebSocketEngine)serverContainer.getWebSocketEngine());
        ctx.addListener((EventListener)((Object)filter));
        FilterRegistration.Dynamic reg = ctx.addFilter("WebSocket filter", (Filter)filter);
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        LOGGER.info("Registering WebSocket filter for url pattern /*");
    }
}

