/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.util.Collections;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfiguration;

public abstract class DefaultEndpointConfiguration
implements EndpointConfiguration {
    private final List<Encoder> encoders;
    private final List<Decoder> decoders;
    protected final List<String> subProtocols;
    protected final List<String> extensions;

    protected DefaultEndpointConfiguration(List<Encoder> encoders, List<Decoder> decoders, List<String> subprotocols, List<String> extensions) {
        List emptyList;
        if (encoders != null) {
            this.encoders = Collections.unmodifiableList(encoders);
        } else {
            emptyList = Collections.emptyList();
            this.encoders = Collections.unmodifiableList(emptyList);
        }
        if (decoders != null) {
            this.decoders = Collections.unmodifiableList(decoders);
        } else {
            emptyList = Collections.emptyList();
            this.decoders = Collections.unmodifiableList(emptyList);
        }
        this.subProtocols = subprotocols != null ? Collections.unmodifiableList(subprotocols) : Collections.emptyList();
        this.extensions = extensions != null ? Collections.unmodifiableList(extensions) : Collections.emptyList();
    }

    public List<Encoder> getEncoders() {
        return this.encoders;
    }

    public List<Decoder> getDecoders() {
        return this.decoders;
    }

    protected static abstract class Builder<T extends Builder> {
        protected List<Encoder> encoders;
        protected List<Decoder> decoders;
        protected List<String> protocols;
        protected List<String> extensions;

        protected Builder() {
        }

        public final T encoders(List<Encoder> encoders) {
            this.encoders = encoders;
            return (T)this;
        }

        public final T decoders(List<Decoder> decoders) {
            this.decoders = decoders;
            return (T)this;
        }

        public T protocols(List<String> protocols) {
            this.protocols = protocols;
            return (T)this;
        }

        public T extensions(List<String> extensions) {
            this.extensions = extensions;
            return (T)this;
        }

        public abstract DefaultEndpointConfiguration build();
    }
}

