/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.HandshakeRequest;
import javax.websocket.HandshakeResponse;
import javax.websocket.ServerEndpointConfiguration;
import org.glassfish.tyrus.DefaultEndpointConfiguration;

public class DefaultServerEndpointConfiguration
extends DefaultEndpointConfiguration
implements ServerEndpointConfiguration {
    private final List<String> origins;
    private final String uri;

    protected DefaultServerEndpointConfiguration(String uri, List<Encoder> encoders, List<Decoder> decoders, List<String> subprotocols, List<String> extensions, List<String> origins) {
        super(encoders, decoders, subprotocols, extensions);
        this.uri = uri;
        this.origins = origins == null ? Collections.emptyList() : Collections.unmodifiableList(origins);
    }

    public String getNegotiatedSubprotocol(List<String> requestedSubprotocols) {
        for (String serverProtocol : this.subProtocols) {
            if (!requestedSubprotocols.contains(serverProtocol)) continue;
            return serverProtocol;
        }
        return null;
    }

    public List<String> getNegotiatedExtensions(List<String> requestedExtensions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String requestedExtension : requestedExtensions) {
            for (String extension : this.extensions) {
                if (!extension.equals(requestedExtension)) continue;
                result.add(requestedExtension);
            }
        }
        return result;
    }

    public boolean checkOrigin(String originHeaderValue) {
        return this.origins.isEmpty() || this.origins.contains(originHeaderValue);
    }

    public boolean matchesURI(URI uri) {
        throw new UnsupportedOperationException();
    }

    public void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }

    public String getPath() {
        return this.uri;
    }

    public static class Builder
    extends DefaultEndpointConfiguration.Builder<Builder> {
        private List<String> origins;
        private final String uri;

        public Builder(String uri) {
            this.uri = uri;
        }

        public Builder origins(List<String> origins) {
            this.origins = origins;
            return this;
        }

        @Override
        public DefaultServerEndpointConfiguration build() {
            return new DefaultServerEndpointConfiguration(this.uri, this.encoders, this.decoders, this.protocols, this.extensions, this.origins);
        }
    }
}

