/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.glassfish.tyrus.DecoderWrapper;
import org.glassfish.tyrus.ReflectionHelper;

public abstract class PrimitiveDecoders<T>
implements Decoder.Text<T> {
    public static final List<Decoder.Text<?>> ALL;
    public static final List<DecoderWrapper> ALL_WRAPPED;

    public boolean willDecode(String s) {
        return true;
    }

    private static List<DecoderWrapper> getWrappedAll() {
        ArrayList<DecoderWrapper> result = new ArrayList<DecoderWrapper>();
        for (Decoder.Text<?> dec : ALL) {
            Class<?> type = ReflectionHelper.getClassType(dec.getClass(), Decoder.Text.class);
            result.add(new DecoderWrapper((Decoder)dec, type, dec.getClass()));
        }
        return result;
    }

    static {
        Decoder.Text[] decoders = new Decoder.Text[]{new PrimitiveDecoders<Boolean>(){

            public Boolean decode(String s) throws DecodeException {
                return Boolean.valueOf(s);
            }
        }, new PrimitiveDecoders<Byte>(){

            public Byte decode(String s) throws DecodeException {
                return Byte.valueOf(s);
            }
        }, new PrimitiveDecoders<Character>(){

            public Character decode(String s) throws DecodeException {
                return Character.valueOf(s.charAt(0));
            }
        }, new PrimitiveDecoders<Double>(){

            public Double decode(String s) throws DecodeException {
                return Double.valueOf(s);
            }
        }, new PrimitiveDecoders<Float>(){

            public Float decode(String s) throws DecodeException {
                return Float.valueOf(s);
            }
        }, new PrimitiveDecoders<Integer>(){

            public Integer decode(String s) throws DecodeException {
                return Integer.valueOf(s);
            }
        }, new PrimitiveDecoders<Long>(){

            public Long decode(String s) throws DecodeException {
                return Long.valueOf(s);
            }
        }, new PrimitiveDecoders<Short>(){

            public Short decode(String s) throws DecodeException {
                return Short.valueOf(s);
            }
        }};
        ALL = Collections.unmodifiableList(Arrays.asList(decoders));
        ALL_WRAPPED = PrimitiveDecoders.getWrappedAll();
    }
}

